/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.presenter;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.BinderValidationStatus;
import com.vaadin.data.BindingValidationStatus;
import com.vaadin.shared.Registration;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.User;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.component.ItemGroupPanel;
import org.openthinclient.web.thinclient.component.PropertyComponent;
import org.openthinclient.web.thinclient.model.DeleteMandate;
import org.openthinclient.web.thinclient.presenter.ItemGroupPanelPresenter;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.viritin.button.MButton;

public class DirectoryObjectPanelPresenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryObjectPanelPresenter.class);
    private final IMessageConveyor mc;
    AbstractThinclientView thinclientView;
    ProfilePanel view;
    DirectoryObject directoryObject;
    Function<DirectoryObject, DeleteMandate> deleteMandatSupplier;
    Registration copyClickListenerRegistration;
    Consumer<ProfilePanel> valuesWrittenConsumer;

    public DirectoryObjectPanelPresenter(AbstractThinclientView thinclientView, ProfilePanel view, DirectoryObject directoryObject) {
        this.thinclientView = thinclientView;
        this.view = view;
        this.directoryObject = directoryObject;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        view.getDeleteProfileAction().addClickListener(this::handleDeleteAction);
        this.copyClickListenerRegistration = view.getCopyAction().addClickListener(this::handleCopyAction);
        view.getSaveButton().addClickListener(this::save);
        view.getResetButton().addClickListener(this::reset);
    }

    public void expandMetaData() {
    }

    public void handleDeleteAction(Button.ClickEvent event) {
        DeleteMandate mandate;
        VerticalLayout content = new VerticalLayout();
        Window window = new Window(null, (Component)content);
        window.setModal(true);
        window.setPositionX(200);
        window.setPositionY(50);
        boolean deletionAllowed = true;
        if (this.deleteMandatSupplier != null && !(deletionAllowed = (mandate = this.deleteMandatSupplier.apply(this.directoryObject)).checkDelete())) {
            window.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DELETE_NOT_POSSIBLE_HEADER, new Object[0]));
            content.addComponent((Component)new Label(mandate.getMessage()));
        }
        if (deletionAllowed) {
            window.setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_CONFIRM_DELETE, new Object[0]));
            content.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_CONFIRM_DELETE_OBJECT_TEXT, new Object[]{this.directoryObject.getName()})));
            HorizontalLayout hl = new HorizontalLayout();
            hl.addComponents(new Component[]{new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CANCEL, new Object[0]), (Button.ClickListener & Serializable)event1 -> window.close()), new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DELETE, new Object[0]), (Button.ClickListener & Serializable)event1 -> {
                Realm realm = this.directoryObject.getRealm();
                try {
                    realm.getDirectory().delete((Object)this.directoryObject);
                }
                catch (DirectoryException e) {
                    e.printStackTrace();
                }
                window.close();
                UI.getCurrent().removeWindow(window);
                this.thinclientView.navigateTo(null);
                this.thinclientView.selectItem(null);
            })});
            content.addComponent((Component)hl);
        }
        UI.getCurrent().addWindow(window);
    }

    public void handleCopyAction(Button.ClickEvent event) {
        try {
            String newName = this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_COPY_TARGET_NAME, new Object[]{this.directoryObject.getName()});
            int i = 1;
            while (this.thinclientView.getFreshProfile(newName) != null) {
                newName = this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_COPY_TARGET_NAME_WITH_NUMBER, new Object[]{i, this.directoryObject.getName()});
                ++i;
            }
            DirectoryObject copy = (DirectoryObject)this.directoryObject.getClass().newInstance();
            copy.setName(newName);
            copy.setDescription(this.directoryObject.getDescription());
            copy.setRealm(this.directoryObject.getRealm());
            if (this.directoryObject instanceof ApplicationGroup) {
                ApplicationGroup applicationGroup = (ApplicationGroup)this.directoryObject;
                ApplicationGroup copyApplicationGroup = (ApplicationGroup)copy;
                copyApplicationGroup.setApplications(applicationGroup.getApplications());
            } else if (this.directoryObject instanceof User) {
                User user = (User)this.directoryObject;
                User copyUser = (User)copy;
                copyUser.setUserGroups(user.getUserGroups());
                copyUser.setApplicationGroups(user.getApplicationGroups());
                copyUser.setApplications(user.getApplications());
                copyUser.setPrinters(user.getPrinters());
            }
            this.thinclientView.save(copy);
            this.thinclientView.navigateTo(copy);
            this.thinclientView.selectItem(copy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setItemGroups(List<OtcPropertyGroup> groups) {
        LOGGER.debug("Create properties for " + groups.stream().map(OtcPropertyGroup::getLabel).collect(Collectors.toList()));
        VerticalLayout rows = this.view.getRows();
        OtcPropertyGroup metaData = groups.get(0);
        ItemGroupPanel metaDataIGP = new ItemGroupPanel(metaData);
        ItemGroupPanelPresenter mdIgppGeneral = new ItemGroupPanelPresenter(metaDataIGP);
        mdIgppGeneral.setValuesWrittenConsumer(metaData.getValueWrittenConsumer());
        mdIgppGeneral.applyValuesChangedConsumer(components -> this.setSaveButtonEnabled(true));
        rows.addComponent((Component)metaDataIGP);
        OtcPropertyGroup root = groups.get(1);
        if (root.getOtcProperties().size() > 0) {
            ItemGroupPanel general = new ItemGroupPanel(root.getOtcProperties());
            ItemGroupPanelPresenter igppGeneral = new ItemGroupPanelPresenter(general);
            igppGeneral.setValuesWrittenConsumer(root.getValueWrittenConsumer());
            igppGeneral.applyValuesChangedConsumer(components -> this.setSaveButtonEnabled(true));
            rows.addComponent((Component)general);
        }
        root.getGroups().forEach(group -> {
            ItemGroupPanel view = new ItemGroupPanel((OtcPropertyGroup)group);
            ItemGroupPanelPresenter igpp = new ItemGroupPanelPresenter(view);
            igpp.setValuesWrittenConsumer(group.getValueWrittenConsumer());
            igpp.applyValuesChangedConsumer(components -> this.setSaveButtonEnabled(true));
            rows.addComponent((Component)view);
        });
    }

    public void setPanelMetaInformation(List<Component> components) {
        this.view.setPanelMetaInformation(components);
        this.view.showMetaInformation();
    }

    public void hideCopyButton() {
        this.view.getCopyAction().setVisible(false);
    }

    public void addPanelCaptionComponent(Component component) {
        this.view.addPanelCaptionComponent(component);
    }

    public void hideDeleteButton() {
        this.view.getDeleteProfileAction().setVisible(false);
    }

    public void setDeleteMandate(Function<DirectoryObject, DeleteMandate> deleteMandatSupplier) {
        this.deleteMandatSupplier = deleteMandatSupplier;
    }

    public void setSaveButtonEnabled(boolean enabled) {
        this.view.getSaveButton().setEnabled(enabled);
    }

    public List<ItemGroupPanel> getItemGroupPanels() {
        ArrayList<ItemGroupPanel> igpList = new ArrayList<ItemGroupPanel>();
        VerticalLayout rows = this.view.getRows();
        for (int i = 0; i < rows.getComponentCount(); ++i) {
            igpList.add((ItemGroupPanel)rows.getComponent(i));
        }
        return igpList;
    }

    public void setInfo(String message) {
        this.view.setInfo(message);
    }

    public void setError(String message) {
        this.view.setError(message);
    }

    void save(Button.ClickEvent event) {
        this.view.setInfo("");
        ArrayList errors = new ArrayList();
        this.getItemGroupPanels().forEach(igp -> {
            igp.emptyValidationMessages();
            for (PropertyComponent bc : igp.propertyComponents()) {
                if (bc.getBinder().writeBeanIfValid(bc.getBinder().getBean())) {
                    LOGGER.debug("Bean valid " + bc.getBinder().getBean());
                    continue;
                }
                BinderValidationStatus validate = bc.getBinder().validate();
                String errorText = validate.getFieldValidationStatuses().stream().filter(BindingValidationStatus::isError).map(BindingValidationStatus::getMessage).map(Optional::get).distinct().collect(Collectors.joining(", "));
                errors.add(errorText);
                OtcProperty bean = (OtcProperty)bc.getBinder().getBean();
                igp.setValidationMessage(bean.getKey(), errorText);
            }
        });
        if (errors.isEmpty()) {
            this.valuesWrittenConsumer.accept(this.view);
        } else {
            this.view.setError(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_NOT_SAVED, new Object[0]));
        }
    }

    public void onValuesWritten(Consumer<ProfilePanel> consumer) {
        this.valuesWrittenConsumer = consumer;
    }

    void reset(Button.ClickEvent event) {
        this.view.setInfo("");
        this.getItemGroupPanels().forEach(igp -> {
            igp.emptyValidationMessages();
            igp.propertyComponents().forEach(propertyComponent -> {
                OtcProperty bean = (OtcProperty)propertyComponent.getBinder().getBean();
                bean.getConfiguration().setValue(bean.getInitialValue());
                propertyComponent.getBinder().readBean((Object)bean);
            });
        });
    }

    public void replaceCopyClickListener(Button.ClickListener bc) {
        this.copyClickListenerRegistration.remove();
        this.view.getCopyAction().addClickListener(bc);
    }
}

