/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.presenter;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.ui.Button;
import com.vaadin.ui.UI;
import java.util.Set;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Profile;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.presenter.DirectoryObjectPanelPresenter;

public class ProfilePanelPresenter
extends DirectoryObjectPanelPresenter {
    private Profile profile;
    private IMessageConveyor mc;

    public ProfilePanelPresenter(AbstractThinclientView thinclientView, ProfilePanel view, Profile profile) {
        super(thinclientView, view, (DirectoryObject)profile);
        this.profile = profile;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.replaceCopyClickListener(this::handleCopyAction);
    }

    @Override
    public void handleCopyAction(Button.ClickEvent event) {
        try {
            String newName = this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_COPY_TARGET_NAME, new Object[]{this.profile.getName()});
            int i = 1;
            while (this.thinclientView.getFreshProfile(newName) != null) {
                newName = this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_COPY_TARGET_NAME_WITH_NUMBER, new Object[]{i, this.profile.getName()});
                ++i;
            }
            Profile copy = (Profile)this.profile.getClass().newInstance();
            copy.setName(newName);
            copy.setDescription(this.profile.getDescription());
            copy.setSchema(this.profile.getSchema(this.profile.getRealm()));
            Set keys = this.profile.getProperties().getMap().keySet();
            keys.forEach(s -> copy.setValue(s, this.profile.getValue(s)));
            if (this.profile instanceof Client) {
                Client client = (Client)this.profile;
                Client copyClient = (Client)copy;
                copyClient.setClientGroups(client.getClientGroups());
                copyClient.setApplicationGroups(client.getApplicationGroups());
                copyClient.setApplications(client.getApplications());
                copyClient.setPrinters(client.getPrinters());
            } else if (this.profile instanceof Location) {
                Location location = (Location)this.profile;
                Location copyLocation = (Location)copy;
                copyLocation.setPrinters(location.getPrinters());
            } else if (this.profile instanceof HardwareType) {
                HardwareType hardwareType = (HardwareType)this.profile;
                HardwareType copyHardwareType = (HardwareType)copy;
                copyHardwareType.setDevices(hardwareType.getDevices());
            }
            this.thinclientView.save((DirectoryObject)copy);
            this.thinclientView.navigateTo((DirectoryObject)copy);
            this.thinclientView.selectItem((DirectoryObject)copy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

