/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.presenter;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.ui.components.grid.MultiSelectionModel;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.component.ProfilesListOverviewPanel;
import org.openthinclient.web.thinclient.exception.AllItemsListException;
import org.vaadin.viritin.button.MButton;

public class ProfilesListOverviewPanelPresenter {
    private AbstractThinclientView thinclientView;
    private ProfilesListOverviewPanel panel;
    private Registration addClickListenerRegistration = null;
    private Registration deleteClickListenerRegistration = null;
    private Supplier<Set<DirectoryObject>> itemsSupplier = null;

    public ProfilesListOverviewPanelPresenter(AbstractThinclientView thinclientView, ProfilesListOverviewPanel panel) {
        this.thinclientView = thinclientView;
        this.panel = panel;
        this.addNewButtonClickHandler((Button.ClickListener & Serializable)e -> UI.getCurrent().getNavigator().navigateTo(thinclientView.getViewName() + "/create"));
        this.addDeleteButtonClickHandler(this::handleDeleteAction);
        panel.setItemButtonClickedConsumer(dirObj -> UI.getCurrent().getNavigator().navigateTo(thinclientView.getViewName() + "/" + dirObj.getName()));
    }

    private void handleDeleteAction(Button.ClickEvent event) {
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        MultiSelectionModel selectionModel = (MultiSelectionModel)this.panel.getItemGrid().getSelectionModel();
        Set selectedItems = selectionModel.getSelectedItems();
        VerticalLayout content = new VerticalLayout();
        Window window = new Window(null, (Component)content);
        window.setModal(true);
        window.setPositionX(200);
        window.setPositionY(50);
        boolean deletionAllowed = true;
        if (deletionAllowed) {
            window.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_CONFIRM_DELETE, new Object[0]));
            if (selectedItems.size() == 1) {
                content.addComponent((Component)new Label(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_CONFIRM_DELETE_OBJECT_TEXT, new Object[]{((DirectoryObject)selectedItems.iterator().next()).getName()})));
            } else {
                StringJoiner sj = new StringJoiner(",<br>");
                selectedItems.forEach(item -> sj.add(item.getName()));
                content.addComponent((Component)new Label(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_CONFIRM_DELETE_OBJECTS_TEXT, new Object[]{sj.toString()}), ContentMode.HTML));
            }
            HorizontalLayout hl = new HorizontalLayout();
            hl.addComponents(new Component[]{new MButton(mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CANCEL, new Object[0]), (Button.ClickListener & Serializable)event1 -> window.close()), new MButton(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DELETE, new Object[0]), (Button.ClickListener & Serializable)event1 -> {
                selectedItems.forEach(item -> {
                    Realm realm = item.getRealm();
                    try {
                        realm.getDirectory().delete(item);
                    }
                    catch (DirectoryException e) {
                        this.thinclientView.showError((Exception)((Object)e));
                    }
                });
                try {
                    Set<DirectoryObject> allItems = this.itemsSupplier == null ? this.thinclientView.getAllItems() : this.itemsSupplier.get();
                    ListDataProvider dataProvider = DataProvider.ofCollection(allItems);
                    dataProvider.setSortComparator(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase)::compare);
                    this.panel.getItemGrid().setDataProvider((DataProvider)dataProvider);
                    this.thinclientView.selectItem(null);
                    this.panel.getCheckBox().setValue(Boolean.valueOf(false));
                }
                catch (AllItemsListException e) {
                    this.thinclientView.showError(e);
                }
                window.close();
                UI.getCurrent().removeWindow(window);
            })});
            content.addComponent((Component)hl);
        }
        if (selectedItems.size() > 0) {
            UI.getCurrent().addWindow(window);
        }
    }

    public void addNewButtonClickHandler(Button.ClickListener clickListener) {
        if (this.addClickListenerRegistration != null) {
            this.addClickListenerRegistration.remove();
        }
        this.addClickListenerRegistration = this.panel.getAddButton().addClickListener(clickListener);
    }

    public void addDeleteButtonClickHandler(Button.ClickListener clickListener) {
        if (this.deleteClickListenerRegistration != null) {
            this.deleteClickListenerRegistration.remove();
        }
        this.deleteClickListenerRegistration = this.panel.getDeleteButton().addClickListener(clickListener);
    }

    public void setItemButtonClickedConsumer(Consumer<DirectoryObject> itemButtonClickedConsumer) {
        this.panel.setItemButtonClickedConsumer(itemButtonClickedConsumer);
    }

    public void setDataProvider(ListDataProvider<DirectoryObject> dataProvider) {
        this.panel.getItemGrid().setDataProvider(dataProvider);
    }

    public void setVisible(boolean visible) {
        this.panel.setVisible(visible);
    }

    public void setItemsSupplier(Supplier<Set<DirectoryObject>> itemsSupplier) {
        this.itemsSupplier = itemsSupplier;
    }
}

