/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web;

import com.vaadin.ui.UI;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.common.model.DirectoryObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Audit {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Audit");

    private static void log(String op, String type, String ... details) {
        if (details == null) {
            details = new String[]{};
        }
        String ip = UI.getCurrent().getPage().getWebBrowser().getAddress();
        LOGGER.info(Stream.concat(Stream.of(ip, op, type), Arrays.stream(details)).map(str -> Objects.isNull(str) ? "" : str).collect(Collectors.joining("\t")));
    }

    private static void log(String op, DirectoryObject directoryObject) {
        Audit.log(op, directoryObject.getClass().getSimpleName(), directoryObject.getName(), directoryObject.getDn());
    }

    public static void logSave(String type, String ... details) {
        Audit.log("SAVE", type, details);
    }

    public static void logSave(DirectoryObject directoryObject) {
        Audit.log("SAVE", directoryObject);
    }

    public static void logDelete(String type, String ... details) {
        Audit.log("DELETE", type, details);
    }

    public static void logDelete(DirectoryObject directoryObject) {
        Audit.log("DELETE", directoryObject);
    }

    public static void logDeleteUninstall(DirectoryObject directoryObject) {
        Audit.log("DELETE (UNINSTALL)", directoryObject);
    }
}

