/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.Serializable;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.layouts.MHorizontalLayout;
import org.vaadin.viritin.layouts.MVerticalLayout;

public abstract class AbstractSummaryDialog {
    protected final Window window = new Window();
    protected final MHorizontalLayout footer;
    protected final MButton cancelButton;
    protected final MButton proceedButton;
    protected final IMessageConveyor mc;
    protected volatile boolean initialized;
    private MVerticalLayout content;

    public AbstractSummaryDialog() {
        this.window.setWidth(60.0f, Sizeable.Unit.PERCENTAGE);
        this.window.setHeight(null);
        this.window.center();
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.proceedButton = ((MButton)new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_YES, new Object[0])).withStyleName(new String[]{"primary"})).withListener((Button.ClickListener & Serializable)e -> this.onProceed());
        this.cancelButton = new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CANCEL, new Object[0])).withListener((Button.ClickListener & Serializable)e -> this.onCancel());
        this.footer = ((MHorizontalLayout)((MHorizontalLayout)new MHorizontalLayout().withFullWidth()).withStyleName(new String[]{"v-window-bottom-toolbar"})).with(new Component[]{this.proceedButton, this.cancelButton});
        this.footer.setComponentAlignment((Component)this.proceedButton, Alignment.TOP_RIGHT);
        this.footer.setExpandRatio((Component)this.proceedButton, 1.0f);
    }

    protected abstract void onCancel();

    protected abstract void createContent(MVerticalLayout var1);

    protected void initialize() {
        this.content = (MVerticalLayout)((MVerticalLayout)new MVerticalLayout().withMargin(true)).withSpacing(true);
        this.createContent(this.content);
        this.content.addComponent((Component)this.footer);
        this.window.setContent((Component)this.content);
    }

    public abstract void update();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean modal) {
        this.window.setModal(modal);
        if (!this.isOpen()) {
            if (!this.initialized) {
                AbstractSummaryDialog abstractSummaryDialog = this;
                synchronized (abstractSummaryDialog) {
                    if (!this.initialized) {
                        this.initialize();
                        this.initialized = true;
                    }
                }
            }
            this.update();
            UI.getCurrent().addWindow(this.window);
        }
    }

    public boolean isOpen() {
        return UI.getCurrent().getWindows().contains(this.window);
    }

    public void close() {
        UI.getCurrent().removeWindow(this.window);
    }

    protected abstract void onProceed();
}

