/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.view;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.event.selection.SelectionListener;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Grid;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.ComponentRenderer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.design.PackageListMasterDetailsDesign;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageListMasterDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.view.AbstractPackageItem;
import org.openthinclient.web.pkgmngr.ui.view.ResolvedPackageItem;

public class PackageListMasterDetailsView
extends PackageListMasterDetailsDesign
implements PackageListMasterDetailsPresenter.View {
    private static final long serialVersionUID = 6572660094735789367L;
    private DataProvider<AbstractPackageItem, ?> packageListDataProvider;
    private Consumer<Package> showPackageDetailsConsumer;
    private boolean detailsVisible;
    private float previousSplitPosition;
    private Sizeable.Unit previousSplitPositionUnit;

    public PackageListMasterDetailsView() {
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setDataProvider((DataProvider<AbstractPackageItem, ?>)DataProvider.ofCollection(Collections.emptyList()));
        this.packageList.setSelectionMode(Grid.SelectionMode.MULTI);
        this.packageList.addColumn(AbstractPackageItem::getName).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_NAME, new Object[0])).setId("name");
        this.packageList.addColumn(AbstractPackageItem::getDisplayVersion).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_VERSION, new Object[0])).setId("displayVersion");
        this.packageList.addColumn(arg_0 -> this.lambda$new$13ad784b$1((IMessageConveyor)mc, arg_0), (AbstractRenderer)new ComponentRenderer()).setCaption("");
        this.detailsVisible = true;
        this.setDetailsVisible(false);
        this.previousSplitPosition = 70.0f;
        this.previousSplitPositionUnit = Sizeable.Unit.PERCENTAGE;
        this.sourceUpdateButton.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SOURCE_UPDATE_NOW_BUTTON, new Object[0]));
    }

    @Override
    public void setDataProvider(DataProvider<AbstractPackageItem, ?> dataProvider) {
        this.packageListDataProvider = dataProvider;
        this.packageList.setDataProvider(this.packageListDataProvider);
    }

    @Override
    public void onPackageSelected(Consumer<Collection<Package>> consumer) {
        this.packageList.addSelectionListener((SelectionListener & Serializable)event -> {
            Set value = event.getAllSelectedItems();
            consumer.accept(value.stream().map(rpi -> ((ResolvedPackageItem)rpi).getPackage()).collect(Collectors.toCollection(ArrayList::new)));
        });
    }

    @Override
    public void onShowPackageDetails(Consumer<Package> consumer) {
        this.showPackageDetailsConsumer = consumer;
    }

    public ComponentContainer getDetailsContainer() {
        return this.detailsContainer;
    }

    @Override
    public Button getSearchButton() {
        return this.searchButton;
    }

    @Override
    public TextField getSearchField() {
        return this.searchTextField;
    }

    @Override
    public CheckBox getPackageFilerCheckbox() {
        return this.packageFilerCheckbox;
    }

    @Override
    public void sort(PackageListMasterDetailsPresenter.View.SortableProperty property, SortDirection direction) {
        this.packageList.sort(property.getBeanPropertyName(), direction);
    }

    @Override
    public void hideSourceUpdatePanel() {
        this.sourceUpdatePanel.setVisible(false);
    }

    @Override
    public void setSourceUpdateLabelValue(String text) {
        this.sourceUpdateLabel.setValue(text);
    }

    @Override
    public Button getSourceUpdateButton() {
        return this.sourceUpdateButton;
    }

    @Override
    public void clearSelection() {
        this.packageList.getSelectionModel().deselectAll();
    }

    @Override
    public void setDetailsVisible(boolean visible) {
        if (this.detailsVisible == visible) {
            return;
        }
        if (this.detailsVisible) {
            this.previousSplitPosition = this.splitPanel.getSplitPosition();
            this.previousSplitPositionUnit = this.splitPanel.getSplitPositionUnit();
            this.splitPanel.setSplitPosition(99.0f, Sizeable.Unit.PERCENTAGE);
        } else {
            this.splitPanel.setSplitPosition(this.previousSplitPosition, this.previousSplitPositionUnit);
        }
        this.detailsVisible = visible;
    }

    private /* synthetic */ Component lambda$new$13ad784b$1(IMessageConveyor mc, AbstractPackageItem item) {
        Button moreButton = new Button();
        moreButton.addStyleName("details-button");
        moreButton.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_LIST_DETAILS_CAPTION, new Object[0]));
        moreButton.setIcon((Resource)VaadinIcons.INFO_CIRCLE_O);
        moreButton.addStyleNames(new String[]{"link"});
        moreButton.addClickListener((Button.ClickListener & Serializable)e -> {
            if (this.showPackageDetailsConsumer != null && item instanceof ResolvedPackageItem) {
                this.showPackageDetailsConsumer.accept(((ResolvedPackageItem)item).getPackage());
            }
        });
        return moreButton;
    }
}

