/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.support;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.openthinclient.api.ldif.export.LdifExporterService;
import org.openthinclient.api.ldif.export.LdifImporterService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.filebrowser.FileUploadSubWindow;
import org.openthinclient.web.filebrowser.FileUploadView;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.SettingsUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="ldif-import-export", ui={SettingsUI.class})
@SideBarItem(sectionId="server-management", captionCode="UI_SUPPORT_LDIF_IMPORT_EXPORT_HEADER", order=71)
public class LdifImportExportView
extends Panel
implements View,
FileUploadView {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdifImportExportView.class);
    @Autowired
    protected ManagerHome managerHome;
    @Autowired
    private RealmService realmService;
    private MyReceiver receiver = new MyReceiver();
    final MessageConveyor mc;
    final VerticalLayout root;
    private Label importSuccessLabel;
    private Label importErrorLabel;
    private Label exportErrorLabel;
    private Label exportSuccessLabel;
    Set<LdifImporterService.State> importResult = new HashSet<LdifImporterService.State>();
    Set<LdifExporterService.State> exportResult = new HashSet<LdifExporterService.State>();

    public LdifImportExportView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setSizeFull();
        eventBus.publish((Object)this, (Object)new DashboardEvent.UpdateHeaderLabelEvent(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_IMPORT_EXPORT_HEADER, new Object[0])));
        this.root = new VerticalLayout();
        this.root.setSizeFull();
        this.root.setMargin(true);
        this.root.setStyleName("importexport");
        this.setContent((Component)this.root);
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_IMPORT_EXPORT_HEADER, new Object[0]);
    }

    @PostConstruct
    private void init() {
        this.buildContent();
    }

    private void buildContent() {
        VerticalLayout content = new VerticalLayout();
        Label labelImportDescription = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_IMPORT_DESCRIPTION, new Object[0]), ContentMode.HTML);
        content.addComponent((Component)labelImportDescription);
        HorizontalLayout importHL = new HorizontalLayout();
        content.addComponent((Component)importHL);
        this.importSuccessLabel = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_IMPORT_SUCCESS, new Object[0]), ContentMode.HTML);
        this.importSuccessLabel.setVisible(false);
        this.importErrorLabel = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_IMPORT_FAILED, new Object[0]), ContentMode.HTML);
        this.importErrorLabel.setVisible(false);
        this.importErrorLabel.setStyleName("unexpected_error");
        Upload upload = new Upload(null, (Upload.Receiver)this.receiver);
        upload.addStyleName("ldif-import");
        upload.setButtonCaption("LDIF Import");
        upload.setAcceptMimeTypes("text/ldif");
        upload.addSucceededListener((Upload.SucceededListener)this.receiver);
        upload.setImmediateMode(true);
        upload.addStartedListener((Upload.StartedListener & Serializable)e -> {
            this.importSuccessLabel.setVisible(false);
            this.importErrorLabel.setVisible(false);
        });
        importHL.addComponents(new Component[]{upload, this.importSuccessLabel, this.importErrorLabel});
        content.addComponent((Component)new Label("<hr/>", ContentMode.HTML));
        Label labelExportDescription = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_EXPORT_DESCRIPTION, new Object[0]), ContentMode.HTML);
        content.addComponent((Component)labelExportDescription);
        HorizontalLayout exportHL = new HorizontalLayout();
        content.addComponent((Component)exportHL);
        this.exportSuccessLabel = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_EXPORT_SUCCESS, new Object[0]), ContentMode.HTML);
        this.exportSuccessLabel.setVisible(false);
        this.exportErrorLabel = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_EXPORT_FAILED, new Object[0]), ContentMode.HTML);
        this.exportErrorLabel.setVisible(false);
        this.exportErrorLabel.setStyleName("unexpected_error");
        Button exportButton = new Button("LDIF Export");
        exportButton.addStyleName("ldif-export");
        FileDownloader fileDownloader = new FileDownloader((Resource)this.createResource());
        fileDownloader.extend((AbstractComponent)exportButton);
        exportHL.addComponents(new Component[]{exportButton, this.exportSuccessLabel, this.exportErrorLabel});
        this.root.addComponent((Component)content);
        this.root.setExpandRatio((Component)content, 1.0f);
    }

    private StreamResource createResource() {
        return new StreamResource((StreamResource.StreamSource & Serializable)() -> {
            LdifExporterService ldifExporterService = new LdifExporterService(this.realmService.getDefaultRealm().getConnectionDescriptor());
            byte[] bytes = ldifExporterService.performAction(Collections.singleton(""), this.exportResult::add);
            if (this.exportResult.contains(LdifExporterService.State.ERROR) || this.exportResult.contains(LdifExporterService.State.EXCEPTION)) {
                this.exportErrorLabel.setVisible(true);
                return null;
            }
            this.exportSuccessLabel.setVisible(true);
            return new ByteArrayInputStream(bytes);
        }, "openthinclient-export.ldif");
    }

    @Override
    public void uploadSucceed(Path file) {
        LdifImporterService lis = new LdifImporterService(this.realmService.getDefaultRealm().getConnectionDescriptor());
        try {
            lis.importTempFile(file.toFile(), this.importResult::add);
            if (this.importResult.contains(LdifImporterService.State.ERROR) || this.importResult.contains(LdifImporterService.State.EXCEPTION)) {
                this.importErrorLabel.setVisible(true);
            } else {
                this.importSuccessLabel.setVisible(true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to import file " + file.getFileName(), (Throwable)e);
            this.importErrorLabel.setVisible(true);
        }
    }

    @Override
    public void uploadFailed(Exception exception) {
        this.importErrorLabel.setVisible(true);
        LOGGER.error("Failed to import ldif-file.", (Throwable)exception);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    public class MyReceiver
    implements Upload.Receiver,
    Upload.SucceededListener,
    Upload.FailedListener {
        private static final long serialVersionUID = -5844542658116931976L;
        private final transient Logger LOGGER = LoggerFactory.getLogger(FileUploadSubWindow.MyReceiver.class);
        public Path file;

        public OutputStream receiveUpload(String filename, String mimeType) {
            FileOutputStream fos = null;
            try {
                this.file = LdifImportExportView.this.managerHome.getLocation().toPath().resolve(filename);
                fos = new FileOutputStream(this.file.toFile());
            }
            catch (FileNotFoundException e) {
                this.LOGGER.error("Could not open file", (Throwable)e);
                new Notification(LdifImportExportView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_UPLOAD_FAIL, new Object[0]), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                return null;
            }
            return fos;
        }

        public void uploadSucceeded(Upload.SucceededEvent event) {
            LdifImportExportView.this.uploadSucceed(this.file);
        }

        public void uploadFailed(Upload.FailedEvent failedEvent) {
        }
    }
}

