/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.web.Audit;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.AllItemsListException;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.exception.ProfileNotSavedException;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.SettingsUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="realm_settings_view", ui={SettingsUI.class})
@SideBarItem(sectionId="server-management", captionCode="UI_SETTINGS_HEADER", order=10)
public final class RealmSettingsView
extends AbstractThinclientView {
    public static final String NAME = "realm_settings_view";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_SETTINGS_HEADER;
    private static final Logger LOGGER = LoggerFactory.getLogger(RealmSettingsView.class);
    private IMessageConveyor mc;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="settingsSideBar")
    private OTCSideBar settingsSideBar;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    public RealmSettingsView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_SETTINGS_HEADER, eventBus, notificationService);
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
    }

    @Override
    public HashSet getAllItems() throws AllItemsListException {
        try {
            Set allRealms = this.getRealmService().findAllRealms();
            HashSet hashSet = new HashSet();
            hashSet.addAll(allRealms);
            return hashSet;
        }
        catch (Exception e) {
            throw new AllItemsListException("Cannot load settings.", e);
        }
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(Realm.class, schemaName);
    }

    @Override
    public Map<String, String> getSchemaNames() {
        return Stream.of(this.schemaProvider.getSchemaNames(Realm.class)).collect(Collectors.toMap(schemaName -> schemaName, schemaName -> this.getSchema((String)schemaName).getLabel()));
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) throws BuildProfileException {
        Profile profile = (Profile)directoryObject;
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), profile);
        ProfilePanel profilePanel = new ProfilePanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SETTINGS_HEADER, new Object[0]), profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractThinclientView)this, profilePanel, profile);
        presenter.hideCopyButton();
        presenter.hideDeleteButton();
        otcPropertyGroups.get(0).removeProperty("name");
        otcPropertyGroups.get(0).removeProperty("type");
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        return null;
    }

    @Override
    public Client getClient(String name) {
        return null;
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String name) {
        Set allRealms = this.getRealmService().findAllRealms();
        Optional<Realm> first = allRealms.stream().filter(realm -> realm.getName().equals(name)).findFirst();
        if (first.isPresent()) {
            Realm realm2 = first.get();
            try {
                realm2.refresh();
            }
            catch (DirectoryException e) {
                LOGGER.error("Failed to refresh realm: " + e.getMessage(), (Throwable)e);
            }
            return (T)realm2;
        }
        return (T)new Realm();
    }

    @Override
    public void save(DirectoryObject profile) throws ProfileNotSavedException {
        LOGGER.info("Save realm-settings: " + profile);
        try {
            ((Realm)profile).getDirectory().save((Object)profile);
            ((Realm)profile).refresh();
            Audit.logSave("Realm settings", new String[0]);
        }
        catch (DirectoryException e) {
            throw new ProfileNotSavedException("Cannot save object " + profile, (Exception)((Object)e));
        }
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.settingsSideBar));
    }

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        LOGGER.info(this.getViewName() + ".enter(), load RealmConfiguration and update view.");
        try {
            Object realmConfiguration = this.getFreshProfile("RealmConfiguration");
            ProfilePanel profilePanel = this.createProfilePanel((DirectoryObject)realmConfiguration);
            ProfileReferencesPanel profileReferencesPanel = this.createReferencesPanel((DirectoryObject)realmConfiguration);
            this.displayProfilePanel(profilePanel, profileReferencesPanel);
        }
        catch (BuildProfileException e) {
            this.showError(e);
        }
    }
}

