/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientGroupView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;

@SpringView(name="usergroup_view", ui={ManagerUI.class})
public final class UserGroupView
extends AbstractThinclientGroupView {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupView.class);
    public static final String NAME = "usergroup_view";
    public static final String ICON = "icon/applicationgroup-white.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_USERGROUP_HEADER;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    private boolean secondaryDirectory = false;
    private final IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());

    public UserGroupView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, eventBus, notificationService);
    }

    @PostConstruct
    public void setup() {
        this.secondaryDirectory = "secondary".equals(this.getRealmService().getDefaultRealm().getValue("UserGroupSettings.DirectoryVersion"));
        this.addStyleName("user_view");
        if (!this.secondaryDirectory) {
            this.addCreateActionButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_ADD_GROUP_LABEL, new Object[0]), ICON, "usergroup_view/create");
        }
    }

    @Override
    public Set getAllItems() {
        return this.userGroupService.findAll();
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(UserGroup.class, schemaName);
    }

    @Override
    public Map<String, String> getSchemaNames() {
        return Stream.of(this.schemaProvider.getSchemaNames(UserGroup.class)).collect(Collectors.toMap(schemaName -> schemaName, schemaName -> this.getSchema((String)schemaName).getLabel()));
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        UserGroup userGroup = (UserGroup)item;
        Set members = userGroup.getMembers();
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(UserGroup.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set allUsers = this.userService.findAll();
        this.getRealmService().findAllRealms().forEach(realm -> allUsers.removeAll(realm.getAdministrators().getMembers()));
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USER_HEADER, new Object[0]), allUsers, User.class, values -> this.saveReference((DirectoryObject)userGroup, (List<Item>)values, allUsers, User.class), null, this.secondaryDirectory);
        Set allApplicationGroups = this.applicationGroupService.findAll();
        refPresenter.showReference(userGroup.getApplicationGroups(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), allApplicationGroups, ApplicationGroup.class, values -> this.saveReference((DirectoryObject)userGroup, (List<Item>)values, allApplicationGroups, ApplicationGroup.class));
        Set allApplicatios = this.applicationService.findAll();
        refPresenter.showReference(userGroup.getApplications(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), allApplicatios, Application.class, values -> this.saveReference((DirectoryObject)userGroup, (List<Item>)values, allApplicatios, Application.class));
        Set allPrinters = this.printerService.findAll();
        refPresenter.showReference(userGroup.getPrinters(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PRINTER_HEADER, new Object[0]), allPrinters, Printer.class, values -> this.saveReference((DirectoryObject)userGroup, (List<Item>)values, allPrinters, Printer.class));
        return referencesPanel;
    }

    @Override
    protected OtcPropertyGroup createMetadataPropertyGroup(DirectoryObject directoryObject, boolean isNew) {
        OtcPropertyGroup group = super.createMetadataPropertyGroup(directoryObject, isNew);
        if (this.secondaryDirectory) {
            group.getOtcProperties().forEach(p -> p.getConfiguration().disable());
        }
        return group;
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject, boolean isNew) {
        return super.createProfilePanel(directoryObject, isNew || this.secondaryDirectory);
    }

    public UserGroup getFreshProfile(String name) {
        return (UserGroup)this.userGroupService.findByName(name);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.userGroupService.save((DirectoryObject)((UserGroup)profile));
        Audit.logSave(profile);
    }

    @Override
    public Client getClient(String name) {
        return (Client)this.clientService.findByName(name);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public String getParentViewName() {
        return "user_view";
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }
}

