/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.annotations.Push;
import com.vaadin.annotations.Theme;
import com.vaadin.event.MouseEvents;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.communication.PushMode;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.spring.navigator.SpringViewProvider;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Locale;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.i18n.LocaleUtil;
import org.openthinclient.pkgmgr.progress.PackageManagerExecutionEngine;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.progress.Registration;
import org.openthinclient.service.common.license.LicenseChangeEvent;
import org.openthinclient.service.common.license.LicenseManager;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.component.LicenseMessageBar;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.UserProfileSubWindow;
import org.openthinclient.web.ui.event.PackageManagerTaskActivatedEvent;
import org.openthinclient.web.ui.event.PackageManagerTaskFinalizedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.security.VaadinSecurity;

@Theme(value="openthinclient")
@SpringUI(path="/settings")
@Push(value=PushMode.MANUAL)
@com.vaadin.annotations.JavaScript(value={"UIFunctions.js"})
public final class SettingsUI
extends UI
implements ViewDisplay {
    private static final long serialVersionUID = 4314279050575370517L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsUI.class);
    @Autowired
    @Qualifier(value="settingsSideBar")
    OTCSideBar settingsSideBar;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    VaadinSecurity vaadinSecurity;
    @Autowired
    SpringViewProvider viewProvider;
    @Autowired
    PackageManagerExecutionEngine packageManagerExecutionEngine;
    @Autowired
    private EventBus.SessionEventBus eventBus;
    @Autowired
    private ClientService clientService;
    @Autowired
    private UserService userService;
    @Autowired
    private LicenseManager licenseManager;
    private Registration taskFinalizedRegistration;
    private Registration taskActivatedRegistration;
    private Panel springViewDisplay;
    private CssLayout dashboardPanels;
    private Window notificationsWindow;
    private ConsoleWebMessages i18nTitleKey;
    private IMessageConveyor mc;
    private AbstractOrderedLayout root;
    private Label titleLabel;
    private LicenseMessageBar licenseMessageBar;
    private Window searchResultWindow;
    private UserProfileSubWindow userProfileWindow;
    private Grid<DirectoryObject> resultObjectGrid;

    protected void onPackageManagerTaskFinalized(ListenableProgressFuture<?> listenableProgressFuture) {
        this.eventBus.publish((Object)this, (Object)new PackageManagerTaskFinalizedEvent(this.packageManagerExecutionEngine));
    }

    protected void onPackageManagerTaskActivated(ListenableProgressFuture<?> listenableProgressFuture) {
        this.eventBus.publish((Object)this, (Object)new PackageManagerTaskActivatedEvent(this.packageManagerExecutionEngine));
    }

    protected void init(VaadinRequest request) {
        this.setLocale(LocaleUtil.getLocaleForMessages(ConsoleWebMessages.class, (Locale)UI.getCurrent().getLocale()));
        Locale.setDefault(UI.getCurrent().getLocale());
        this.addStyleName("valo-menu-responsive");
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        Page.getCurrent().addBrowserWindowResizeListener((Page.BrowserWindowResizeListener & Serializable)event -> this.eventBus.publish((Object)this, (Object)new DashboardEvent.BrowserResizeEvent(event.getHeight(), event.getWidth())));
        Page.getCurrent().setTitle(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PAGE_TITLE, new Object[0]));
        this.taskActivatedRegistration = this.packageManagerExecutionEngine.addTaskActivatedHandler(this::onPackageManagerTaskActivated);
        this.taskFinalizedRegistration = this.packageManagerExecutionEngine.addTaskFinalizedHandler(this::onPackageManagerTaskFinalized);
        this.licenseMessageBar = new LicenseMessageBar(this.licenseManager, this.clientService);
        this.showMainScreen();
        JavaScript.getCurrent().execute("installGridTooltips()");
        JavaScript.getCurrent().execute("installInfoButtonFunction()");
        this.addClickListener((MouseEvents.ClickListener & Serializable)e -> this.eventBus.publish((Object)e, (Object)new DashboardEvent.CloseOpenWindowsEvent()));
        this.userProfileWindow = new UserProfileSubWindow(this.userService);
    }

    private void showMainScreen() {
        Image image = new Image(null, (Resource)new ThemeResource("logo.svg"));
        image.addClickListener((MouseEvents.ClickListener & Serializable)e -> UI.getCurrent().getPage().setLocation("/"));
        image.addStyleName("logo-button");
        image.removeStyleName("valo-menu-logo");
        this.settingsSideBar.setLogo((Component)image);
        this.root = new HorizontalLayout();
        this.root.setSpacing(false);
        this.root.setSizeFull();
        this.settingsSideBar.setId("mainmenu");
        this.root.addComponent((Component)this.settingsSideBar);
        VerticalLayout vl = new VerticalLayout();
        vl.setSpacing(false);
        vl.setMargin(false);
        vl.setSizeFull();
        vl.addComponents(new Component[]{this.buildHeader(), this.licenseMessageBar});
        CssLayout content = new CssLayout();
        content.addStyleName("view-content");
        content.setSizeFull();
        vl.addComponent((Component)content);
        vl.setExpandRatio((Component)content, 1.0f);
        Navigator navigator = new Navigator(UI.getCurrent(), (ComponentContainer)content);
        navigator.addViewChangeListener(new ViewChangeListener(){

            public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
                return true;
            }

            public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
                JavaScript.getCurrent().execute("disableSpellcheck()");
            }
        });
        navigator.addProvider((ViewProvider)this.viewProvider);
        if (navigator.getState().isEmpty()) {
            navigator.navigateTo("realm_settings_view");
        } else {
            navigator.navigateTo(navigator.getState());
        }
        this.root.addComponents(new Component[]{vl});
        this.root.setExpandRatio((Component)vl, 1.0f);
        this.setContent((Component)this.root);
    }

    @EventBusListenerMethod
    public void licenseChange(LicenseChangeEvent ev) {
        if (this.licenseMessageBar != null) {
            this.licenseMessageBar.updateContent();
            this.push();
        }
    }

    public void attach() {
        super.attach();
        this.eventBus.subscribe((Object)this);
    }

    public void detach() {
        this.taskActivatedRegistration.unregister();
        this.taskFinalizedRegistration.unregister();
        this.eventBus.unsubscribe((Object)this);
        super.detach();
    }

    private Component buildHeader() {
        HorizontalLayout header = new HorizontalLayout();
        header.setMargin(false);
        header.addStyleName("header");
        Component logout = this.buildLogoutButton();
        header.addComponent(logout);
        header.setComponentAlignment(logout, Alignment.MIDDLE_RIGHT);
        return header;
    }

    private Component buildLogoutButton() {
        HorizontalLayout hl = new HorizontalLayout();
        hl.setMargin(new MarginInfo(false, true, false, false));
        hl.setSpacing(false);
        UserDetails principal = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Label circle = new Label(principal.getUsername().substring(0, 1).toUpperCase());
        circle.addStyleName("header-circle");
        hl.addComponent((Component)circle);
        MenuBar menuBar = new MenuBar();
        menuBar.setWidth("100%");
        menuBar.addStyleName("borderless");
        menuBar.addStyleName("small");
        menuBar.addStyleName("header-menu");
        hl.addComponent((Component)menuBar);
        MenuBar.MenuItem file = menuBar.addItem(principal.getUsername(), null);
        file.addItem(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE, new Object[0]), this::showProfileSubWindow);
        file.addItem(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOGOUT, new Object[0]), (MenuBar.Command & Serializable)e -> {
            SecurityContext securityContext = (SecurityContext)VaadinSession.getCurrent().getSession().getAttribute("SPRING_SECURITY_CONTEXT");
            Authentication authentication = securityContext.getAuthentication();
            LOGGER.debug("Received UserLoggedOutEvent " + (authentication != null ? authentication.getPrincipal() : "null"));
            VaadinSession.getCurrent().close();
            this.vaadinSecurity.logout();
        });
        return hl;
    }

    private void showProfileSubWindow(MenuBar.MenuItem menuItem) {
        if (!UI.getCurrent().getWindows().contains((Object)this.userProfileWindow)) {
            SecurityContext securityContext = (SecurityContext)VaadinSession.getCurrent().getSession().getAttribute("SPRING_SECURITY_CONTEXT");
            Authentication authentication = securityContext.getAuthentication();
            UserDetails principal = (UserDetails)authentication.getPrincipal();
            try {
                this.userProfileWindow.refresh((User)this.userService.findByName(principal.getUsername()));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot find directory-object: " + e.getMessage());
                this.userProfileWindow.showError(e);
            }
            UI.getCurrent().addWindow((Window)this.userProfileWindow);
        } else {
            this.userProfileWindow.close();
            UI.getCurrent().removeWindow((Window)this.userProfileWindow);
        }
    }

    public void showView(View view) {
        this.springViewDisplay.setContent((Component)view);
    }
}

