/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.presenter;

import java.util.Collection;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.op.PackageManagerOperation;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.web.Audit;
import org.openthinclient.web.SchemaService;
import org.openthinclient.web.pkgmngr.ui.AffectedApplicationsSummaryDialog;
import org.openthinclient.web.pkgmngr.ui.InstallationPlanSummaryDialog;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageActionOverviewPresenter;
import org.openthinclient.web.progress.ProgressReceiverDialog;

public class PackageDetailsListPresenter {
    private final Mode mode;
    private final PackageActionOverviewPresenter packageActionOverviewPresenter;
    private final PackageManager packageManager;
    private final SchemaService schemaService;
    private final ApplicationService applicationService;
    private final ClientService clientService;

    public PackageDetailsListPresenter(Mode mode, PackageActionOverviewPresenter packageActionOverviewPresenter, PackageManager packageManager, SchemaService schemaService, ApplicationService applicationService, ClientService clientService) {
        this.mode = mode;
        this.packageActionOverviewPresenter = packageActionOverviewPresenter;
        packageActionOverviewPresenter.setMode(mode);
        this.packageManager = packageManager;
        this.schemaService = schemaService;
        this.applicationService = applicationService;
        this.clientService = clientService;
        this.setPackages(null);
    }

    public void setPackages(Collection<Package> otcPackages) {
        if (otcPackages == null || otcPackages.size() == 0) {
            this.packageActionOverviewPresenter.hide();
            return;
        }
        this.packageActionOverviewPresenter.show();
        this.packageActionOverviewPresenter.setPackages(otcPackages);
        this.packageActionOverviewPresenter.onPerformAction(() -> {
            switch (this.mode) {
                case UPDATE: 
                case INSTALL: {
                    this.doInstallPackages(otcPackages);
                    break;
                }
                case UNINSTALL: {
                    this.doUninstallPackages(otcPackages);
                }
            }
        });
    }

    private void doInstallPackages(Collection<Package> otcPackages) {
        PackageManagerOperation op = this.packageManager.createOperation();
        otcPackages.forEach(arg_0 -> ((PackageManagerOperation)op).install(arg_0));
        op.resolve();
        this.showSummaryDialog(op, () -> this.execute(op, true));
    }

    private void doUninstallPackages(Collection<Package> otcPackages) {
        PackageManagerOperation op = this.packageManager.createOperation();
        otcPackages.forEach(arg_0 -> ((PackageManagerOperation)op).uninstall(arg_0));
        op.resolve();
        Collection<Application> affectedApplications = this.schemaService.findAffectedApplications(op.getInstallPlan());
        if (!affectedApplications.isEmpty()) {
            AffectedApplicationsSummaryDialog dialog = new AffectedApplicationsSummaryDialog(affectedApplications);
            dialog.onProceed(() -> {
                dialog.close();
                this.showSummaryDialog(op, () -> {
                    for (Application affectedApplication : affectedApplications) {
                        this.applicationService.delete(affectedApplication);
                        Audit.logDeleteUninstall((DirectoryObject)affectedApplication);
                    }
                    this.execute(op, false);
                });
            });
            dialog.open(true);
        } else {
            this.showSummaryDialog(op, () -> this.execute(op, false));
        }
    }

    private void showSummaryDialog(PackageManagerOperation op, Runnable installCallback) {
        InstallationPlanSummaryDialog summaryDialog = new InstallationPlanSummaryDialog(op, this.packageManager);
        summaryDialog.onInstallClicked(installCallback);
        summaryDialog.open(true);
    }

    private void execute(PackageManagerOperation op, boolean install) {
        ProgressReceiverDialog dialog = new ProgressReceiverDialog(install ? "Installation..." : "Uninstallation...");
        ListenableProgressFuture future = this.packageManager.execute(op);
        dialog.watch(future);
        future.addCallback(result -> this.clientService.reloadAllSchemas(), ex -> {});
        dialog.open(true);
    }

    public static enum Mode {
        INSTALL,
        UNINSTALL,
        UPDATE;

    }
}

