/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.presenter;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerUtils;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.view.AbstractPackageItem;
import org.openthinclient.web.pkgmngr.ui.view.PackageDetailsView;
import org.openthinclient.web.pkgmngr.ui.view.PackageDetailsWindow;
import org.openthinclient.web.pkgmngr.ui.view.ResolvedPackageItem;
import org.openthinclient.web.progress.ProgressReceiverDialog;

public class PackageListMasterDetailsPresenter {
    protected final View view;
    protected final ListDataProvider<AbstractPackageItem> dataProvider;
    protected final PackageManager packageManager;
    protected final IMessageConveyor mc;

    public PackageListMasterDetailsPresenter(View view, Consumer<Collection<Package>> detailsPresenter, PackageManager packageManager, ClientService clientService) {
        this.view = view;
        this.dataProvider = new ListDataProvider(new ArrayList());
        this.view.setDataProvider((DataProvider<AbstractPackageItem, ?>)this.dataProvider);
        this.packageManager = packageManager;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        view.onPackageSelected(packages -> {
            if (packages == null || packages.size() == 0) {
                view.setDetailsVisible(false);
            } else {
                view.setDetailsVisible(true);
            }
            detailsPresenter.accept((Collection<Package>)packages);
        });
        this.view.getPackageFilerCheckbox().setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SHOW_ALL_VERSIONS, new Object[0]));
        this.view.getPackageFilerCheckbox().setValue(Boolean.valueOf(false));
        this.view.getPackageFilerCheckbox().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.applyFilters());
        view.getPackageFilerCheckbox().setVisible(false);
        this.view.getSearchButton().addClickListener((Button.ClickListener & Serializable)e -> this.applyFilters());
        this.view.getSearchField().setPlaceholder(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SEARCHFIELD_INPUTPROMT, new Object[0]));
        this.view.getSearchField().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.applyFilters());
        this.view.onShowPackageDetails(pkg -> {
            PackageDetailsView packageDetailsView = new PackageDetailsView();
            PackageDetailsPresenter presenter = new PackageDetailsPresenter(new PackageDetailsWindow(packageDetailsView, (Component)packageDetailsView), packageManager, clientService);
            presenter.setPackage((Package)pkg);
        });
        this.view.getSourceUpdateButton().addClickListener((Button.ClickListener & Serializable)event -> {
            ListenableProgressFuture update = packageManager.updateCacheDB();
            ProgressReceiverDialog dialog = new ProgressReceiverDialog(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGESOURCES_PROGRESS_CAPTION, new Object[0])){

                @Override
                public void close() {
                    super.close();
                    PackageListMasterDetailsPresenter.this.refreshUpdatePanel();
                }
            };
            dialog.watch(update);
            dialog.open(true);
        });
    }

    public void refreshUpdatePanel() {
        this.packageManager.getSourcesList().getSources().stream().min(Comparator.comparing(Source::getLastUpdated, Comparator.nullsLast(Comparator.reverseOrder()))).ifPresent(lastUpdatedSource -> {
            if (lastUpdatedSource.getLastUpdated() != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DATE_FORMAT, new Object[0]));
                this.view.setSourceUpdateLabelValue(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_LASTUPDATE_LABEL, new Object[]{lastUpdatedSource.getLastUpdated().format(formatter)}));
            }
        });
    }

    protected void applyFilters() {
        this.dataProvider.clearFilters();
        String value = this.view.getSearchField().getValue().trim();
        if (!value.isEmpty()) {
            this.dataProvider.addFilter(AbstractPackageItem::getName, (SerializablePredicate & Serializable)s -> s.toLowerCase().startsWith(value.toLowerCase()));
        }
        this.dataProvider.addFilter((SerializablePredicate)new HideOTCManagerVersionFilter());
    }

    public void showPackageListLoadingError(Exception e) {
    }

    public void setPackages(Collection<Package> packages) {
        this.dataProvider.getItems().clear();
        this.dataProvider.getItems().addAll(packages.stream().map(ResolvedPackageItem::new).collect(Collectors.toList()));
        this.applyFilters();
        this.dataProvider.refreshAll();
        this.view.clearSelection();
        this.view.sort(View.SortableProperty.NAME, SortDirection.ASCENDING);
    }

    public static class HideOTCManagerVersionFilter
    implements SerializablePredicate<AbstractPackageItem> {
        public static final String OPENTHINCLIENT_MANANGER_VERSION_NAME = "openthinclient-manager-version";

        public boolean test(AbstractPackageItem item) {
            return !StringUtils.equalsIgnoreCase((CharSequence)item.getName(), (CharSequence)OPENTHINCLIENT_MANANGER_VERSION_NAME);
        }
    }

    public static class LatestVersionOnlyFilter
    implements SerializablePredicate<AbstractPackageItem> {
        private final List<Package> latestVersionPackageList;

        public LatestVersionOnlyFilter(ListDataProvider<AbstractPackageItem> dataProvider) {
            PackageManagerUtils pmu = new PackageManagerUtils();
            this.latestVersionPackageList = pmu.reduceToLatestVersion(dataProvider.getItems().stream().filter(api -> api instanceof ResolvedPackageItem).map(api -> ((ResolvedPackageItem)api).getPackage()).collect(Collectors.toList()));
        }

        public boolean test(AbstractPackageItem item) {
            Package pkg = ((ResolvedPackageItem)item).getPackage();
            return this.latestVersionPackageList.stream().anyMatch(p -> p.compareTo(pkg) == 0 && p.getSource().equals((Object)pkg.getSource()));
        }
    }

    public static interface View {
        public Button getSearchButton();

        public TextField getSearchField();

        public void onPackageSelected(Consumer<Collection<Package>> var1);

        public void onShowPackageDetails(Consumer<Package> var1);

        public CheckBox getPackageFilerCheckbox();

        public void setDataProvider(DataProvider<AbstractPackageItem, ?> var1);

        public void sort(SortableProperty var1, SortDirection var2);

        public void setDetailsVisible(boolean var1);

        public void hideSourceUpdatePanel();

        public void setSourceUpdateLabelValue(String var1);

        public Button getSourceUpdateButton();

        public void clearSelection();

        public static enum SortableProperty {
            NAME("name");

            private final String beanPropertyName;

            private SortableProperty(String beanPropertyName) {
                this.beanPropertyName = beanPropertyName;
            }

            public String getBeanPropertyName() {
                return this.beanPropertyName;
            }
        }
    }
}

