/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.services.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.server.Setter;
import com.vaadin.spring.annotation.SpringComponent;
import com.vaadin.spring.annotation.UIScope;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.UI;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.util.Config;
import org.openthinclient.service.common.ManagedService;
import org.openthinclient.service.common.ServiceManager;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.dhcp.DHCPService;
import org.openthinclient.service.dhcp.DhcpServiceConfiguration;
import org.openthinclient.web.Audit;
import org.openthinclient.web.SchemaService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.services.ui.EnumMessageConveyorCaptionGenerator;
import org.springframework.beans.factory.annotation.Autowired;

@SpringComponent
@UIScope
class DhcpServiceConfigurationForm
extends FormLayout {
    @Autowired
    private SchemaService schemaService;
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private ServiceManager serviceManager;
    private ManagedService<DHCPService, DhcpServiceConfiguration> managedDhcpService;
    private final Binder<DhcpServiceConfiguration> binder = new Binder();
    private final IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    private final EnumMessageConveyorCaptionGenerator<DhcpServiceConfiguration.PXEType, ConsoleWebMessages> typeCaptionGenerator = new EnumMessageConveyorCaptionGenerator<DhcpServiceConfiguration.PXEType, ConsoleWebMessages>(this.mc).addMapping(DhcpServiceConfiguration.PXEType.AUTO, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE_AUTO).addMapping(DhcpServiceConfiguration.PXEType.BIND_TO_ADDRESS, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE_BIND_TO_ADDRESS).addMapping(DhcpServiceConfiguration.PXEType.EAVESDROPPING, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE_EAVESDROPPING).addMapping(DhcpServiceConfiguration.PXEType.SINGLE_HOMED, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE_SINGLE_HOMED).addMapping(DhcpServiceConfiguration.PXEType.SINGLE_HOMED_BROADCAST, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE_SINGLE_HOMED_BROADCAST);
    private final EnumMessageConveyorCaptionGenerator<DhcpServiceConfiguration.PXEPolicy, ConsoleWebMessages> policyCaptionGenerator = new EnumMessageConveyorCaptionGenerator<DhcpServiceConfiguration.PXEPolicy, ConsoleWebMessages>(this.mc).addMapping(DhcpServiceConfiguration.PXEPolicy.ANY_CLIENT, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXEPOLICY_ANY_CLIENT).addMapping(DhcpServiceConfiguration.PXEPolicy.ONLY_CONFIGURED, ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXEPOLICY_ONLY_CONFIGURED);

    @PostConstruct
    void init() {
        this.managedDhcpService = this.serviceManager.getManagedService(DHCPService.class);
        this.buildContent();
    }

    public void refresh() {
        this.binder.setBean((Object)((DhcpServiceConfiguration)this.managedDhcpService.getService().getConfiguration()));
    }

    void buildContent() {
        Label label = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_DHCP_CONF_CAPTION, new Object[0]));
        label.addStyleName("h2");
        NativeSelect typeSelect = new NativeSelect(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXETYPE, new Object[0]));
        typeSelect.setItems((Object[])DhcpServiceConfiguration.PXEType.values());
        typeSelect.setItemCaptionGenerator(this.typeCaptionGenerator);
        typeSelect.setEmptySelectionAllowed(false);
        this.binder.forField((HasValue)typeSelect).bind((ValueProvider & Serializable)conf -> conf.getPxe().getType(), (Setter & Serializable)(conf, type) -> conf.getPxe().setType(type));
        CheckBox trackClientsCheckbox = new CheckBox(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_DHCP_CONF_TRACK_CLIENTS, new Object[0]));
        this.binder.forField((HasValue)trackClientsCheckbox).bind(DhcpServiceConfiguration::isTrackUnrecognizedPXEClients, DhcpServiceConfiguration::setTrackUnrecognizedPXEClients);
        NativeSelect policySelect = new NativeSelect(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SERVICE_DHCP_CONF_PXEPOLICY, new Object[0]));
        policySelect.setItems((Object[])DhcpServiceConfiguration.PXEPolicy.values());
        policySelect.setItemCaptionGenerator(this.policyCaptionGenerator);
        policySelect.setEmptySelectionAllowed(false);
        this.binder.forField((HasValue)policySelect).bind((ValueProvider & Serializable)conf -> conf.getPxe().getPolicy(), (Setter & Serializable)(conf, policy) -> conf.getPxe().setPolicy(policy));
        Button saveButton = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_SAVE, new Object[0]), (Button.ClickListener & Serializable)e -> {
            Audit.logSave("Service settings", new String[0]);
            this.binder.writeBeanIfValid((Object)((DhcpServiceConfiguration)this.managedDhcpService.getService().getConfiguration()));
            this.managerHome.save(this.managedDhcpService.getService().getConfigurationClass());
            DhcpServiceConfiguration.PXEPolicy pxePolicy = (DhcpServiceConfiguration.PXEPolicy)policySelect.getValue();
            this.schemaService.saveTftpPolicy(pxePolicy == DhcpServiceConfiguration.PXEPolicy.ANY_CLIENT ? Config.BootOptions.PXEServicePolicyType.AnyClient : Config.BootOptions.PXEServicePolicyType.RegisteredOnly);
            if (this.managedDhcpService.isRunning()) {
                this.managedDhcpService.restart();
            }
        });
        this.addComponent((Component)label);
        this.addComponent((Component)typeSelect);
        this.addComponent((Component)trackClientsCheckbox);
        this.addComponent((Component)policySelect);
        this.addComponent((Component)saveButton);
    }
}

