/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="printer_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_PRINTER_HEADER", order=60)
@ThemeIcon(value="icon/printer.svg")
public final class PrinterView
extends AbstractThinclientView {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrinterView.class);
    public static final String NAME = "printer_view";
    public static final String ICON = "icon/printer.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_PRINTER_HEADER;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private UserService userService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private LocationService locationService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    private final IMessageConveyor mc;
    private VerticalLayout right;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    public PrinterView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_PRINTER_HEADER, eventBus, notificationService);
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
    }

    @PostConstruct
    private void setup() {
        this.addStyleName(NAME);
        this.addCreateActionButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_ADD_PRINTER_LABEL, new Object[0]), ICON, "printer_view/create");
    }

    @Override
    public Set getAllItems() {
        try {
            return this.printerService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(Printer.class, schemaName);
    }

    @Override
    public Map<String, String> getSchemaNames() {
        return Stream.of(this.schemaProvider.getSchemaNames(Printer.class)).collect(Collectors.toMap(schemaName -> schemaName, schemaName -> this.getSchema((String)schemaName).getLabel()));
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) throws BuildProfileException {
        Profile profile = (Profile)directoryObject;
        Map<String, String> schemaNames = this.getSchemaNames();
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(schemaNames, profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        String type = meta.getProperty("type").get().getConfiguration().getValue();
        ProfilePanel profilePanel = new ProfilePanel(profile.getName() + " (" + schemaNames.getOrDefault(type, type) + ")", profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractThinclientView)this, profilePanel, profile);
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(item.getClass());
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set members = ((Printer)item).getMembers();
        Set allLocations = this.locationService.findAll();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOCATION_HEADER, new Object[0]), allLocations, Location.class, values -> this.saveReference(item, (List<Item>)values, allLocations, Location.class));
        Set allClients = this.clientService.findAllClientMetaData();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), allClients, Client.class, values -> this.saveReference(item, (List<Item>)values, allClients, Client.class));
        Set allUsers = this.userService.findAll();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USER_HEADER, new Object[0]), allUsers, User.class, values -> this.saveReference(item, (List<Item>)values, allUsers, User.class));
        Set userGroups = this.userGroupService.findAll();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERGROUP_HEADER, new Object[0]), userGroups, UserGroup.class, values -> this.saveReference(item, (List<Item>)values, userGroups, UserGroup.class));
        return referencesPanel;
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String name) {
        return (T)this.printerService.findByName(name);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.printerService.save((DirectoryObject)((Printer)profile));
        Audit.logSave(profile);
    }

    @Override
    public Client getClient(String name) {
        return (Client)this.clientService.findByName(name);
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }
}

