/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.component;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.springframework.web.util.HtmlUtils;

public class ProfilesListOverviewPanel
extends Panel {
    private IMessageConveyor mc;
    private CheckBox selectAll;
    private CssLayout gridWrapper;
    private List<SelectionRow> selectionRows = new ArrayList<SelectionRow>();
    private ListDataProvider<DirectoryObject> dataProvider;
    private Button addNew;
    private Button deleteProfileAction;
    private Button ldifExportAction;
    private Consumer<DirectoryObject> itemButtonClickedConsumer = null;
    private Grid.Column<DirectoryObject, Button> itemBtn;

    public ProfilesListOverviewPanel(ConsoleWebMessages i18nTitleKey) {
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setCaption(this.mc.getMessage((Enum)i18nTitleKey, new Object[0]));
        this.addStyleName("overviewPanel");
        this.setVisible(false);
        CssLayout layout = new CssLayout();
        layout.setSizeFull();
        this.setContent((Component)layout);
        CssLayout filterLine = new CssLayout();
        filterLine.addStyleNames(new String[]{"filterLine"});
        TextField filter = new TextField();
        filter.setPlaceholder(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SEARCHFIELD_INPUTPROMT, new Object[0]));
        filter.addValueChangeListener(this::onFilterTextChange);
        filterLine.addComponent((Component)filter);
        layout.addComponent((Component)filterLine);
        HorizontalLayout actionLine = new HorizontalLayout();
        actionLine.addStyleNames(new String[]{"actionLine"});
        this.selectAll = new CheckBox(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_SELECT_ALL, new Object[0]));
        this.selectAll.addValueChangeListener(this::selectAllItems);
        actionLine.addComponent((Component)this.selectAll);
        this.addNew = new Button("");
        this.addNew.setIcon((Resource)VaadinIcons.PLUS_CIRCLE_O);
        this.addNew.addStyleName("borderless-colored");
        this.addNew.addStyleName("small");
        this.addNew.addStyleName("icon-only");
        this.addNew.addStyleName("addNew");
        actionLine.addComponent((Component)this.addNew);
        this.deleteProfileAction = new Button();
        this.deleteProfileAction.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_DELETE, new Object[0]));
        this.deleteProfileAction.setIcon((Resource)VaadinIcons.CLOSE_CIRCLE_O);
        this.deleteProfileAction.addStyleName("borderless-colored");
        this.deleteProfileAction.addStyleName("small");
        this.deleteProfileAction.addStyleName("icon-only");
        this.deleteProfileAction.addStyleName("deleteProfile");
        actionLine.addComponent((Component)this.deleteProfileAction);
        layout.addComponent((Component)actionLine);
        this.ldifExportAction = new Button("");
        this.ldifExportAction.setDescription("Export LDIF");
        this.ldifExportAction.setIcon((Resource)VaadinIcons.ARROW_CIRCLE_DOWN_O);
        this.ldifExportAction.addStyleName("borderless-colored");
        this.ldifExportAction.addStyleName("small");
        this.ldifExportAction.addStyleName("icon-only");
        this.ldifExportAction.addStyleName("ldifExport");
        actionLine.addComponent((Component)this.ldifExportAction);
        this.gridWrapper = new CssLayout();
        this.gridWrapper.addStyleNames(new String[]{"table"});
        layout.addComponent((Component)this.gridWrapper);
    }

    private void itemButtonClicked(DirectoryObject dirObj) {
        if (this.itemButtonClickedConsumer != null) {
            this.itemButtonClickedConsumer.accept(dirObj);
        }
    }

    private void selectAllItems(HasValue.ValueChangeEvent<Boolean> booleanValueChangeEvent) {
        if (((Boolean)booleanValueChangeEvent.getValue()).booleanValue()) {
            this.selectionRows.forEach(SelectionRow::select);
        } else {
            this.selectionRows.forEach(SelectionRow::deselect);
        }
    }

    private void onFilterTextChange(HasValue.ValueChangeEvent<String> event) {
        this.selectAll.setValue(Boolean.valueOf(false));
        long groupHeader = this.dataProvider.getItems().stream().filter(i -> i.getClass().equals(ProfilePropertiesBuilder.MenuGroupProfile.class)).count();
        this.dataProvider.setFilter((SerializablePredicate & Serializable)directoryObject -> {
            if (directoryObject instanceof ProfilePropertiesBuilder.MenuGroupProfile) {
                return true;
            }
            String what = ((String)event.getValue()).toLowerCase();
            return Stream.of(directoryObject.getName(), directoryObject.getDescription()).filter(Objects::nonNull).map(String::toLowerCase).anyMatch(where -> where.contains(what));
        });
        this.updateRowList();
    }

    private void updateRowList() {
        this.gridWrapper.removeAllComponents();
        this.selectionRows.clear();
        this.dataProvider.fetch(new Query()).collect(Collectors.toList()).forEach(directoryObject -> {
            SelectionRow selectionRow = new SelectionRow((DirectoryObject)directoryObject);
            this.gridWrapper.addComponent((Component)selectionRow);
            this.selectionRows.add(selectionRow);
        });
    }

    public Button getAddButton() {
        return this.addNew;
    }

    public Button getDeleteButton() {
        return this.deleteProfileAction;
    }

    public Button getLdifExportButton() {
        return this.ldifExportAction;
    }

    public CheckBox getCheckBox() {
        return this.selectAll;
    }

    @Deprecated
    public void setItemButtonClickedConsumer(Consumer<DirectoryObject> itemButtonClickedConsumer) {
        this.itemButtonClickedConsumer = itemButtonClickedConsumer;
        if (itemButtonClickedConsumer != null || this.itemBtn != null) {
            // empty if block
        }
    }

    public void setDataProvider(ListDataProvider<DirectoryObject> dataProvider) {
        this.dataProvider = dataProvider;
        this.dataProvider.setSortComparator(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase)::compare);
        this.updateRowList();
    }

    public Set<DirectoryObject> getSelectedItems() {
        return this.selectionRows.stream().filter(SelectionRow::isSelected).map(SelectionRow::getDirectoryObject).collect(Collectors.toSet());
    }

    class SelectionRow
    extends CustomComponent {
        private CheckBox cb;
        private DirectoryObject directoryObject;

        public SelectionRow(DirectoryObject directoryObject) {
            this.directoryObject = directoryObject;
            CssLayout row = new CssLayout();
            row.addStyleName("columns");
            this.cb = new CheckBox();
            Button button = new Button();
            button.setCaptionAsHtml(true);
            StringBuilder caption = new StringBuilder("<span class=\"name\">").append(HtmlUtils.htmlEscape((String)directoryObject.getName())).append("</span>");
            String description = directoryObject.getDescription();
            if (description != null) {
                caption.append("\n\n<span class=\"description\">").append(HtmlUtils.htmlEscape((String)description)).append("</span>");
            }
            button.setCaption(caption.toString());
            button.addStyleName("borderless-colored");
            button.addClickListener((Button.ClickListener & Serializable)e -> ProfilesListOverviewPanel.this.itemButtonClicked(directoryObject));
            row.addComponents(new Component[]{this.cb, button});
            this.setCompositionRoot((Component)row);
        }

        public void select() {
            this.cb.setValue(Boolean.valueOf(true));
        }

        public void deselect() {
            this.cb.setValue(Boolean.valueOf(false));
        }

        public boolean isSelected() {
            return this.cb.getValue();
        }

        public DirectoryObject getDirectoryObject() {
            return this.directoryObject;
        }
    }
}

