/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.presenter;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.Registration;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openthinclient.api.ldif.export.LdifExporterService;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.web.Audit;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.component.ProfilesListOverviewPanel;
import org.openthinclient.web.thinclient.exception.AllItemsListException;
import org.openthinclient.web.thinclient.model.DeleteMandate;
import org.vaadin.viritin.button.MButton;

public class ProfilesListOverviewPanelPresenter {
    private AbstractThinclientView thinclientView;
    private ProfilesListOverviewPanel panel;
    private Registration addClickListenerRegistration = null;
    private Registration deleteClickListenerRegistration = null;
    private Supplier<Set<DirectoryObject>> itemsSupplier = null;
    private LdifExporterService ldifExporterService;
    private Function<DirectoryObject, DeleteMandate> deleteMandatSupplier = null;

    public ProfilesListOverviewPanelPresenter(AbstractThinclientView thinclientView, ProfilesListOverviewPanel panel, LdifExporterService ldifExporterService) {
        this.thinclientView = thinclientView;
        this.panel = panel;
        this.ldifExporterService = ldifExporterService;
        this.addNewButtonClickHandler((Button.ClickListener & Serializable)e -> UI.getCurrent().getNavigator().navigateTo(thinclientView.getViewName() + "/create"));
        this.addDeleteButtonClickHandler(this::handleDeleteAction);
        this.extendLdifExportButton(this.createResource());
        panel.setItemButtonClickedConsumer(dirObj -> UI.getCurrent().getNavigator().navigateTo(thinclientView.getViewName() + "/edit/" + dirObj.getName()));
    }

    private StreamResource createResource() {
        return new StreamResource((StreamResource.StreamSource & Serializable)() -> {
            Set dns = this.panel.getSelectedItems().stream().map(DirectoryObject::getDn).filter(s -> s.contains(this.ldifExporterService.getBaseDN())).map(s -> s.substring(0, s.indexOf(this.ldifExporterService.getBaseDN()) - 1)).collect(Collectors.toSet());
            HashSet exportResult = new HashSet();
            byte[] bytes = this.ldifExporterService.performAction(dns, exportResult::add);
            if (exportResult.contains(LdifExporterService.State.ERROR) || exportResult.contains(LdifExporterService.State.EXCEPTION)) {
                return null;
            }
            return new ByteArrayInputStream(bytes);
        }, "export.ldif");
    }

    private void handleDeleteAction(Button.ClickEvent event) {
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        Set<DirectoryObject> selectedItems = this.panel.getSelectedItems();
        VerticalLayout content = new VerticalLayout();
        Window window = new Window(null, (Component)content);
        window.setModal(true);
        window.setPositionX(200);
        window.setPositionY(50);
        boolean deletionAllowed = true;
        if (this.deleteMandatSupplier != null) {
            StringBuilder messages = new StringBuilder();
            for (DirectoryObject directoryObject : selectedItems) {
                DeleteMandate mandate = this.deleteMandatSupplier.apply(directoryObject);
                boolean allowed = mandate.checkDelete();
                if (allowed) continue;
                messages.append(mandate.getMessage()).append("<br>\n");
                deletionAllowed = false;
            }
            if (!deletionAllowed) {
                window.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DELETE_NOT_POSSIBLE_HEADER, new Object[0]));
                content.addComponent((Component)new Label(messages.toString(), ContentMode.HTML));
            }
        }
        if (deletionAllowed) {
            window.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_CONFIRM_DELETE, new Object[0]));
            if (selectedItems.size() == 1) {
                content.addComponent((Component)new Label(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_CONFIRM_DELETE_OBJECT_TEXT, new Object[]{selectedItems.iterator().next().getName()})));
            } else {
                StringJoiner sj = new StringJoiner(",<br>");
                selectedItems.forEach(item -> sj.add(item.getName()));
                content.addComponent((Component)new Label(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_CONFIRM_DELETE_OBJECTS_TEXT, new Object[]{sj.toString()}), ContentMode.HTML));
            }
            HorizontalLayout hl = new HorizontalLayout();
            hl.addComponents(new Component[]{new MButton(mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CANCEL, new Object[0]), (Button.ClickListener & Serializable)event1 -> window.close()), new MButton(mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DELETE, new Object[0]), (Button.ClickListener & Serializable)event1 -> {
                selectedItems.forEach(item -> {
                    if (item instanceof ClientMetaData) {
                        item = this.thinclientView.getFreshProfile(item.getName());
                    }
                    Realm realm = item.getRealm();
                    try {
                        realm.getDirectory().delete(item);
                        Audit.logDelete(item);
                    }
                    catch (DirectoryException e) {
                        this.thinclientView.showError((Exception)((Object)e));
                    }
                });
                try {
                    Set<DirectoryObject> allItems = this.itemsSupplier == null ? this.thinclientView.getAllItems() : this.itemsSupplier.get();
                    this.panel.setDataProvider((ListDataProvider<DirectoryObject>)DataProvider.ofCollection(allItems));
                    this.thinclientView.selectItem(null);
                    this.panel.getCheckBox().setValue(Boolean.valueOf(false));
                }
                catch (AllItemsListException e) {
                    this.thinclientView.showError(e);
                }
                window.close();
                UI.getCurrent().removeWindow(window);
            })});
            content.addComponent((Component)hl);
        }
        if (selectedItems.size() > 0) {
            UI.getCurrent().addWindow(window);
        }
    }

    public void addNewButtonClickHandler(Button.ClickListener clickListener) {
        if (this.addClickListenerRegistration != null) {
            this.addClickListenerRegistration.remove();
        }
        this.addClickListenerRegistration = this.panel.getAddButton().addClickListener(clickListener);
    }

    public void addDeleteButtonClickHandler(Button.ClickListener clickListener) {
        if (this.deleteClickListenerRegistration != null) {
            this.deleteClickListenerRegistration.remove();
        }
        this.deleteClickListenerRegistration = this.panel.getDeleteButton().addClickListener(clickListener);
    }

    public void extendLdifExportButton(StreamResource myResource) {
        FileDownloader fileDownloader = new FileDownloader((Resource)myResource);
        fileDownloader.extend((AbstractComponent)this.panel.getLdifExportButton());
    }

    public void setItemButtonClickedConsumer(Consumer<DirectoryObject> itemButtonClickedConsumer) {
        this.panel.setItemButtonClickedConsumer(itemButtonClickedConsumer);
    }

    public void setDataProvider(ListDataProvider<DirectoryObject> dataProvider) {
        this.panel.setDataProvider(dataProvider);
    }

    public void setVisible(boolean visible) {
        this.panel.setVisible(visible);
    }

    public void setItemsSupplier(Supplier<Set<DirectoryObject>> itemsSupplier) {
        this.itemsSupplier = itemsSupplier;
    }

    public void disableActions() {
        this.panel.getCheckBox().setEnabled(false);
        if (this.addClickListenerRegistration != null) {
            this.addClickListenerRegistration.remove();
        }
        this.panel.getAddButton().setEnabled(false);
        if (this.deleteClickListenerRegistration != null) {
            this.deleteClickListenerRegistration.remove();
        }
        this.panel.getDeleteButton().setEnabled(false);
    }

    public void setDeleteMandatSupplier(Function<DirectoryObject, DeleteMandate> deleteMandatSupplier) {
        this.deleteMandatSupplier = deleteMandatSupplier;
    }

    public ProfilesListOverviewPanel getPanel() {
        return this.panel;
    }
}

