/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.annotations.Push;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.event.MouseEvents;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.SerializableBiPredicate;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.communication.PushMode;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.spring.annotation.SpringViewDisplay;
import com.vaadin.spring.navigator.SpringViewProvider;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.IconGenerator;
import com.vaadin.ui.Image;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.UIDetachedException;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.i18n.LocaleUtil;
import org.openthinclient.pkgmgr.progress.PackageManagerExecutionEngine;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.progress.Registration;
import org.openthinclient.service.common.license.LicenseChangeEvent;
import org.openthinclient.service.common.license.LicenseManager;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.component.LicenseMessageBar;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.AccessDeniedView;
import org.openthinclient.web.ui.UserProfileSubWindow;
import org.openthinclient.web.ui.event.PackageManagerTaskActivatedEvent;
import org.openthinclient.web.ui.event.PackageManagerTaskFinalizedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.security.VaadinSecurity;

@Theme(value="openthinclient")
@Title(value="openthinclient.org")
@SpringUI
@SpringViewDisplay
@Push(value=PushMode.MANUAL)
@com.vaadin.annotations.JavaScript(value={"vaadin://js/UIFunctions.js"})
public final class ManagerUI
extends UI
implements ViewDisplay,
View {
    private static final long serialVersionUID = 4314279050575370517L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerUI.class);
    public static final long REFRESH_DASHBOARD_MILLS = 10000L;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    VaadinSecurity vaadinSecurity;
    @Autowired
    SpringViewProvider viewProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    @Autowired
    PackageManagerExecutionEngine packageManagerExecutionEngine;
    @Autowired
    private EventBus.SessionEventBus eventBus;
    @Autowired
    SpringViewProvider springViewProvider;
    @Autowired
    private RealmService realmService;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private LocationService locationService;
    @Autowired
    private UserService userService;
    @Autowired
    private LicenseManager licenseManager;
    private Registration taskFinalizedRegistration;
    private Registration taskActivatedRegistration;
    private Panel springViewDisplay;
    private CssLayout dashboardPanels;
    private Window notificationsWindow;
    private ConsoleWebMessages i18nTitleKey;
    private IMessageConveyor mc;
    private AbstractOrderedLayout root;
    private Label titleLabel;
    private LicenseMessageBar licenseMessageBar;
    private UserProfileSubWindow userProfileWindow;
    private ComboBox<DirectoryObject> searchTextField;
    private boolean runThread = true;

    protected void onPackageManagerTaskFinalized(ListenableProgressFuture<?> listenableProgressFuture) {
        this.eventBus.publish((Object)this, (Object)new PackageManagerTaskFinalizedEvent(this.packageManagerExecutionEngine));
    }

    protected void onPackageManagerTaskActivated(ListenableProgressFuture<?> listenableProgressFuture) {
        this.eventBus.publish((Object)this, (Object)new PackageManagerTaskActivatedEvent(this.packageManagerExecutionEngine));
    }

    @PostConstruct
    public void init() {
        this.springViewProvider.setAccessDeniedViewClass(AccessDeniedView.class);
    }

    public void showView(View view) {
        if (this.springViewDisplay != null) {
            this.springViewDisplay.setContent((Component)view);
        }
    }

    protected void init(VaadinRequest request) {
        this.setLocale(LocaleUtil.getLocaleForMessages(ConsoleWebMessages.class, (Locale)UI.getCurrent().getLocale()));
        Locale.setDefault(UI.getCurrent().getLocale());
        this.addStyleName("valo-menu-responsive");
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        Page.getCurrent().addBrowserWindowResizeListener((Page.BrowserWindowResizeListener & Serializable)event -> this.eventBus.publish((Object)this, (Object)new DashboardEvent.BrowserResizeEvent(event.getHeight(), event.getWidth())));
        Page.getCurrent().setTitle(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PAGE_TITLE, new Object[0]));
        Page.getCurrent().getStyles().add(".v-filterselect-suggestpopup-header-searchfield {--no-results-feedback: \"" + this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_SEARCH_NO_RESULT, new Object[0]) + "\"}");
        this.taskActivatedRegistration = this.packageManagerExecutionEngine.addTaskActivatedHandler(this::onPackageManagerTaskActivated);
        this.taskFinalizedRegistration = this.packageManagerExecutionEngine.addTaskFinalizedHandler(this::onPackageManagerTaskFinalized);
        this.searchTextField = new ComboBox();
        this.licenseMessageBar = new LicenseMessageBar(this.licenseManager, this.clientService);
        this.showMainScreen();
        JavaScript.getCurrent().execute("installGridTooltips()");
        JavaScript.getCurrent().execute("installInfoButtonFunction()");
        this.buildSearchTextField();
        this.createUserProfileWindow();
        this.addClickListener((MouseEvents.ClickListener & Serializable)e -> this.eventBus.publish((Object)e, (Object)new DashboardEvent.CloseOpenWindowsEvent()));
        new RefreshDashboardThread().start();
    }

    private void showMainScreen() {
        Image image = new Image(null, (Resource)new ThemeResource("logo.svg"));
        image.addClickListener((MouseEvents.ClickListener & Serializable)e -> UI.getCurrent().getPage().setLocation(""));
        image.addStyleName("logo-button");
        image.removeStyleName("valo-menu-logo");
        this.deviceSideBar.setLogo((Component)image);
        this.root = new HorizontalLayout();
        this.root.setSpacing(false);
        this.root.setSizeFull();
        this.deviceSideBar.setId("mainmenu");
        this.root.addComponent((Component)this.deviceSideBar);
        VerticalLayout vl = new VerticalLayout();
        vl.setSpacing(false);
        vl.setMargin(false);
        vl.setSizeFull();
        vl.addComponents(new Component[]{this.buildHeader(), this.licenseMessageBar});
        CssLayout content = new CssLayout();
        content.addStyleName("view-content");
        content.setSizeFull();
        vl.addComponent((Component)content);
        vl.setExpandRatio((Component)content, 1.0f);
        Navigator navigator = new Navigator(UI.getCurrent(), (ComponentContainer)content);
        navigator.addViewChangeListener(new ViewChangeListener(){

            public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
                return true;
            }

            public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
                ManagerUI.this.searchTextField.setValue(null);
                JavaScript.getCurrent().execute("disableSpellcheck()");
                if (event.getNavigator().getState() != null) {
                    ManagerUI.this.deviceSideBar.updateFilterGrid(event.getNewView(), event.getParameters());
                }
            }
        });
        navigator.addProvider((ViewProvider)this.viewProvider);
        navigator.navigateTo(navigator.getState());
        this.root.addComponents(new Component[]{vl});
        this.root.setExpandRatio((Component)vl, 1.0f);
        this.setContent((Component)this.root);
    }

    @EventBusListenerMethod
    public void userLoggedOut(DashboardEvent.UserLoggedOutEvent event) {
        SecurityContext securityContext = (SecurityContext)VaadinSession.getCurrent().getSession().getAttribute("SPRING_SECURITY_CONTEXT");
        Authentication authentication = securityContext.getAuthentication();
        LOGGER.debug("Received UserLoggedOutEvent " + (authentication != null ? authentication.getPrincipal() : "null"));
        VaadinSession.getCurrent().close();
        this.vaadinSecurity.logout();
    }

    @EventBusListenerMethod
    public void closeOpenWindows(DashboardEvent.CloseOpenWindowsEvent event) {
        for (Window window : UI.getCurrent().getWindows()) {
            window.close();
            UI.getCurrent().removeWindow(window);
        }
    }

    @EventBusListenerMethod
    public void updateHeaderLabel(DashboardEvent.UpdateHeaderLabelEvent event) {
        if (this.titleLabel != null) {
            this.titleLabel.setValue(event.getCaption());
        }
    }

    @EventBusListenerMethod
    public void licenseChange(LicenseChangeEvent ev) {
        if (this.licenseMessageBar != null) {
            this.licenseMessageBar.updateContent();
            this.push();
        }
    }

    public void attach() {
        super.attach();
        this.eventBus.subscribe((Object)this);
    }

    public void detach() {
        LOGGER.debug("Detach ManagerUI " + (Object)((Object)this) + " and stop Thread");
        this.runThread = false;
        this.taskActivatedRegistration.unregister();
        this.taskFinalizedRegistration.unregister();
        this.eventBus.unsubscribe((Object)this);
        super.detach();
    }

    private Component buildHeader() {
        CssLayout header = new CssLayout();
        header.addStyleName("header");
        header.addComponent(this.searchTextField);
        header.addComponent(this.buildLogoutButton());
        return header;
    }

    private void buildSearchTextField() {
        this.searchTextField.addStyleName("header-searchfield");
        this.searchTextField.setEmptySelectionAllowed(false);
        this.searchTextField.setPopupWidth("300px");
        this.searchTextField.addValueChangeListener(this::onSearchSelect);
        this.searchTextField.setItemCaptionGenerator(DirectoryObject::getName);
        this.searchTextField.setItemIconGenerator((IconGenerator & Serializable)profile -> {
            String icon;
            if (profile instanceof Application) {
                icon = "icon/application.svg";
            } else if (profile instanceof ApplicationGroup) {
                icon = "icon/applicationgroup-white.svg";
            } else if (profile instanceof Printer) {
                icon = "icon/printer.svg";
            } else if (profile instanceof HardwareType) {
                icon = "icon/hardwaretype.svg";
            } else if (profile instanceof Device) {
                icon = "icon/device.svg";
            } else if (profile instanceof ClientMetaData) {
                icon = "icon/thinclient.svg";
            } else if (profile instanceof Client) {
                icon = "icon/thinclient.svg";
            } else if (profile instanceof Location) {
                icon = "icon/location.svg";
            } else if (profile instanceof User) {
                icon = "icon/user.svg";
            } else {
                return null;
            }
            return new ThemeResource(icon);
        });
        new Thread(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                ArrayList<DirectoryObject> directoryObjects = new ArrayList<DirectoryObject>();
                try {
                    directoryObjects.addAll(ManagerUI.this.applicationService.findAll());
                    directoryObjects.addAll(ManagerUI.this.printerService.findAll());
                    directoryObjects.addAll(ManagerUI.this.deviceService.findAll());
                    directoryObjects.addAll(ManagerUI.this.hardwareTypeService.findAll());
                    directoryObjects.addAll(ManagerUI.this.locationService.findAll());
                    directoryObjects.addAll(ManagerUI.this.clientService.findAllClientMetaData());
                    directoryObjects.addAll(ManagerUI.this.userService.findAll());
                    ManagerUI.this.realmService.findAllRealms().forEach(realm -> directoryObjects.removeAll(realm.getAdministrators().getMembers()));
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot find clients for search: " + e.getMessage());
                }
                LOGGER.info("Setup directoryObjects-grid took " + (System.currentTimeMillis() - start) + "ms");
                ManagerUI.this.eventBus.publish((Object)this, (Object)new DashboardEvent.SearchObjectsSetupEvent(directoryObjects));
            }
        }.start();
    }

    @EventBusListenerMethod
    public void setupSearchObjects(DashboardEvent.SearchObjectsSetupEvent ev) {
        ListDataProvider dataProvider = DataProvider.ofCollection(ev.getDirectoryObjects());
        dataProvider.setSortOrder((ValueProvider & Serializable)source -> source.getName().toLowerCase(), SortDirection.ASCENDING);
        this.searchTextField.setDataProvider(dataProvider.filteringBy((SerializableBiPredicate & Serializable)(directoryObject, filterText) -> {
            String macaddress;
            String value = filterText.toLowerCase();
            if (directoryObject.getName().toLowerCase().contains(value)) {
                return true;
            }
            return directoryObject instanceof ClientMetaData && (macaddress = ((ClientMetaData)directoryObject).getMacAddress()) != null && macaddress.contains(value);
        }));
    }

    private void onSearchSelect(HasValue.ValueChangeEvent<DirectoryObject> event) {
        DirectoryObject directoryObject = (DirectoryObject)event.getValue();
        String navigationState = null;
        if (directoryObject instanceof ApplicationGroup) {
            navigationState = "applicationgroup_view";
        } else if (directoryObject instanceof Application) {
            navigationState = "application_view";
        } else if (directoryObject instanceof ClientMetaData) {
            navigationState = "client_view";
        } else if (directoryObject instanceof Client) {
            navigationState = "client_view";
        } else if (directoryObject instanceof Device) {
            navigationState = "device_view";
        } else if (directoryObject instanceof HardwareType) {
            navigationState = "hardwaretype_view";
        } else if (directoryObject instanceof Location) {
            navigationState = "location_view";
        } else if (directoryObject instanceof Printer) {
            navigationState = "printer_view";
        } else if (directoryObject instanceof User) {
            navigationState = "user_view";
        }
        if (navigationState != null) {
            this.getNavigator().navigateTo(navigationState + "/edit/" + directoryObject.getName());
        }
    }

    private Component buildLogoutButton() {
        HorizontalLayout hl = new HorizontalLayout();
        hl.setMargin(new MarginInfo(false, true, false, false));
        hl.setSpacing(false);
        UserDetails principal = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Label circle = new Label(principal.getUsername().substring(0, 1).toUpperCase());
        circle.addStyleName("header-circle");
        hl.addComponent((Component)circle);
        MenuBar menuBar = new MenuBar();
        menuBar.setWidth("100%");
        menuBar.addStyleName("borderless");
        menuBar.addStyleName("small");
        menuBar.addStyleName("header-menu");
        hl.addComponent((Component)menuBar);
        MenuBar.MenuItem file = menuBar.addItem(principal.getUsername(), null);
        file.addItem(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE, new Object[0]), this::showProfileSubWindow);
        file.addItem(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOGOUT, new Object[0]), (MenuBar.Command & Serializable)e -> this.eventBus.publish((Object)this, (Object)new DashboardEvent.UserLoggedOutEvent()));
        return hl;
    }

    private void showProfileSubWindow(MenuBar.MenuItem menuItem) {
        if (!UI.getCurrent().getWindows().contains((Object)this.userProfileWindow)) {
            SecurityContext securityContext = (SecurityContext)VaadinSession.getCurrent().getSession().getAttribute("SPRING_SECURITY_CONTEXT");
            Authentication authentication = securityContext.getAuthentication();
            UserDetails principal = (UserDetails)authentication.getPrincipal();
            try {
                this.userProfileWindow.refresh((User)this.userService.findByName(principal.getUsername()));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot find directory-object: " + e.getMessage());
                this.userProfileWindow.showError(e);
            }
            UI.getCurrent().addWindow((Window)this.userProfileWindow);
        } else {
            this.userProfileWindow.close();
            UI.getCurrent().removeWindow((Window)this.userProfileWindow);
        }
    }

    private void createUserProfileWindow() {
        this.userProfileWindow = new UserProfileSubWindow(this.userService);
    }

    private void toggleMaximized(Component panel, boolean maximized) {
        Iterator it = this.root.iterator();
        while (it.hasNext()) {
            ((Component)it.next()).setVisible(!maximized);
        }
        this.dashboardPanels.setVisible(true);
        for (Component c : this.dashboardPanels) {
            c.setVisible(!maximized);
        }
        if (maximized) {
            panel.setVisible(true);
            panel.addStyleName("max");
        } else {
            panel.removeStyleName("max");
        }
    }

    class RefreshDashboardThread
    extends Thread {
        RefreshDashboardThread() {
        }

        @Override
        public void run() {
            LOGGER.info("Refreshing Dashboard each {} seconds.", (Object)10L);
            ManagerUI ui = ManagerUI.this;
            try {
                while (ManagerUI.this.runThread) {
                    Thread.sleep(10000L);
                    if (ui.isAttached()) {
                        try {
                            ui.access(new Runnable(){

                                @Override
                                public void run() {
                                    ManagerUI.this.eventBus.publish((Object)this, (Object)new DashboardEvent.PXEClientListRefreshEvent(null));
                                }
                            });
                        }
                        catch (UIDetachedException e) {
                            LOGGER.info("UIDetachedException detected, ui class=" + (Object)((Object)ui));
                        }
                        continue;
                    }
                    LOGGER.debug((Object)((Object)ui) + " not attached.");
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Error while executing RefreshDashboardThread", (Throwable)e);
            }
        }
    }
}

