/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web;

import com.vaadin.spring.annotation.EnableVaadin;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openthinclient.service.apacheds.DirectoryServiceConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.web.WebUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.ldap.LdapAuthenticationProviderConfigurer;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapUserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.web.filter.OncePerRequestFilter;
import org.vaadin.spring.http.HttpService;
import org.vaadin.spring.security.annotation.EnableVaadinSharedSecurity;
import org.vaadin.spring.security.shared.VaadinAuthenticationSuccessHandler;
import org.vaadin.spring.security.shared.VaadinRedirectLogoutHandler;
import org.vaadin.spring.security.shared.VaadinSessionClosingLogoutHandler;
import org.vaadin.spring.security.shared.VaadinUrlAuthenticationSuccessHandler;
import org.vaadin.spring.security.web.VaadinRedirectStrategy;

@Configuration
@EnableVaadin
@EnableWebSecurity
@EnableGlobalMethodSecurity(securedEnabled=true, prePostEnabled=true, proxyTargetClass=true)
@EnableVaadinSharedSecurity
public class WebApplicationSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private ManagerHome managerHome;
    @Value(value="${vaadin.servlet.urlMapping}")
    private String vaadinServletUrlMapping;
    @Autowired
    private VaadinRedirectStrategy redirectStrategy;

    protected UserDetailsService userDetailsService() {
        return new LdapUserDetailsService(this.userSearch(), (LdapAuthoritiesPopulator)this.defaultLdapAuthoritiesPopulator());
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        DirectoryServiceConfiguration dsc = (DirectoryServiceConfiguration)this.managerHome.getConfiguration(DirectoryServiceConfiguration.class);
        String ldapUrl = this.createLdapURL(dsc);
        LdapAuthenticationProviderConfigurer ldapAuthBuilder = auth.ldapAuthentication();
        ldapAuthBuilder.contextSource().url(ldapUrl).managerDn(dsc.getContextSecurityPrincipal()).managerPassword(dsc.getContextSecurityCredentials());
        ldapAuthBuilder.userDnPatterns(new String[]{"cn={0},ou=users"}).ldapAuthoritiesPopulator((LdapAuthoritiesPopulator)this.defaultLdapAuthoritiesPopulator()).contextSource();
    }

    @Bean
    public DefaultLdapAuthoritiesPopulator defaultLdapAuthoritiesPopulator() {
        DefaultLdapAuthoritiesPopulator ldapAuthoritiesPopulator = new DefaultLdapAuthoritiesPopulator((ContextSource)this.contextSource(), "cn=administrators,ou=RealmConfiguration"){

            public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
                Set roles = super.getGroupMembershipRoles(userDn, username);
                Optional<GrantedAuthority> role = roles.stream().filter(r -> "ROLE_ADMINISTRATORS".equals(r.getAuthority())).findFirst();
                if (!role.isPresent()) {
                    throw new BadCredentialsException("User is not allowed to login as an administrator");
                }
                return roles;
            }
        };
        ldapAuthoritiesPopulator.setGroupRoleAttribute("cn");
        ldapAuthoritiesPopulator.setGroupSearchFilter("uniquemember={0}");
        ldapAuthoritiesPopulator.setSearchSubtree(true);
        return ldapAuthoritiesPopulator;
    }

    @Bean
    public LdapUserSearch userSearch() {
        return new FilterBasedLdapUserSearch("ou=users", "(cn={0})", this.contextSource());
    }

    @Bean
    public BaseLdapPathContextSource contextSource() {
        DirectoryServiceConfiguration dsc = (DirectoryServiceConfiguration)this.managerHome.getConfiguration(DirectoryServiceConfiguration.class);
        String ldapUrl = this.createLdapURL(dsc);
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(ldapUrl);
        contextSource.setUserDn(dsc.getContextSecurityPrincipal());
        contextSource.setPassword(dsc.getContextSecurityCredentials());
        return contextSource;
    }

    private String createLdapURL(DirectoryServiceConfiguration dsc) {
        return "ldap://localhost:" + dsc.getEmbeddedLdapPort() + "/ou=" + dsc.getPrimaryOU() + "," + dsc.getEmbeddedCustomRootPartitionName();
    }

    @Bean
    public FilterRegistrationBean redirectToDashboardUIFilter() {
        FilterRegistrationBean redirectFilter = new FilterRegistrationBean();
        redirectFilter.addUrlPatterns(new String[]{"/"});
        redirectFilter.addUrlPatterns(new String[]{WebUtil.getServletMappingRoot((String)this.vaadinServletUrlMapping) + "first-start"});
        redirectFilter.setFilter((Filter)new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException {
                response.sendRedirect(WebUtil.getServletMappingRoot((String)WebApplicationSecurityConfiguration.this.vaadinServletUrlMapping));
            }
        });
        return redirectFilter;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{WebUtil.getServletMappingRoot((String)this.vaadinServletUrlMapping) + "login/**"})).anonymous().antMatchers(new String[]{WebUtil.getServletMappingRoot((String)this.vaadinServletUrlMapping) + "UIDL/**"})).permitAll().antMatchers(new String[]{WebUtil.getServletMappingRoot((String)this.vaadinServletUrlMapping) + "HEARTBEAT/**"})).permitAll().anyRequest()).authenticated();
        http.httpBasic().disable();
        http.formLogin().disable();
        http.logout().addLogoutHandler((LogoutHandler)new VaadinSessionClosingLogoutHandler()).logoutUrl(WebUtil.getServletMappingRoot((String)this.vaadinServletUrlMapping) + "logout").logoutSuccessUrl(WebUtil.getServletMappingRoot((String)this.vaadinServletUrlMapping) + "login?logout").permitAll();
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(WebUtil.getServletMappingRoot((String)this.vaadinServletUrlMapping) + "login"));
        http.rememberMe().rememberMeServices(this.rememberMeServices()).key("openthinclient-manager");
        http.sessionManagement().sessionAuthenticationStrategy(this.sessionAuthenticationStrategy());
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/VAADIN/**"})).antMatchers(new String[]{"/console/**"})).antMatchers(new String[]{"/actuator/health"})).antMatchers(new String[]{"/api/v1/**"})).antMatchers(new String[]{"/openthinclient/files/**"})).antMatchers(new String[]{"/download/**"});
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public RememberMeServices rememberMeServices() {
        return new TokenBasedRememberMeServices("openthinclient-manager", this.userDetailsService());
    }

    @Bean
    public SessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new SessionFixationProtectionStrategy();
    }

    @Bean(name={"vaadinAuthenticationSuccessHandler"})
    public VaadinAuthenticationSuccessHandler vaadinAuthenticationSuccessHandler(HttpService httpService, VaadinRedirectStrategy vaadinRedirectStrategy) {
        return new VaadinUrlAuthenticationSuccessHandler(httpService, vaadinRedirectStrategy, WebUtil.getServletMappingRoot((String)this.vaadinServletUrlMapping));
    }

    @Bean(name={"vaadinLogoutHandler"})
    public VaadinRedirectLogoutHandler vaadinRedirectLogoutHandler(VaadinRedirectStrategy vaadinRedirectStrategy) {
        return new VaadinRedirectLogoutHandler(vaadinRedirectStrategy, WebUtil.getServletMappingRoot((String)this.vaadinServletUrlMapping) + "logout");
    }
}

