/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.dashboard;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.navigator.View;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.service.common.license.License;
import org.openthinclient.service.common.license.LicenseManager;
import org.openthinclient.service.update.UpdateChecker;
import org.openthinclient.web.dashboard.ContentPanel;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.PrivacyNoticeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="")
@SideBarItem(sectionId="client-management", caption="Dashboard", order=10)
@ThemeIcon(value="icon/dashboard.svg")
public class DashboardView
extends Panel
implements View {
    public static final String NAME = "";
    private static final String NEWS_URL = "https://openthinclient.com/manager_news/";
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardView.class);
    @Autowired
    private ClientService clientService;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private UnrecognizedClientService unrecognizedClientService;
    @Autowired
    private UpdateChecker updateChecker;
    @Autowired
    private PackageManager packageManager;
    @Value(value="${application.version}")
    private String applicationVersion;
    private EventBus.SessionEventBus eventBus;
    private final IMessageConveyor mc;
    private CssLayout dashboardPanels;

    @Autowired
    public DashboardView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        this.setSizeFull();
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.eventBus = eventBus;
        eventBus.publish((Object)this, (Object)new DashboardEvent.UpdateHeaderLabelEvent(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_HEADER, new Object[0])));
    }

    @PostConstruct
    public void init() {
        CssLayout root = new CssLayout();
        root.addComponents(new Component[]{this.buildContent(), new PrivacyNoticeInfo()});
        this.setContent((Component)root);
    }

    private Component buildContent() {
        this.dashboardPanels = new CssLayout();
        this.dashboardPanels.addStyleName("dashboard-panels");
        ContentPanel helpPanel = new ContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_HELP_TITLE, new Object[0]), (Resource)new ThemeResource("icon/help.svg"));
        helpPanel.addStyleName("size-1x2");
        helpPanel.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_HELP_CONTENT, new Object[0]), ContentMode.HTML));
        ContentPanel toolsPanel = new ContentPanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_TOOLS_TITLE, new Object[0]), (Resource)new ThemeResource("icon/meter.svg"));
        toolsPanel.addStyleName("size-1x2");
        toolsPanel.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_TOOLS_CONTENT, new Object[0]), ContentMode.HTML));
        this.dashboardPanels.addComponents(new Component[]{new UpdatePanel(), new LicensePanel(), new UnregisteredClientsPanel(), helpPanel, toolsPanel, new NewsBrowser()});
        return this.dashboardPanels;
    }

    class UnregisteredClientsPanel
    extends ContentPanel {
        private ComboBox<String> macCombo;

        public UnregisteredClientsPanel() {
            super(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UNREGISTERED_CLIENTS, new Object[0]));
            this.addStyleName("unregistered-clients");
            this.macCombo = new ComboBox();
            this.macCombo.setPlaceholder(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_MAC, new Object[0]));
            this.macCombo.setEmptySelectionAllowed(false);
            this.macCombo.setNewItemProvider((ComboBox.NewItemProvider & Serializable)input -> {
                this.openClientView((String)input);
                return Optional.empty();
            });
            this.macCombo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.openClientView((String)event.getValue()));
            this.updatePXEClientList();
            Button updateButton = new Button(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UNREGISTERED_CLIENTS_UPDATE_BUTTON, new Object[0]));
            updateButton.addStyleName("dashboard-panel-unregistered-clients-button");
            updateButton.setIcon((Resource)VaadinIcons.REFRESH);
            updateButton.addStyleName("borderless");
            updateButton.addClickListener((Button.ClickListener & Serializable)event -> this.updatePXEClientList());
            Button forgetButton = new Button(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UNREGISTERED_CLIENTS_FORGET_BUTTON, new Object[0]));
            forgetButton.addStyleName("dashboard-panel-unregistered-clients-clean-button");
            forgetButton.setIcon((Resource)VaadinIcons.TRASH);
            forgetButton.addStyleName("borderless");
            forgetButton.addClickListener((Button.ClickListener & Serializable)event -> {
                DashboardView.this.unrecognizedClientService.findAll().forEach(directoryObject -> {
                    Realm realm = directoryObject.getRealm();
                    try {
                        realm.getDirectory().delete(directoryObject);
                    }
                    catch (DirectoryException e) {
                        LOGGER.error("Cannot delete unrecognizedClient: " + directoryObject, (Throwable)e);
                    }
                });
                this.updatePXEClientList();
            });
            this.addComponents(new Component[]{this.macCombo, updateButton, forgetButton});
            DashboardView.this.eventBus.subscribeWithWeakReference((Object)this);
        }

        private void openClientView(String macaddress) {
            if ((macaddress = macaddress.trim()).matches("^[0-9a-fA-F]{12}$")) {
                macaddress = String.join((CharSequence)":", macaddress.split("(?<=\\G..)"));
            } else if (!macaddress.matches("^([0-9A-Fa-f]{2}[:]){5}[0-9A-Fa-f]{2}$")) {
                return;
            }
            if (DashboardView.this.clientService.findByHwAddress(macaddress).size() == 0) {
                UI.getCurrent().getNavigator().navigateTo("client_view/register/" + macaddress);
            }
        }

        private void updatePXEClientList() {
            this.macCombo.setItems((Collection)DashboardView.this.unrecognizedClientService.getLastSeenMACs(50L));
        }

        @EventBusListenerMethod
        public void updatePXEClientList(DashboardEvent.PXEClientListRefreshEvent event) {
            this.updatePXEClientList();
        }
    }

    class NewsBrowser
    extends CssLayout {
        public NewsBrowser() {
            this.addStyleNames(new String[]{"news-browser", "dashboard-panel", "size-2x3"});
            BrowserFrame frame = new BrowserFrame(null, (Resource)new ExternalResource("about:blank"));
            CssLayout fallback = new CssLayout();
            fallback.addComponents(new Component[]{new Image(null, (Resource)new ThemeResource("open_news.png")), new Label(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_PANEL_NEW_BROWSER_FALLBACK, new Object[0]), ContentMode.HTML)});
            fallback.addStyleName("fallback");
            this.addComponents(new Component[]{frame, fallback});
            JavaScript.getCurrent().execute(String.format("loadBrowserFrame('.news-browser .v-browserframe', '%s?%s/%s')", DashboardView.NEWS_URL, DashboardView.this.applicationVersion, UI.getCurrent().getLocale().getLanguage()));
        }
    }

    class UpdatePanel
    extends ContentPanel {
        private static final String managerUpdateURL = "/ui/settings#!support";
        private static final String packagesUpdateURL = "/ui/settings#!package-management";
        private Label newVersionLabel;
        private Label newPackagesLabel;

        public UpdatePanel() {
            super(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_CAPTION, new Object[0]), (Resource)new ThemeResource("icon/bell.svg"));
            this.newVersionLabel = new Label();
            this.newPackagesLabel = new Label();
            this.addStyleNames(new String[]{"update-notification", "size-1x2"});
            if (DashboardView.this.updateChecker.hasNetworkError()) {
                Label errorNotification = new Label(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_NETWORK_ERROR, new Object[0]));
                errorNotification.setCaption(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_NETWORK_ERROR_CAPTION, new Object[0]));
                errorNotification.setIcon((Resource)VaadinIcons.EXCLAMATION_CIRCLE_O);
                errorNotification.setStyleName("update-error");
                this.addComponents(new Component[]{errorNotification});
            } else {
                CssLayout managerNotification = new CssLayout();
                managerNotification.setStyleName("manager-updates");
                CssLayout packagesNotification = new CssLayout();
                packagesNotification.setStyleName("package-updates");
                this.addComponents(new Component[]{managerNotification, packagesNotification});
                managerNotification.addComponents(new Component[]{new Label("openthinclient-Manager " + DashboardView.this.applicationVersion), new Link("Manager Updates", (Resource)new ExternalResource(managerUpdateURL)), this.newVersionLabel});
                this.updateManagerStatus(DashboardView.this.updateChecker.getNewVersion());
                packagesNotification.addComponents(new Component[]{new Label("openthinclient-OS"), new Link(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGERMAINNAVIGATORVIEW_CAPTION, new Object[0]), (Resource)new ExternalResource(packagesUpdateURL)), this.newPackagesLabel});
                this.updatePackageStatus(DashboardView.this.packageManager.getUpdateablePackages());
            }
        }

        void updateManagerStatus(Optional<String> newVersion) {
            if (newVersion.isPresent()) {
                this.newVersionLabel.setCaption(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_MANAGER_UPDATABLE, new Object[]{newVersion.get()}));
                this.newVersionLabel.setIcon((Resource)VaadinIcons.EXCLAMATION_CIRCLE_O);
            } else {
                this.newVersionLabel.setCaption(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_MANAGER_CURRENT, new Object[0]));
                this.newVersionLabel.setIcon((Resource)VaadinIcons.CHECK);
            }
        }

        void updatePackageStatus(Collection updatablePackages) {
            if (updatablePackages.size() > 0) {
                this.newPackagesLabel.setCaption(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_PACKAGES_UPDATABLE, new Object[0]));
                this.newPackagesLabel.setIcon((Resource)VaadinIcons.EXCLAMATION_CIRCLE_O);
            } else {
                this.newPackagesLabel.setCaption(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_UPDATE_NOTICE_PACKAGES_CURRENT, new Object[0]));
                this.newPackagesLabel.setIcon((Resource)VaadinIcons.CHECK);
            }
        }
    }

    class LicensePanel
    extends ContentPanel {
        private static final String licenseManagerURL = "/ui/settings#!license";

        public LicensePanel() {
            String licenseStatusClass;
            ConsoleWebMessages licenseStatusKey;
            super(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_LICENSE_INFO_CAPTION, new Object[0]));
            this.addStyleName("license-info");
            License license = DashboardView.this.licenseManager.getLicense();
            Integer maxCount = 49;
            if (license != null) {
                maxCount = license.getCount();
            }
            Integer clientCount = DashboardView.this.clientService.count();
            String countText = DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_LICENSE_INFO_CLIENT_COUNT, new Object[]{clientCount, maxCount});
            Label countLabel = new Label(countText, ContentMode.HTML);
            countLabel.addStyleName("client-count");
            if (maxCount < clientCount) {
                countLabel.addStyleName("too-many");
            } else if (maxCount - clientCount < 11) {
                countLabel.addStyleName("warn");
            }
            License.State licenseState = DashboardView.this.licenseManager.getLicenseState(clientCount.intValue());
            if (licenseState != License.State.OK) {
                licenseStatusKey = ConsoleWebMessages.UI_DASHBOARDVIEW_LICENSE_INFO_LICENSE_PROBLEM;
                licenseStatusClass = "problem";
            } else if (license == null) {
                licenseStatusKey = ConsoleWebMessages.UI_DASHBOARDVIEW_LICENSE_INFO_NO_LICENSE_REQUIRED;
                licenseStatusClass = "ok";
            } else {
                licenseStatusKey = ConsoleWebMessages.UI_DASHBOARDVIEW_LICENSE_INFO_LICENSE_OK;
                licenseStatusClass = "ok";
            }
            Label licenseLabel = new Label(DashboardView.this.mc.getMessage((Enum)licenseStatusKey, new Object[0]));
            licenseLabel.addStyleNames(new String[]{"license-status", licenseStatusClass});
            Link licenseManagerLink = new Link(DashboardView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_DASHBOARDVIEW_LICENSE_INFO_LINK, new Object[0]), (Resource)new ExternalResource(licenseManagerURL));
            this.addComponents(new Component[]{countLabel, licenseLabel, licenseManagerLink});
        }
    }
}

