/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.filebrowser;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.Binder;
import com.vaadin.data.BinderValidationStatus;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.server.Setter;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.openthinclient.web.filebrowser.FileBrowserView;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDirectorySubWindow
extends Window {
    private static final long serialVersionUID = 6056187481962333854L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateDirectorySubWindow.class);
    private static final String ALLOWED_FILENAME_PATTERN = "[\\.\\w-+_]([ \\.\\w-+_]*[\\w-+_])?";
    private static final String NOT_RESERVED_FILENAME_PATTERN = "(?i)(?!(aux|clock\\$|con|nul|prn|com[0-9]|lpt[0-9])(?:$|\\.)).*";

    public CreateDirectorySubWindow(FileBrowserView fileBrowserView, Path doc, Path managerHome) {
        this.addCloseListener((Window.CloseListener & Serializable)event -> UI.getCurrent().removeWindow((Window)this));
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        Path dir = doc == null ? managerHome : (Files.isDirectory(doc, new LinkOption[0]) ? doc : doc.getParent());
        this.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_CREATEFOLDER_CAPTION, new Object[]{dir.getFileName()}));
        this.setHeight("140px");
        this.setWidth("500px");
        this.center();
        VerticalLayout subContent = new VerticalLayout();
        subContent.setMargin(true);
        subContent.setSizeFull();
        this.setContent((Component)subContent);
        CssLayout group = new CssLayout();
        group.addStyleName("v-component-group");
        subContent.addComponent((Component)group);
        Label errorMessage = new Label();
        errorMessage.setVisible(false);
        subContent.addComponent((Component)errorMessage);
        Binder newPathBinder = new Binder();
        newPathBinder.setBean((Object)new String());
        TextField tf = new TextField();
        tf.setWidth("260px");
        tf.setCursorPosition(0);
        tf.setPlaceholder(mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_CREATEFOLDER_PROMPT, new Object[0]));
        group.addComponent((Component)tf);
        newPathBinder.forField((HasValue)tf).withValidator((Validator)new StringLengthValidator(mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_CREATEFOLDER_VALIDATION_LENGTH, new Object[0]), Integer.valueOf(1), Integer.valueOf(255))).withValidator((Validator)new RegexpValidator(mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_CREATEFOLDER_VALIDATION_CHARACTERS, new Object[0]), ALLOWED_FILENAME_PATTERN)).withValidator((Validator)new RegexpValidator(mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_CREATEFOLDER_VALIDATION_SPECIAL, new Object[0]), NOT_RESERVED_FILENAME_PATTERN)).bind(String::toString, (Setter & Serializable)(s, s2) -> new String((String)s));
        group.addComponent((Component)new Button(mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_CREATEFOLDER_SAVE, new Object[0]), arg_0 -> this.lambda$new$d9c4ecff$1(newPathBinder, errorMessage, dir, tf, fileBrowserView, (IMessageConveyor)mc, arg_0)));
    }

    private /* synthetic */ void lambda$new$d9c4ecff$1(Binder newPathBinder, Label errorMessage, Path dir, TextField tf, FileBrowserView fileBrowserView, IMessageConveyor mc, Button.ClickEvent event) {
        BinderValidationStatus validationStatus = newPathBinder.validate();
        if (validationStatus.hasErrors()) {
            StringBuilder sb = new StringBuilder();
            validationStatus.getFieldValidationStatuses().forEach(fvs -> sb.append((String)fvs.getMessage().get()).append("\n"));
            errorMessage.setCaption(sb.toString());
            errorMessage.setVisible(true);
            return;
        }
        Path newDir = dir.resolve(tf.getValue());
        LOGGER.debug("Create new directory: ", (Object)newDir);
        try {
            Path path = Files.createDirectory(newDir, new FileAttribute[0]);
            LOGGER.debug("Created new directory: ", (Object)path);
            fileBrowserView.refresh(path);
        }
        catch (Exception exception) {
            Notification.show((String)mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_CREATEFOLDER_FAILED, new Object[]{newDir.getFileName()}), (Notification.Type)Notification.Type.ERROR_MESSAGE);
        }
        this.close();
    }
}

