/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.openthinclient.api.ldif.export.LdifExporterService;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.ClientGroup;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.component.ProfilesListOverviewPanel;
import org.openthinclient.web.thinclient.exception.AllItemsListException;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.exception.ProfileNotSavedException;
import org.openthinclient.web.thinclient.model.DeleteMandate;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.presenter.DirectoryObjectPanelPresenter;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ProfilesListOverviewPanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPasswordProperty;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.events.EventBus;

public abstract class AbstractThinclientView
extends Panel
implements View {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    protected ManagerHome managerHome;
    @Autowired
    private RealmService realmService;
    protected IMessageConveyor mc;
    private VerticalLayout clientSettingsVL;
    private CssLayout clientReferencesCL;
    private Component clientReferencesCaption;
    protected ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();
    private final HorizontalLayout actionRow;
    protected final CssLayout overviewCL;
    private final CssLayout clientCL;

    public AbstractThinclientView(ConsoleWebMessages i18nTitleKey, EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setStyleName("thinclientview");
        this.setSizeFull();
        CssLayout view = new CssLayout();
        view.addStyleName("maincontent");
        view.setResponsive(true);
        view.setSizeFull();
        this.actionRow = new HorizontalLayout();
        this.actionRow.addStyleName("profiles-actionrow");
        view.addComponent((Component)this.actionRow);
        this.overviewCL = new CssLayout();
        this.overviewCL.addStyleName("profiles-overview");
        view.addComponent((Component)this.overviewCL);
        this.clientCL = new CssLayout();
        this.clientCL.addStyleName("profile");
        this.clientCL.setSizeFull();
        this.clientSettingsVL = new VerticalLayout();
        this.clientSettingsVL.addStyleName("profile-settings");
        this.clientSettingsVL.setMargin(new MarginInfo(false, false, false, false));
        this.clientSettingsVL.setSizeFull();
        this.clientSettingsVL.setSpacing(false);
        this.clientReferencesCL = new CssLayout();
        this.clientReferencesCL.addStyleName("profile-references");
        this.clientReferencesCL.setVisible(false);
        this.clientReferencesCaption = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_HINT_ASSOCIATION, new Object[0]), this::toggleVisibilityClass);
        this.clientReferencesCaption.setPrimaryStyleName("references-caption");
        this.clientCL.addComponents(new Component[]{this.clientSettingsVL, this.clientReferencesCL});
        this.clientCL.setVisible(false);
        view.addComponent((Component)this.clientCL);
        this.setContent((Component)view);
    }

    void toggleVisibilityClass(Button.ClickEvent ev) {
        if (this.getStyleName().contains("expanded")) {
            this.removeStyleName("expanded");
        } else {
            this.addStyleName("expanded");
        }
    }

    public abstract ProfilePanel createProfilePanel(DirectoryObject var1) throws BuildProfileException;

    public abstract ProfileReferencesPanel createReferencesPanel(DirectoryObject var1) throws BuildProfileException;

    public abstract Set getAllItems() throws AllItemsListException;

    public abstract Schema getSchema(String var1);

    public abstract Map<String, String> getSchemaNames();

    public abstract String getViewName();

    public String getParentViewName() {
        return this.getViewName();
    }

    public abstract ConsoleWebMessages getViewTitleKey();

    public abstract <T extends DirectoryObject> T getFreshProfile(String var1);

    public abstract void save(DirectoryObject var1) throws ProfileNotSavedException;

    public abstract Client getClient(String var1);

    public void addCreateActionButton(String caption, String icon, String target) {
        Button action = new Button(caption, (Resource)new ThemeResource(icon));
        action.addStyleName("thinclient-action-button");
        action.addClickListener((Button.ClickListener & Serializable)e -> UI.getCurrent().getNavigator().navigateTo(target));
        this.actionRow.addComponent((Component)action);
    }

    protected void addOverviewComponent(Component c) {
        this.overviewCL.addComponent(c);
    }

    public void showError(Exception e) {
        this.actionRow.removeAllComponents();
        this.overviewCL.removeAllComponents();
        this.clientSettingsVL.removeAllComponents();
        this.clientReferencesCL.removeAllComponents();
        String message = e.getCause() instanceof DirectoryException ? this.mc.getMessage((Enum)ConsoleWebMessages.UI_ERROR_DIRECTORY_EXCEPTION, new Object[0]) : e.getLocalizedMessage();
        Label emptyScreenHint = new Label(VaadinIcons.WARNING.getHtml() + "&nbsp;&nbsp;&nbsp;" + this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_HINT_ERROR, new Object[0]) + message, ContentMode.HTML);
        emptyScreenHint.setStyleName("errorScreenHint");
        this.clientSettingsVL.addComponent((Component)emptyScreenHint);
    }

    public <T extends DirectoryObject> void saveAssociations(AssociatedObjectsProvider profile, List<Item> values, Set<T> directoryObjects, Class<T> clazz) {
        Map associatedObjects = profile.getAssociatedObjects();
        Set association = (Set)associatedObjects.get(clazz);
        List<Item> oldValues = ProfilePropertiesBuilder.createFilteredItemsFromDO(association, clazz);
        oldValues.forEach(oldItem -> {
            if (values.contains(oldItem)) {
                this.LOGGER.info("Keep oldValue as member: " + oldItem);
            } else {
                this.LOGGER.info("Remove oldValue from members: " + oldItem);
                Optional<DirectoryObject> directoryObject = directoryObjects.stream().filter(o -> o.getName().equals(oldItem.getName())).findFirst();
                if (directoryObject.isPresent()) {
                    association.remove(directoryObject.get());
                } else {
                    this.LOGGER.info("Device (to remove) not found for " + oldItem);
                }
            }
        });
        values.forEach(newValue -> {
            if (!oldValues.contains(newValue)) {
                this.LOGGER.info("Add newValue to members: " + newValue);
                Optional<DirectoryObject> directoryObject = directoryObjects.stream().filter(o -> o.getName().equals(newValue.getName())).findFirst();
                if (directoryObject.isPresent()) {
                    DirectoryObject t = directoryObject.get();
                    if (association != null) {
                        association.add(t);
                    } else {
                        profile.setAssociatedObjects(t.getClass(), Stream.of(t).collect(Collectors.toSet()));
                    }
                } else {
                    this.LOGGER.info("DirectoryObject not found for " + newValue);
                }
            }
        });
        this.saveProfile((DirectoryObject)((Profile)profile), null);
    }

    protected <T extends DirectoryObject> void saveReference(DirectoryObject profile, List<Item> values, Set<T> profileAndDirectoryObjects, Class clazz) {
        Set members;
        if (profile instanceof Application) {
            members = ((Application)profile).getMembers();
        } else if (profile instanceof ApplicationGroup) {
            members = clazz.equals(Application.class) ? ((ApplicationGroup)profile).getApplications() : ((ApplicationGroup)profile).getMembers();
        } else if (profile instanceof Printer) {
            members = ((Printer)profile).getMembers();
        } else if (profile instanceof HardwareType) {
            Set clients = ((HardwareType)profile).getMembers();
            clients.stream().forEach(o -> this.LOGGER.info("This class should be of Type Client.class: {}" + o.getClass()));
            members = clients;
        } else if (profile instanceof Device) {
            members = ((Device)profile).getMembers();
        } else if (profile instanceof Client) {
            members = clazz.equals(ClientGroup.class) ? ((Client)profile).getClientGroups() : (clazz.equals(Device.class) ? ((Client)profile).getDevices() : (clazz.equals(Printer.class) ? ((Client)profile).getPrinters() : (clazz.equals(Application.class) ? ((Client)profile).getApplications() : (clazz.equals(ApplicationGroup.class) ? ((Client)profile).getApplicationGroups() : null))));
        } else if (profile instanceof Location) {
            members = ((Location)profile).getPrinters();
        } else if (profile instanceof UserGroup) {
            members = clazz.equals(User.class) ? ((UserGroup)profile).getMembers() : (clazz.equals(ApplicationGroup.class) ? ((UserGroup)profile).getApplicationGroups() : (clazz.equals(Application.class) ? ((UserGroup)profile).getApplications() : (clazz.equals(Printer.class) ? ((UserGroup)profile).getPrinters() : null)));
        } else if (profile instanceof User) {
            members = clazz.equals(UserGroup.class) ? ((User)profile).getUserGroups() : (clazz.equals(ApplicationGroup.class) ? ((User)profile).getApplicationGroups() : (clazz.equals(Printer.class) ? ((User)profile).getPrinters() : (clazz.equals(Application.class) ? ((User)profile).getApplications() : null)));
        } else {
            throw new RuntimeException("Not implemented Profile-type: " + profile);
        }
        List<Item> oldValues = ProfilePropertiesBuilder.createFilteredItemsFromDO(members, clazz);
        oldValues.forEach(oldItem -> {
            if (values.contains(oldItem)) {
                this.LOGGER.info("Keep oldValue as member: " + oldItem);
            } else {
                this.LOGGER.info("Remove oldValue from members: " + oldItem);
                Optional<DirectoryObject> directoryObject = profileAndDirectoryObjects.stream().filter(o -> o.getName().equals(oldItem.getName())).findFirst();
                if (directoryObject.isPresent()) {
                    DirectoryObject object = directoryObject.get();
                    if (object instanceof ClientMetaData) {
                        members.remove(this.getClient(object.getName()));
                    } else {
                        members.remove(object);
                    }
                } else {
                    this.LOGGER.info("DirectoryObject (to remove) not found for " + oldItem);
                }
            }
        });
        values.forEach(newValue -> {
            if (newValue != null && !oldValues.contains(newValue)) {
                this.LOGGER.info("Add newValue to members: " + newValue);
                Optional<DirectoryObject> directoryObject = profileAndDirectoryObjects.stream().filter(o -> o.getName().equals(newValue.getName())).findFirst();
                if (directoryObject.isPresent()) {
                    DirectoryObject object = directoryObject.get();
                    if (object instanceof ClientMetaData) {
                        members.add(this.getClient(object.getName()));
                    } else {
                        members.add(object);
                    }
                } else {
                    this.LOGGER.info("DirectoryObject not found for " + newValue);
                }
            }
        });
        this.saveProfile(profile, null);
    }

    public void saveValues(ProfilePanelPresenter profilePanelPresenter, Profile profile) {
        this.LOGGER.info("Save values for profile: " + profile);
        profilePanelPresenter.getItemGroupPanels().forEach(itemGroupPanel -> itemGroupPanel.propertyComponents().stream().map(propertyComponent -> (OtcProperty)propertyComponent.getBinder().getBean()).collect(Collectors.toList()).forEach(otcProperty -> {
            block15: {
                String org;
                String propertyKey;
                block13: {
                    block14: {
                        String current;
                        boolean isPasswordProperty = otcProperty instanceof OtcPasswordProperty;
                        ItemConfiguration bean = otcProperty.getConfiguration();
                        propertyKey = otcProperty.getKey();
                        org = propertyKey.equals("name") ? profile.getName() : (propertyKey.equals("description") ? profile.getDescription() : (propertyKey.equals("type") && profile.getRealm() != null ? profile.getSchema(profile.getRealm()).getName() : profile.getValueLocal(propertyKey)));
                        String string = current = bean.getValue() == null || bean.getValue().length() == 0 ? null : bean.getValue();
                        if (StringUtils.equals((CharSequence)org, (CharSequence)current)) break block13;
                        if (current == null) break block14;
                        this.LOGGER.info(" Apply value for " + propertyKey + "=" + (isPasswordProperty ? "***" : org) + " with new value '" + (isPasswordProperty ? "***" : current) + "'");
                        switch (propertyKey) {
                            case "name": {
                                profile.setName(current);
                                break;
                            }
                            case "description": {
                                profile.setDescription(current);
                                break;
                            }
                            case "type": {
                                profile.setSchema(this.getSchema(current));
                                Schema orgSchema = this.getSchema(otcProperty.getInitialValue());
                                if (orgSchema != null) {
                                    orgSchema.getChildren().forEach(o -> profile.removeValue(o.getName()));
                                    break;
                                }
                                break block15;
                            }
                            default: {
                                profile.setValue(propertyKey, current);
                                break;
                            }
                        }
                        break block15;
                    }
                    if (propertyKey.equals("description")) {
                        this.LOGGER.info(" Apply null value for description");
                        profile.setDescription(null);
                    } else {
                        this.LOGGER.info(" Remove empty value for " + propertyKey);
                        profile.removeValue(propertyKey);
                    }
                    break block15;
                }
                this.LOGGER.info(" Unchanged " + propertyKey + "=" + org);
            }
        }));
        boolean success = this.saveProfile((DirectoryObject)profile, profilePanelPresenter);
        if (success) {
            this.selectItem((DirectoryObject)profile);
            this.navigateTo((DirectoryObject)profile);
        }
    }

    public abstract void selectItem(DirectoryObject var1);

    public boolean saveProfile(DirectoryObject profile, DirectoryObjectPanelPresenter panelPresenter) {
        try {
            this.save(profile);
            this.LOGGER.info("Profile saved {}", (Object)profile);
            if (panelPresenter != null) {
                panelPresenter.setInfo(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_HINT_SAVE_SUCCESS, new Object[0]));
            }
            return true;
        }
        catch (Exception e) {
            this.LOGGER.error("Cannot save profile", (Throwable)e);
            if (panelPresenter != null) {
                panelPresenter.setError(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_HINT_SAVE_ERROR, new Object[0]) + e.getMessage());
            }
            return false;
        }
    }

    public void showProfileMetadata(Profile profile) {
        ProfilePanel panel = this.createProfileMetadataPanel(profile);
        this.showProfileMetadataPanel(panel);
    }

    public void showProfileMetadataPanel(ProfilePanel panel) {
        this.actionRow.setVisible(false);
        this.overviewCL.setVisible(false);
        this.clientReferencesCL.setVisible(false);
        this.clientCL.setVisible(true);
        this.clientSettingsVL.removeAllComponents();
        this.clientSettingsVL.addComponent((Component)panel);
    }

    protected ProfilePanel createProfileMetadataPanel(Profile profile) {
        ProfilePanel profilePanel = new ProfilePanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_NEW_PROFILE_HEADER, new Object[0]), profile.getClass());
        OtcPropertyGroup group = this.createOtcMetaDataPropertyGroup(profile);
        ProfilePanelPresenter ppp = new ProfilePanelPresenter(this, profilePanel, profile);
        ppp.hideCopyButton();
        ppp.hideDeleteButton();
        ppp.setItemGroups(Arrays.asList(group, new OtcPropertyGroup()));
        ppp.onValuesWritten(profilePanel1 -> this.saveValues(ppp, profile));
        return profilePanel;
    }

    public OtcPropertyGroup createOtcMetaDataPropertyGroup(Profile profile) {
        OtcPropertyGroup group = this.builder.createProfileMetaDataGroup(this.getSchemaNames(), profile);
        if (profile.getName() == null || profile.getName().length() == 0) {
            this.addProfileNameAlreadyExistsValidator(group);
        }
        group.getProperty("type").ifPresent(otcProperty -> {
            otcProperty.getConfiguration().setRequired(true);
            otcProperty.getConfiguration().enable();
        });
        return group;
    }

    protected void addProfileNameAlreadyExistsValidator(OtcPropertyGroup meta) {
        meta.getProperty("name").ifPresent(nameProperty -> nameProperty.getConfiguration().getValidators().add((Validator)new AbstractValidator<String>(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_ALREADY_EXISTS, new Object[0])){

            public ValidationResult apply(String value, ValueContext context) {
                Object directoryObject = AbstractThinclientView.this.getFreshProfile(value);
                return nameProperty.getInitialValue() == null && directoryObject == null || nameProperty.getInitialValue() != null && nameProperty.getInitialValue().equals(value) && directoryObject != null || nameProperty.getInitialValue() != null && !nameProperty.getInitialValue().equals(value) && directoryObject == null ? ValidationResult.ok() : ValidationResult.error((String)AbstractThinclientView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_ALREADY_EXISTS, new Object[0]));
            }
        }));
    }

    public ProfilesListOverviewPanelPresenter createOverviewItemlistPanel(ConsoleWebMessages i18nTitleKey, Set items) {
        ProfilesListOverviewPanel plop = new ProfilesListOverviewPanel(i18nTitleKey);
        ProfilesListOverviewPanelPresenter plopPresenter = new ProfilesListOverviewPanelPresenter(this, plop, new LdifExporterService(this.realmService.getDefaultRealm().getConnectionDescriptor()));
        ListDataProvider dataProvider = DataProvider.ofCollection((Collection)items);
        dataProvider.setSortComparator(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase)::compare);
        plopPresenter.setDataProvider((ListDataProvider<DirectoryObject>)dataProvider);
        plopPresenter.setVisible(true);
        return plopPresenter;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.LOGGER.debug("enter -> source={}, navigator-state=", event.getSource(), (Object)event.getNavigator().getState());
        String[] params = Optional.ofNullable(event.getParameters()).orElse("").split("/", 2);
        if (params.length > 0) {
            if ("create".equals(params[0])) {
                switch (event.getViewName()) {
                    case "application_view": {
                        this.showProfileMetadata((Profile)new Application());
                        break;
                    }
                    case "client_view": {
                        this.showProfileMetadata((Profile)new Client());
                        break;
                    }
                    case "device_view": {
                        this.showProfileMetadata((Profile)new Device());
                        break;
                    }
                    case "hardwaretype_view": {
                        this.showProfileMetadata((Profile)new HardwareType());
                        break;
                    }
                    case "location_view": {
                        this.showProfileMetadata((Profile)new Location());
                        break;
                    }
                    case "printer_view": {
                        this.showProfileMetadata((Profile)new Printer());
                    }
                }
            } else if ("register".equals(params[0]) && params.length == 2 && "client_view".equals(event.getViewName())) {
                Client client = new Client();
                client.setMacAddress(params[1]);
                this.showProfileMetadata((Profile)client);
            } else if ("edit".equals(params[0]) && params.length == 2 && params[1].length() > 0) {
                Object profile = this.getFreshProfile(params[1]);
                if (profile != null) {
                    this.showProfile((DirectoryObject)profile);
                } else {
                    this.LOGGER.info("No profile found for name '" + params[1] + "'.");
                }
            } else {
                this.showOverview();
            }
        }
    }

    public void showOverview() {
        try {
            ProfilesListOverviewPanelPresenter overviewPanelPresenter = this.createOverviewItemlistPanel(this.getViewTitleKey(), this.getAllItems());
            overviewPanelPresenter.setDeleteMandatSupplier(this.createDeleteMandateFunction());
            this.displayOverviewPanel(overviewPanelPresenter.getPanel());
        }
        catch (AllItemsListException e) {
            this.showError(e);
        }
    }

    protected Function<DirectoryObject, DeleteMandate> createDeleteMandateFunction() {
        return null;
    }

    public void showProfile(DirectoryObject profile) {
        try {
            ProfilePanel profilePanel = this.createProfilePanel(profile);
            ProfileReferencesPanel profileReferencesPanel = this.createReferencesPanel(profile);
            this.displayProfilePanel(profilePanel, profileReferencesPanel);
        }
        catch (BuildProfileException e) {
            this.showError(e);
        }
    }

    public void displayOverviewPanel(ProfilesListOverviewPanel overviewPanel) {
        this.clientSettingsVL.setVisible(false);
        this.clientReferencesCL.setVisible(false);
        this.clientCL.setVisible(false);
        this.actionRow.setVisible(true);
        this.overviewCL.removeAllComponents();
        this.overviewCL.addComponent((Component)overviewPanel);
        this.overviewCL.setVisible(true);
    }

    public void displayProfilePanel(ProfilePanel profilePanel, ProfileReferencesPanel profileReferencesPanel) {
        this.actionRow.setVisible(false);
        this.overviewCL.setVisible(false);
        this.clientCL.setVisible(true);
        this.clientSettingsVL.removeAllComponents();
        this.clientSettingsVL.addComponent((Component)profilePanel);
        this.clientReferencesCL.removeAllComponents();
        if (profileReferencesPanel != null) {
            this.clientReferencesCL.addComponent(this.clientReferencesCaption);
            this.clientReferencesCL.addComponent((Component)profileReferencesPanel);
            this.clientReferencesCL.setVisible(true);
        } else {
            this.clientReferencesCL.setVisible(false);
        }
    }

    public void navigateTo(DirectoryObject directoryObject) {
        Navigator navigator = UI.getCurrent().getNavigator();
        if (directoryObject != null) {
            navigator.navigateTo(this.getViewName() + "/edit/" + directoryObject.getName());
        } else {
            navigator.navigateTo(this.getParentViewName());
        }
    }

    public RealmService getRealmService() {
        return this.realmService;
    }
}

