/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ApplicationGroupView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="application_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_APPLICATION_HEADER", order=30)
@ThemeIcon(value="icon/application.svg")
public final class ApplicationView
extends AbstractThinclientView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationView.class);
    public static final String NAME = "application_view";
    public static final String ICON = "icon/application.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_APPLICATION_HEADER;
    @Autowired
    private ApplicationGroupView applicationGroupView;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    private final IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());

    public ApplicationView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_APPLICATION_HEADER, eventBus, notificationService);
    }

    @PostConstruct
    public void setup() {
        this.addStyleName(NAME);
        this.addCreateActionButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_ADD_APPLICATION_LABEL, new Object[0]), ICON, "application_view/create");
    }

    @Override
    public Set getAllItems() {
        try {
            return this.applicationService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(Application.class, schemaName);
    }

    @Override
    public Client getClient(String name) {
        return (Client)this.clientService.findByName(name);
    }

    @Override
    public Map<String, String> getSchemaNames() {
        return Stream.of(this.schemaProvider.getSchemaNames(Application.class)).collect(Collectors.toMap(schemaName -> schemaName, schemaName -> this.getSchema((String)schemaName).getLabel()));
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) throws BuildProfileException {
        Profile profile = (Profile)directoryObject;
        Map<String, String> schemaNames = this.getSchemaNames();
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(schemaNames, profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        String type = meta.getProperty("type").get().getConfiguration().getValue();
        ProfilePanel profilePanel = new ProfilePanel(profile.getName() + " (" + schemaNames.getOrDefault(type, type) + ")", profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractThinclientView)this, profilePanel, profile);
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        Profile profile = (Profile)item;
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(item.getClass());
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set allApplicationGroups = this.applicationGroupService.findAll();
        Set applicationGroupsByApplication = allApplicationGroups.stream().filter(ag -> ag.getApplications().contains(profile)).collect(Collectors.toSet());
        refPresenter.showReference(applicationGroupsByApplication, this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), allApplicationGroups, ApplicationGroup.class, values -> this.saveApplicationGroupReference((Application)profile, (List<Item>)values), this.getApplicationsForApplicationGroupFunction(), false);
        Set members = ((Application)profile).getMembers();
        Set userGroups = this.userGroupService.findAll();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERGROUP_HEADER, new Object[0]), userGroups, UserGroup.class, values -> this.saveReference(item, (List<Item>)values, userGroups, UserGroup.class));
        Set allUsers = this.userService.findAll();
        this.getRealmService().findAllRealms().forEach(realm -> allUsers.removeAll(realm.getAdministrators().getMembers()));
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USER_HEADER, new Object[0]), allUsers, User.class, values -> this.saveReference((DirectoryObject)profile, (List<Item>)values, allUsers, User.class));
        Set allClients = this.clientService.findAllClientMetaData();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), allClients, Client.class, values -> this.saveReference((DirectoryObject)profile, (List<Item>)values, allClients, Client.class));
        return referencesPanel;
    }

    private void saveApplicationGroupReference(Application application, List<Item> values) {
        Set oldValues = ((Application)this.applicationService.findByName(application.getName())).getMembers();
        LOGGER.debug("Old application-groups: {}", (Object)oldValues);
        oldValues.stream().filter(directoryObject -> directoryObject instanceof ApplicationGroup).forEach(oldItem -> {
            if (values.stream().anyMatch(a -> a.getName().equals(oldItem.getName()))) {
                LOGGER.info("Keep oldValue as member: " + oldItem);
            } else {
                LOGGER.info("Remove oldValue from application: " + oldItem);
                if (application.getMembers().contains(oldItem)) {
                    application.getMembers().remove(oldItem);
                } else {
                    LOGGER.info("ApplicationGroup (to remove) not found in members of " + oldItem);
                }
            }
        });
        values.forEach(newValue -> {
            ApplicationGroup applicationGroup1 = (ApplicationGroup)this.applicationGroupService.findByName(newValue.getName());
            if (applicationGroup1 != null) {
                if (!oldValues.contains(applicationGroup1)) {
                    LOGGER.info("Add ApplicationGroup {} as member of {}", (Object)applicationGroup1.getName(), (Object)application);
                    application.getMembers().add(applicationGroup1);
                }
            } else {
                LOGGER.info("ApplicationGroup not found for " + newValue);
            }
        });
        this.applicationService.save((DirectoryObject)application);
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String profileName) {
        return (T)this.applicationService.findByName(profileName);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.applicationService.save((DirectoryObject)((Application)profile));
        Audit.logSave(profile);
    }

    private Function<Item, List<Item>> getApplicationsForApplicationGroupFunction() {
        return appGroup -> {
            Optional<ApplicationGroup> first = this.applicationGroupService.findAll().stream().filter(ag -> ag.getName().equals(appGroup.getName())).findFirst();
            if (first.isPresent()) {
                ApplicationGroup applicationGroup = first.get();
                LOGGER.info("ApplicationGroup {} with applications {} loaded.", (Object)applicationGroup.getName(), (Object)applicationGroup.getApplications());
                return applicationGroup.getApplications().stream().map(m -> new Item(m.getName(), Item.Type.APPLICATION)).collect(Collectors.toList());
            }
            return new ArrayList();
        };
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }

    @Override
    public void showOverview() {
        super.showOverview();
        this.overviewCL.addComponent((Component)this.applicationGroupView.createOverviewItemlistPanel(this.applicationGroupView.getViewTitleKey(), this.applicationGroupView.getAllItems()).getPanel());
    }
}

