/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.DeleteMandate;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="hardwaretype_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_HWTYPE_HEADER", order=70)
@ThemeIcon(value="icon/hardwaretype.svg")
public final class HardwaretypeView
extends AbstractThinclientView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractThinclientView.class);
    public static final String NAME = "hardwaretype_view";
    public static final String ICON = "icon/hardwaretype.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_HWTYPE_HEADER;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    private final IMessageConveyor mc;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    public HardwaretypeView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_HWTYPE_HEADER, eventBus, notificationService);
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
    }

    @PostConstruct
    private void setup() {
        this.addStyleName(NAME);
        this.addCreateActionButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_ADD_HWTYPE_LABEL, new Object[0]), ICON, "hardwaretype_view/create");
    }

    @Override
    public Set getAllItems() {
        try {
            return this.hardwareTypeService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(HardwareType.class, schemaName);
    }

    @Override
    public Client getClient(String name) {
        return null;
    }

    @Override
    public Map<String, String> getSchemaNames() {
        return Stream.of(this.schemaProvider.getSchemaNames(HardwareType.class)).collect(Collectors.toMap(schemaName -> schemaName, schemaName -> this.getSchema((String)schemaName).getLabel()));
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) throws BuildProfileException {
        Profile profile = (Profile)directoryObject;
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        ProfilePanel profilePanel = new ProfilePanel(profile.getName(), profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractThinclientView)this, profilePanel, profile);
        presenter.setDeleteMandate(this.createDeleteMandateFunction());
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject directoryObject) {
        HardwareType hardwareType = (HardwareType)directoryObject;
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(HardwareType.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set members = hardwareType.getMembers();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]) + " (readonly)", Collections.emptySet(), Client.class, values -> this.saveReference((DirectoryObject)hardwareType, (List<Item>)values, Collections.emptySet(), Client.class), null, true);
        Map associatedObjects = hardwareType.getAssociatedObjects();
        Set devices = (Set)associatedObjects.get(Device.class);
        Set all = this.deviceService.findAll();
        refPresenter.showDeviceAssociations(all, devices, values -> this.saveAssociations((AssociatedObjectsProvider)hardwareType, (List<Item>)values, all, Device.class));
        return referencesPanel;
    }

    @Override
    protected Function<DirectoryObject, DeleteMandate> createDeleteMandateFunction() {
        return directoryObject -> {
            HardwareType hwtype = (HardwareType)directoryObject;
            if (hwtype.getMembers().size() > 0) {
                return new DeleteMandate(false, this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DELETE_HWTYPE_DENIED, new Object[]{hwtype.getName()}));
            }
            return new DeleteMandate(true, "");
        };
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String name) {
        return (T)this.hardwareTypeService.findByName(name);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.hardwareTypeService.save((DirectoryObject)((HardwareType)profile));
        Audit.logSave(profile);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }
}

