/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.component;

import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openthinclient.web.thinclient.component.PropertyComponent;
import org.openthinclient.web.thinclient.component.PropertyMacSelect;
import org.openthinclient.web.thinclient.component.PropertyPasswordField;
import org.openthinclient.web.thinclient.component.PropertySelect;
import org.openthinclient.web.thinclient.component.PropertyTextField;
import org.openthinclient.web.thinclient.property.OtcMacProperty;
import org.openthinclient.web.thinclient.property.OtcOptionProperty;
import org.openthinclient.web.thinclient.property.OtcPasswordProperty;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.thinclient.property.OtcTextProperty;

public class ItemGroupPanel
extends VerticalLayout {
    private Map<PropertyComponent, Component> propertyComponents = new HashMap<PropertyComponent, Component>();

    public ItemGroupPanel(OtcPropertyGroup propertyGroup) {
        this.setMargin(false);
        this.setSpacing(false);
        this.setStyleName("itemGroupPanel");
        if (propertyGroup.getLabel() != null) {
            CssLayout head = new CssLayout();
            head.addComponents(new Component[]{new Label(propertyGroup.getLabel())});
            this.addContextInfoComponents((Layout)head, propertyGroup.getTip());
            head.setStyleName("itemGroupHeader");
            this.addComponent((Component)head);
        }
        propertyGroup.getOtcProperties().forEach(p -> this.addProperty((OtcProperty)p, 0));
        propertyGroup.getGroups().forEach(pg -> this.addProperty((OtcPropertyGroup)pg, 1));
    }

    public ItemGroupPanel(List<OtcProperty> otcProperties) {
        this.setMargin(false);
        this.setSpacing(false);
        this.setStyleName("itemGroupPanel");
        otcProperties.forEach(p -> this.addProperty((OtcProperty)p, 0));
    }

    public void addProperty(OtcProperty property, int level) {
        CssLayout proprow = new CssLayout();
        proprow.addStyleNames(new String[]{"property", "property-" + level});
        Label propertyLabel = new Label(property.getLabel());
        propertyLabel.setStyleName("propertyLabel");
        proprow.addComponent((Component)propertyLabel);
        PropertyComponent pc = this.createPropertyComponent(property);
        proprow.addComponent((Component)pc);
        this.addContextInfoComponents((Layout)proprow, property.getTip());
        Label validationLabel = new Label(property.getLabel());
        validationLabel.setStyleName("validationLabel");
        proprow.addComponent((Component)validationLabel);
        this.propertyComponents.put(pc, (Component)validationLabel);
        this.addComponent((Component)proprow);
    }

    public void addProperty(OtcPropertyGroup propertyGroup, int level) {
        if (propertyGroup.getLabel() != null) {
            CssLayout row = new CssLayout();
            row.addComponents(new Component[]{new Label(propertyGroup.getLabel())});
            this.addContextInfoComponents((Layout)row, propertyGroup.getTip());
            row.addStyleNames(new String[]{"propertyGroupLabel", "propertyGroupLabel-" + level});
            this.addComponent((Component)row);
        }
        propertyGroup.getOtcProperties().forEach(p -> this.addProperty((OtcProperty)p, level));
        propertyGroup.getGroups().forEach(pg -> this.addProperty((OtcPropertyGroup)pg, level + 1));
    }

    private void addContextInfoComponents(Layout layout, String tip) {
        if (tip == null) {
            return;
        }
        Button button = new Button();
        button.addStyleNames(new String[]{"context-info-button", "borderless"});
        Label info = new Label(tip, ContentMode.HTML);
        info.setStyleName("context-info-label");
        layout.addComponents(new Component[]{button, info});
    }

    private PropertyComponent createPropertyComponent(OtcProperty property) {
        if (property instanceof OtcPasswordProperty) {
            return new PropertyPasswordField<OtcPasswordProperty>((OtcPasswordProperty)property);
        }
        if (property instanceof OtcTextProperty) {
            return new PropertyTextField<OtcTextProperty>((OtcTextProperty)property);
        }
        if (property instanceof OtcOptionProperty) {
            return new PropertySelect<OtcOptionProperty>((OtcOptionProperty)property);
        }
        if (property instanceof OtcMacProperty) {
            return new PropertyMacSelect<OtcMacProperty>((OtcMacProperty)property);
        }
        throw new RuntimeException("Unknown Property-Type: " + property);
    }

    public List<PropertyComponent> propertyComponents() {
        return new ArrayList<PropertyComponent>(this.propertyComponents.keySet());
    }

    public Optional<PropertyComponent> getPropertyComponent(String key) {
        return this.propertyComponents.keySet().stream().filter(pc -> ((OtcProperty)pc.getBinder().getBean()).getKey().equals(key)).findFirst();
    }

    public void setValidationMessage(String key, String message) {
        this.getPropertyComponent(key).ifPresent(propertyComponent -> {
            Label component = (Label)this.propertyComponents.get(propertyComponent);
            component.setValue(message);
            component.setVisible(true);
        });
    }

    public void emptyValidationMessages() {
        this.propertyComponents.forEach((propertyComponent, component) -> component.setVisible(false));
    }
}

