/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.property;

import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.model.SelectOption;
import org.openthinclient.web.thinclient.property.OtcProperty;

public class OtcOptionProperty
extends OtcProperty {
    private ItemConfiguration config;
    private List<SelectOption> options;

    public OtcOptionProperty(String label, String tip, String key, String initialValue, String defaultValue, List<SelectOption> options) {
        super(label, tip, key, initialValue, defaultValue);
        this.options = options;
    }

    @Override
    public void setConfiguration(ItemConfiguration bean) {
        this.config = bean;
    }

    @Override
    public ItemConfiguration getConfiguration() {
        return this.config;
    }

    public String getValue() {
        return this.config.getValue();
    }

    public void setValue(String value) {
        this.config.setValue(value);
    }

    public List<SelectOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<SelectOption> options) {
        this.options = options;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("label", (Object)this.getLabel()).append("key", (Object)this.getKey()).append("value", (Object)this.getValue()).append("initialValue", (Object)this.getInitialValue()).append("defaultSchemaValue", (Object)this.getDefaultSchemaValue()).toString();
    }

    public SelectOption getSelectOption(String val) {
        String value = val == null || val.length() == 0 ? this.getInitialValue() : val;
        return this.options.stream().filter(selectOption -> selectOption.getValue().equals(value)).findFirst().orElse(null);
    }

    public void removeOptionValue(String value) {
        this.options.stream().filter(selectOption -> selectOption.getValue().equals(value)).findFirst().ifPresent(this.options::remove);
    }
}

