/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.db;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.openthinclient.service.common.home.Configuration;
import org.openthinclient.service.common.home.ConfigurationFile;

@ConfigurationFile(value="db.xml")
@XmlRootElement(name="database", namespace="http://www.openthinclient.org/ns/manager/database/1.0")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DatabaseConfiguration
implements Configuration {
    @XmlElement
    private DatabaseType type;
    @XmlElement
    private String url;
    @XmlElement
    private String username;
    @XmlElement
    private String password;

    public DatabaseType getType() {
        return this.type;
    }

    public void setType(DatabaseType type) {
        this.type = type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static enum DatabaseType {
        APACHE_DERBY("org.apache.derby.jdbc.EmbeddedDriver", true),
        MYSQL("com.mysql.jdbc.Driver", false),
        H2("org.h2.Driver", true);

        private final String driverClassName;
        private final boolean embedded;

        private DatabaseType(String driverClassName, boolean embedded) {
            this.driverClassName = driverClassName;
            this.embedded = embedded;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public boolean isDriverAvailable() {
            try {
                Class.forName(this.driverClassName);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        public boolean isEmbedded() {
            return this.embedded;
        }
    }
}

