/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.manager.util.http.impl.AbstractHttpAccessorBase;
import org.openthinclient.sysreport.StatisticsReport;
import org.openthinclient.sysreport.StatisticsReportWriter;
import org.openthinclient.sysreport.generate.StatisticsReportGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsReportPublisher {
    private final Logger LOGGER = LoggerFactory.getLogger(StatisticsReportPublisher.class);
    private final Uploader uploader;
    private final StatisticsReportGenerator statisticsReportGenerator;

    public StatisticsReportPublisher(StatisticsReportGenerator statisticsReportGenerator, Uploader uploader) {
        this.uploader = uploader;
        this.statisticsReportGenerator = statisticsReportGenerator;
    }

    public void publish() throws Exception {
        StatisticsReport report = (StatisticsReport)this.statisticsReportGenerator.generateReport();
        StatisticsReportWriter statisticsWriter = new StatisticsReportWriter(report);
        Path tempFile = Files.createTempFile("stats-", ".json", new FileAttribute[0]);
        this.LOGGER.debug("Writing statistics report file: {}", (Object)tempFile);
        try (OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
            statisticsWriter.write(out);
        }
        this.uploader.upload(tempFile);
        this.LOGGER.debug("Upload completed.");
        Files.delete(tempFile);
    }

    public static class Uploader
    extends AbstractHttpAccessorBase {
        private static final Logger LOGGER = LoggerFactory.getLogger(Uploader.class);
        private static final URI BASE_URI = URI.create("https://statistics.openthinclient.com/v1/statistics");

        public Uploader(NetworkConfiguration.ProxyConfiguration proxyConfig) {
            super(proxyConfig, "openthinclient.org manager");
        }

        public void upload(Path statisticsFile) {
            HttpResponse response;
            HttpPost put = new HttpPost(BASE_URI);
            put.setEntity((HttpEntity)new FileEntity(statisticsFile.toFile(), ContentType.APPLICATION_JSON));
            try {
                response = this.httpClient.execute((HttpUriRequest)put);
            }
            catch (IOException e) {
                LOGGER.error("Statistics Report upload failed", (Throwable)e);
                return;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                LOGGER.error("System report upload failed.", (Object)response);
            }
        }
    }
}

