/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.ServerUtils;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.authz.GroupCache;
import org.apache.directory.server.core.authz.TupleCache;
import org.apache.directory.server.core.authz.support.ACDFEngine;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.ServerContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.subtree.SubentryService;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationService
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger((Class)AuthorizationService.class);
    private static final String ENTRYACI_ATTR = "entryACI";
    private static final String SUBENTRYACI_ATTR = "subentryACI";
    private static final String AC_SUBENTRY_ATTR = "accessControlSubentries";
    private static final Collection ADD_PERMS;
    private static final Collection READ_PERMS;
    private static final Collection COMPARE_PERMS;
    private static final Collection SEARCH_ENTRY_PERMS;
    private static final Collection SEARCH_ATTRVAL_PERMS;
    private static final Collection REMOVE_PERMS;
    private static final Collection MATCHEDNAME_PERMS;
    private static final Collection BROWSE_PERMS;
    private static final Collection LOOKUP_PERMS;
    private static final Collection REPLACE_PERMS;
    private static final Collection RENAME_PERMS;
    private static final Collection EXPORT_PERMS;
    private static final Collection IMPORT_PERMS;
    private static final Collection MOVERENAME_PERMS;
    private TupleCache tupleCache;
    private GroupCache groupCache;
    private ACIItemParser aciParser;
    private ACDFEngine engine;
    private InterceptorChain chain;
    private AttributeTypeRegistry attrRegistry;
    private boolean enabled = false;
    private String subschemaSubentryDn;
    private AttributeType objectClassType;
    private AttributeType acSubentryType;
    private String objectClassOid;
    private String subentryOid;
    private String acSubentryOid;
    public static final SearchControls DEFAULT_SEARCH_CONTROLS;

    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        super.init(factoryCfg, cfg);
        this.tupleCache = new TupleCache(factoryCfg);
        this.groupCache = new GroupCache(factoryCfg);
        this.attrRegistry = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry();
        OidRegistry oidRegistry = factoryCfg.getGlobalRegistries().getOidRegistry();
        this.objectClassOid = oidRegistry.getOid("objectClass");
        this.subentryOid = oidRegistry.getOid("subentry");
        this.acSubentryOid = oidRegistry.getOid(AC_SUBENTRY_ATTR);
        this.objectClassType = this.attrRegistry.lookup(this.objectClassOid);
        this.acSubentryType = this.attrRegistry.lookup(this.acSubentryOid);
        this.aciParser = new ACIItemParser((NameComponentNormalizer)new ConcreteNameComponentNormalizer(this.attrRegistry, oidRegistry), this.attrRegistry.getNormalizerMapping());
        this.engine = new ACDFEngine(factoryCfg.getGlobalRegistries().getOidRegistry(), this.attrRegistry);
        this.chain = factoryCfg.getInterceptorChain();
        this.enabled = factoryCfg.getStartupConfiguration().isAccessControlEnabled();
        String subschemaSubentry = (String)factoryCfg.getPartitionNexus().getRootDSE().get("subschemaSubentry").get();
        LdapDN subschemaSubentryDnName = new LdapDN(subschemaSubentry);
        subschemaSubentryDnName.normalize(this.attrRegistry.getNormalizerMapping());
        this.subschemaSubentryDn = subschemaSubentryDnName.toNormName();
    }

    private LdapDN parseNormalized(String name) throws NamingException {
        LdapDN dn = new LdapDN(name);
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return dn;
    }

    private void addPerscriptiveAciTuples(PartitionNexusProxy proxy, Collection tuples, LdapDN dn, Attributes entry) throws NamingException {
        Attribute subentries;
        Attribute oc = ServerUtils.getAttribute(this.objectClassType, entry);
        if (AttributeUtils.containsValue((Attribute)oc, (Object)"subentry", (AttributeType)this.objectClassType) || AttributeUtils.containsValueCaseIgnore((Attribute)oc, (Object)this.subentryOid)) {
            LdapDN parentDn = (LdapDN)dn.clone();
            parentDn.remove(dn.size() - 1);
            entry = proxy.lookup(parentDn, PartitionNexusProxy.LOOKUP_BYPASS);
        }
        if ((subentries = ServerUtils.getAttribute(this.acSubentryType, entry)) == null) {
            return;
        }
        for (int ii = 0; ii < subentries.size(); ++ii) {
            String subentryDn = (String)subentries.get(ii);
            tuples.addAll(this.tupleCache.getACITuples(subentryDn));
        }
    }

    private void addEntryAciTuples(Collection tuples, Attributes entry) throws NamingException {
        Attribute entryAci = entry.get(ENTRYACI_ATTR);
        if (entryAci == null) {
            return;
        }
        for (int ii = 0; ii < entryAci.size(); ++ii) {
            ACIItem item;
            String aciString = (String)entryAci.get(ii);
            try {
                item = this.aciParser.parse(aciString);
            }
            catch (ParseException e) {
                String msg = "failed to parse entryACI: " + aciString;
                log.error(msg, (Throwable)e);
                throw new LdapNamingException(msg, ResultCodeEnum.OPERATIONSERROR);
            }
            tuples.addAll(item.toTuples());
        }
    }

    private void addSubentryAciTuples(PartitionNexusProxy proxy, Collection tuples, LdapDN dn, Attributes entry) throws NamingException {
        if (!AttributeUtils.containsValueCaseIgnore((Attribute)entry.get("objectClass"), (Object)"subentry")) {
            return;
        }
        LdapDN parentDn = (LdapDN)dn.clone();
        parentDn.remove(dn.size() - 1);
        Attributes administrativeEntry = proxy.lookup(parentDn, new String[]{SUBENTRYACI_ATTR}, PartitionNexusProxy.LOOKUP_BYPASS);
        Attribute subentryAci = administrativeEntry.get(SUBENTRYACI_ATTR);
        if (subentryAci == null) {
            return;
        }
        for (int ii = 0; ii < subentryAci.size(); ++ii) {
            ACIItem item;
            String aciString = (String)subentryAci.get(ii);
            try {
                item = this.aciParser.parse(aciString);
            }
            catch (ParseException e) {
                String msg = "failed to parse subentryACI: " + aciString;
                log.error(msg, (Throwable)e);
                throw new LdapNamingException(msg, ResultCodeEnum.OPERATIONSERROR);
            }
            tuples.addAll(item.toTuples());
        }
    }

    public void add(NextInterceptor next, LdapDN normName, Attributes entry) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.add(normName, entry);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.add(normName, entry);
            this.tupleCache.subentryAdded(normName.toNormName(), normName, entry);
            this.groupCache.groupAdded(normName.toNormName(), (Name)normName, entry);
            return;
        }
        SubentryService subentryService = (SubentryService)this.chain.get("subentryService");
        Attributes subentryAttrs = subentryService.getSubentryAttributes((Name)normName, entry);
        NamingEnumeration<? extends Attribute> attrList = entry.getAll();
        while (attrList.hasMore()) {
            subentryAttrs.put(attrList.next());
        }
        Set userGroups = this.groupCache.getGroups(principalDn.toNormName());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(invocation.getProxy(), tuples, normName, subentryAttrs);
        this.addSubentryAciTuples(invocation.getProxy(), tuples, normName, subentryAttrs);
        PartitionNexusProxy proxy = invocation.getProxy();
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), normName, null, null, ADD_PERMS, tuples, subentryAttrs);
        NamingEnumeration<? extends Attribute> attributeList = entry.getAll();
        while (attributeList.hasMore()) {
            Attribute attr = attributeList.next();
            for (int ii = 0; ii < attr.size(); ++ii) {
                this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), normName, attr.getID(), attr.get(ii), ADD_PERMS, tuples, entry);
            }
        }
        next.add(normName, entry);
        this.tupleCache.subentryAdded(normName.toNormName(), normName, entry);
        this.groupCache.groupAdded(normName.toNormName(), (Name)normName, entry);
    }

    public void delete(NextInterceptor next, LdapDN name) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(name, PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.delete(name);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.delete(name);
            this.tupleCache.subentryDeleted((Name)name, entry);
            this.groupCache.groupDeleted((Name)name, entry);
            return;
        }
        Set userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, REMOVE_PERMS, tuples, entry);
        next.delete(name);
        this.tupleCache.subentryDeleted((Name)name, entry);
        this.groupCache.groupDeleted((Name)name, entry);
    }

    public void modify(NextInterceptor next, LdapDN name, int modOp, Attributes mods) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(name, PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.modify(name, modOp, mods);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.modify(name, modOp, mods);
            this.tupleCache.subentryModified(name, modOp, mods, entry);
            this.groupCache.groupModified((Name)name, modOp, mods, entry);
            return;
        }
        Set userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, Collections.singleton(MicroOperation.MODIFY), tuples, entry);
        NamingEnumeration<? extends Attribute> attrList = mods.getAll();
        Collection perms = null;
        switch (modOp) {
            case 1: {
                perms = ADD_PERMS;
                break;
            }
            case 3: {
                perms = REMOVE_PERMS;
                break;
            }
            case 2: {
                perms = REPLACE_PERMS;
            }
        }
        while (attrList.hasMore()) {
            Attribute attr = attrList.next();
            for (int ii = 0; ii < attr.size(); ++ii) {
                this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, attr.getID(), attr.get(ii), perms, tuples, entry);
            }
        }
        next.modify(name, modOp, mods);
        this.tupleCache.subentryModified(name, modOp, mods, entry);
        this.groupCache.groupModified((Name)name, modOp, mods, entry);
    }

    public void modify(NextInterceptor next, LdapDN name, ModificationItemImpl[] mods) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(name, PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.modify(name, mods);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.modify(name, mods);
            this.tupleCache.subentryModified(name, mods, entry);
            this.groupCache.groupModified((Name)name, mods, entry);
            return;
        }
        Set userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, Collections.singleton(MicroOperation.MODIFY), tuples, entry);
        Collection perms = null;
        for (int ii = 0; ii < mods.length; ++ii) {
            switch (mods[ii].getModificationOp()) {
                case 1: {
                    perms = ADD_PERMS;
                    break;
                }
                case 3: {
                    perms = REMOVE_PERMS;
                    break;
                }
                case 2: {
                    perms = REPLACE_PERMS;
                }
            }
            Attribute attr = mods[ii].getAttribute();
            for (int jj = 0; jj < attr.size(); ++jj) {
                this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, attr.getID(), attr.get(jj), perms, tuples, entry);
            }
        }
        next.modify(name, mods);
        this.tupleCache.subentryModified(name, mods, entry);
        this.groupCache.groupModified((Name)name, mods, entry);
    }

    public boolean hasEntry(NextInterceptor next, LdapDN name) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(name, PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled || name.toString().trim().equals("")) {
            return next.hasEntry(name);
        }
        Set userGroups = this.groupCache.getGroups(principalDn.toNormName());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, BROWSE_PERMS, tuples, entry);
        return next.hasEntry(name);
    }

    private void checkLookupAccess(LdapPrincipal principal, LdapDN dn, Attributes entry) throws NamingException {
        if (dn.toString().trim().equals("")) {
            return;
        }
        PartitionNexusProxy proxy = InvocationStack.getInstance().peek().getProxy();
        LdapDN userName = principal.getJndiName();
        Set userGroups = this.groupCache.getGroups(userName.toNormName());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, tuples, dn, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, dn, entry);
        this.engine.checkPermission(proxy, userGroups, userName, principal.getAuthenticationLevel(), dn, null, null, LOOKUP_PERMS, tuples, entry);
        NamingEnumeration<? extends Attribute> attributeList = entry.getAll();
        while (attributeList.hasMore()) {
            Attribute attr = attributeList.next();
            for (int ii = 0; ii < attr.size(); ++ii) {
                this.engine.checkPermission(proxy, userGroups, userName, principal.getAuthenticationLevel(), dn, attr.getID(), attr.get(ii), READ_PERMS, tuples, entry);
            }
        }
    }

    public Attributes lookup(NextInterceptor next, LdapDN dn, String[] attrIds) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = new LdapDN(principal.getName());
        principalDn.normalize(this.attrRegistry.getNormalizerMapping());
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled) {
            return next.lookup(dn, attrIds);
        }
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(dn, PartitionNexusProxy.LOOKUP_BYPASS);
        this.checkLookupAccess(principal, dn, entry);
        return next.lookup(dn, attrIds);
    }

    public Attributes lookup(NextInterceptor next, LdapDN name) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(name, PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal user = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = user.getJndiName();
        principalDn.normalize(this.attrRegistry.getNormalizerMapping());
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled) {
            return next.lookup(name);
        }
        this.checkLookupAccess(user, name, entry);
        return next.lookup(name);
    }

    public void modifyRn(NextInterceptor next, LdapDN name, String newRn, boolean deleteOldRn) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(name, PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        LdapDN newName = (LdapDN)name.clone();
        newName.remove(name.size() - 1);
        newName.add(this.parseNormalized(newRn).get(0));
        if (!this.enabled) {
            next.modifyRn(name, newRn, deleteOldRn);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.modifyRn(name, newRn, deleteOldRn);
            this.tupleCache.subentryRenamed((Name)name, (Name)newName);
            if (this.groupCache.groupRenamed((Name)name, (Name)newName)) {
                // empty if block
            }
            return;
        }
        Set userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, RENAME_PERMS, tuples, entry);
        next.modifyRn(name, newRn, deleteOldRn);
        this.tupleCache.subentryRenamed((Name)name, (Name)newName);
        this.groupCache.groupRenamed((Name)name, (Name)newName);
    }

    public void move(NextInterceptor next, LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(oriChildName, PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        LdapDN newName = (LdapDN)newParentName.clone();
        newName.add(newRn);
        if (!this.enabled) {
            next.move(oriChildName, newParentName, newRn, deleteOldRn);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.move(oriChildName, newParentName, newRn, deleteOldRn);
            this.tupleCache.subentryRenamed((Name)oriChildName, (Name)newName);
            this.groupCache.groupRenamed((Name)oriChildName, (Name)newName);
            return;
        }
        Set userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, tuples, oriChildName, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, oriChildName, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), oriChildName, null, null, MOVERENAME_PERMS, tuples, entry);
        Attributes importedEntry = proxy.lookup(oriChildName, PartitionNexusProxy.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryService subentryService = (SubentryService)this.chain.get("subentryService");
        Attributes subentryAttrs = subentryService.getSubentryAttributes((Name)newName, importedEntry);
        NamingEnumeration<? extends Attribute> attrList = importedEntry.getAll();
        while (attrList.hasMore()) {
            subentryAttrs.put(attrList.next());
        }
        HashSet destTuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, destTuples, newName, subentryAttrs);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), newName, null, null, IMPORT_PERMS, destTuples, subentryAttrs);
        next.move(oriChildName, newParentName, newRn, deleteOldRn);
        this.tupleCache.subentryRenamed((Name)oriChildName, (Name)newName);
        this.groupCache.groupRenamed((Name)oriChildName, (Name)newName);
    }

    public void move(NextInterceptor next, LdapDN oriChildName, LdapDN newParentName) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(oriChildName, PartitionNexusProxy.LOOKUP_BYPASS);
        LdapDN newName = (LdapDN)newParentName.clone();
        newName.add(oriChildName.get(oriChildName.size() - 1));
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (!this.enabled) {
            next.move(oriChildName, newParentName);
            return;
        }
        if (this.isPrincipalAnAdministrator(principalDn)) {
            next.move(oriChildName, newParentName);
            this.tupleCache.subentryRenamed((Name)oriChildName, (Name)newName);
            this.groupCache.groupRenamed((Name)oriChildName, (Name)newName);
            return;
        }
        Set userGroups = this.groupCache.getGroups(principalDn.toString());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, tuples, oriChildName, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, oriChildName, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), oriChildName, null, null, EXPORT_PERMS, tuples, entry);
        Attributes importedEntry = proxy.lookup(oriChildName, PartitionNexusProxy.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryService subentryService = (SubentryService)this.chain.get("subentryService");
        Attributes subentryAttrs = subentryService.getSubentryAttributes((Name)newName, importedEntry);
        NamingEnumeration<? extends Attribute> attrList = importedEntry.getAll();
        while (attrList.hasMore()) {
            subentryAttrs.put(attrList.next());
        }
        HashSet destTuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, destTuples, newName, subentryAttrs);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), newName, null, null, IMPORT_PERMS, destTuples, subentryAttrs);
        next.move(oriChildName, newParentName);
        this.tupleCache.subentryRenamed((Name)oriChildName, (Name)newName);
        this.groupCache.groupRenamed((Name)oriChildName, (Name)newName);
    }

    public NamingEnumeration list(NextInterceptor next, LdapDN base) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext ctx = (ServerLdapContext)invocation.getCaller();
        LdapPrincipal user = ctx.getPrincipal();
        NamingEnumeration e = next.list(base);
        if (this.isPrincipalAnAdministrator(user.getJndiName()) || !this.enabled) {
            return e;
        }
        AuthorizationFilter authzFilter = new AuthorizationFilter();
        return new SearchResultFilteringEnumeration(e, DEFAULT_SEARCH_CONTROLS, invocation, authzFilter);
    }

    public NamingEnumeration search(NextInterceptor next, LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        boolean isRootDSELookup;
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext ctx = (ServerLdapContext)invocation.getCaller();
        LdapPrincipal user = ctx.getPrincipal();
        LdapDN principalDn = user.getJndiName();
        NamingEnumeration e = next.search(base, env, filter, searchCtls);
        boolean isSubschemaSubentryLookup = this.subschemaSubentryDn.equals(base.toNormName());
        boolean bl = isRootDSELookup = base.size() == 0 && searchCtls.getSearchScope() == 0;
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled || isRootDSELookup || isSubschemaSubentryLookup) {
            return e;
        }
        AuthorizationFilter authzFilter = new AuthorizationFilter();
        return new SearchResultFilteringEnumeration(e, searchCtls, invocation, authzFilter);
    }

    public final boolean isPrincipalAnAdministrator(LdapDN principalDn) throws NamingException {
        return this.groupCache.isPrincipalAnAdministrator(principalDn);
    }

    public boolean compare(NextInterceptor next, LdapDN name, String oid, Object value) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        Attributes entry = proxy.lookup(name, PartitionNexusProxy.LOOKUP_BYPASS);
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled) {
            return next.compare(name, oid, value);
        }
        Set userGroups = this.groupCache.getGroups(principalDn.toNormName());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(proxy, tuples, name, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(proxy, tuples, name, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, null, null, READ_PERMS, tuples, entry);
        this.engine.checkPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), name, oid, value, COMPARE_PERMS, tuples, entry);
        return next.compare(name, oid, value);
    }

    public LdapDN getMatchedName(NextInterceptor next, LdapDN dn) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        PartitionNexusProxy proxy = invocation.getProxy();
        LdapPrincipal principal = ((ServerContext)invocation.getCaller()).getPrincipal();
        LdapDN principalDn = principal.getJndiName();
        if (this.isPrincipalAnAdministrator(principalDn) || !this.enabled) {
            return next.getMatchedName(dn);
        }
        LdapDN matched = next.getMatchedName(dn);
        while (matched.size() > 0) {
            Attributes entry = proxy.lookup(matched, PartitionNexusProxy.GETMATCHEDDN_BYPASS);
            Set userGroups = this.groupCache.getGroups(principalDn.toString());
            HashSet tuples = new HashSet();
            this.addPerscriptiveAciTuples(proxy, tuples, matched, entry);
            this.addEntryAciTuples(tuples, entry);
            this.addSubentryAciTuples(proxy, tuples, matched, entry);
            if (this.engine.hasPermission(proxy, userGroups, principalDn, principal.getAuthenticationLevel(), matched, null, null, MATCHEDNAME_PERMS, tuples, entry)) {
                return matched;
            }
            matched.remove(matched.size() - 1);
        }
        return matched;
    }

    public void cacheNewGroup(String upName, LdapDN normName, Attributes entry) throws NamingException {
        this.groupCache.groupAdded(upName, (Name)normName, entry);
    }

    private boolean filter(Invocation invocation, LdapDN normName, SearchResult result) throws NamingException {
        Attributes entry = invocation.getProxy().lookup(normName, PartitionNexusProxy.LOOKUP_BYPASS);
        ServerLdapContext ctx = (ServerLdapContext)invocation.getCaller();
        LdapDN userDn = ctx.getPrincipal().getJndiName();
        Set userGroups = this.groupCache.getGroups(userDn.toNormName());
        HashSet tuples = new HashSet();
        this.addPerscriptiveAciTuples(invocation.getProxy(), tuples, normName, entry);
        this.addEntryAciTuples(tuples, entry);
        this.addSubentryAciTuples(invocation.getProxy(), tuples, normName, entry);
        if (!this.engine.hasPermission(invocation.getProxy(), userGroups, userDn, ctx.getPrincipal().getAuthenticationLevel(), normName, null, null, SEARCH_ENTRY_PERMS, tuples, entry)) {
            return false;
        }
        NamingEnumeration<String> idList = result.getAttributes().getIDs();
        while (idList.hasMore()) {
            String id = idList.next();
            Attribute attr = result.getAttributes().get(id);
            if (!this.engine.hasPermission(invocation.getProxy(), userGroups, userDn, ctx.getPrincipal().getAuthenticationLevel(), normName, attr.getID(), null, SEARCH_ATTRVAL_PERMS, tuples, entry)) {
                result.getAttributes().remove(attr.getID());
                if (attr.size() != 0) continue;
                result.getAttributes().remove(attr.getID());
                continue;
            }
            for (int ii = 0; ii < attr.size(); ++ii) {
                if (this.engine.hasPermission(invocation.getProxy(), userGroups, userDn, ctx.getPrincipal().getAuthenticationLevel(), normName, attr.getID(), attr.get(ii), SEARCH_ATTRVAL_PERMS, tuples, entry)) continue;
                attr.remove(ii);
                if (ii <= 0) continue;
                --ii;
            }
        }
        return true;
    }

    static {
        HashSet<MicroOperation> set = new HashSet<MicroOperation>(2);
        set.add(MicroOperation.BROWSE);
        set.add(MicroOperation.RETURN_DN);
        SEARCH_ENTRY_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.READ);
        set.add(MicroOperation.BROWSE);
        LOOKUP_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.ADD);
        set.add(MicroOperation.REMOVE);
        REPLACE_PERMS = Collections.unmodifiableCollection(set);
        set = new HashSet(2);
        set.add(MicroOperation.EXPORT);
        set.add(MicroOperation.RENAME);
        MOVERENAME_PERMS = Collections.unmodifiableCollection(set);
        SEARCH_ATTRVAL_PERMS = Collections.singleton(MicroOperation.READ);
        ADD_PERMS = Collections.singleton(MicroOperation.ADD);
        READ_PERMS = Collections.singleton(MicroOperation.READ);
        COMPARE_PERMS = Collections.singleton(MicroOperation.COMPARE);
        REMOVE_PERMS = Collections.singleton(MicroOperation.REMOVE);
        MATCHEDNAME_PERMS = Collections.singleton(MicroOperation.DISCLOSE_ON_ERROR);
        BROWSE_PERMS = Collections.singleton(MicroOperation.BROWSE);
        RENAME_PERMS = Collections.singleton(MicroOperation.RENAME);
        EXPORT_PERMS = Collections.singleton(MicroOperation.EXPORT);
        IMPORT_PERMS = Collections.singleton(MicroOperation.IMPORT);
        DEFAULT_SEARCH_CONTROLS = new SearchControls();
    }

    class AuthorizationFilter
    implements SearchResultFilter {
        AuthorizationFilter() {
        }

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            LdapDN normName = AuthorizationService.this.parseNormalized(result.getName());
            return AuthorizationService.this.filter(invocation, normName, result);
        }
    }
}

