/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.name.LdapDN;

public class MaxValueCountFilter
implements ACITupleFilter {
    public Collection filter(Collection tuples, OperationScope scope, PartitionNexusProxy proxy, Collection userGroupNames, LdapDN userName, Attributes userEntry, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Object attrValue, Attributes entry, Collection microOperations) throws NamingException {
        if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) {
            return tuples;
        }
        if (tuples.size() == 0) {
            return tuples;
        }
        Iterator i = tuples.iterator();
        block0: while (i.hasNext()) {
            ACITuple tuple = (ACITuple)i.next();
            if (!tuple.isGrant()) continue;
            Iterator j = tuple.getProtectedItems().iterator();
            while (j.hasNext()) {
                ProtectedItem.MaxValueCount mvc;
                ProtectedItem item = (ProtectedItem)j.next();
                if (!(item instanceof ProtectedItem.MaxValueCount) || !this.isRemovable(mvc = (ProtectedItem.MaxValueCount)item, attrId, entry)) continue;
                i.remove();
                continue block0;
            }
        }
        return tuples;
    }

    private boolean isRemovable(ProtectedItem.MaxValueCount mvc, String attrId, Attributes entry) {
        Iterator k = mvc.iterator();
        while (k.hasNext()) {
            Attribute attr;
            int attrCount;
            ProtectedItem.MaxValueCountItem mvcItem = (ProtectedItem.MaxValueCountItem)k.next();
            if (!attrId.equalsIgnoreCase(mvcItem.getAttributeType()) || (attrCount = (attr = entry.get(attrId)) == null ? 0 : attr.size()) < mvcItem.getMaxCount()) continue;
            return true;
        }
        return false;
    }
}

