/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.name.LdapDN;

public class RestrictedByFilter
implements ACITupleFilter {
    public Collection filter(Collection tuples, OperationScope scope, PartitionNexusProxy proxy, Collection userGroupNames, LdapDN userName, Attributes userEntry, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Object attrValue, Attributes entry, Collection microOperations) throws NamingException {
        if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) {
            return tuples;
        }
        if (tuples.size() == 0) {
            return tuples;
        }
        Iterator i = tuples.iterator();
        while (i.hasNext()) {
            ACITuple tuple = (ACITuple)i.next();
            if (!tuple.isGrant() || !this.isRemovable(tuple, attrId, attrValue, entry)) continue;
            i.remove();
        }
        return tuples;
    }

    public boolean isRemovable(ACITuple tuple, String attrId, Object attrValue, Attributes entry) {
        Iterator i = tuple.getProtectedItems().iterator();
        while (i.hasNext()) {
            ProtectedItem item = (ProtectedItem)i.next();
            if (!(item instanceof ProtectedItem.RestrictedBy)) continue;
            ProtectedItem.RestrictedBy rb = (ProtectedItem.RestrictedBy)item;
            Iterator k = rb.iterator();
            while (k.hasNext()) {
                Attribute attr;
                ProtectedItem.RestrictedByItem rbItem = (ProtectedItem.RestrictedByItem)k.next();
                if (!attrId.equalsIgnoreCase(rbItem.getAttributeType()) || (attr = entry.get(rbItem.getValuesIn())) != null && attr.contains(attrValue)) continue;
                return true;
            }
        }
        return false;
    }
}

