/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.authn.AnonymousAuthenticator;
import org.apache.directory.server.core.authn.AuthenticationService;
import org.apache.directory.server.core.authn.SimpleAuthenticator;
import org.apache.directory.server.core.authz.AuthorizationService;
import org.apache.directory.server.core.authz.DefaultAuthorizationService;
import org.apache.directory.server.core.collective.CollectiveAttributeService;
import org.apache.directory.server.core.configuration.AuthenticatorConfiguration;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.server.core.configuration.ConfigurationUtil;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.configuration.MutableAuthenticatorConfiguration;
import org.apache.directory.server.core.configuration.MutableInterceptorConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.event.EventService;
import org.apache.directory.server.core.exception.ExceptionService;
import org.apache.directory.server.core.normalization.NormalizationService;
import org.apache.directory.server.core.operational.OperationalAttributeService;
import org.apache.directory.server.core.referral.ReferralService;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.server.core.schema.bootstrap.AbstractBootstrapSchema;
import org.apache.directory.server.core.schema.bootstrap.ApacheSchema;
import org.apache.directory.server.core.schema.bootstrap.BootstrapSchema;
import org.apache.directory.server.core.schema.bootstrap.CollectiveSchema;
import org.apache.directory.server.core.schema.bootstrap.CoreSchema;
import org.apache.directory.server.core.schema.bootstrap.CosineSchema;
import org.apache.directory.server.core.schema.bootstrap.InetorgpersonSchema;
import org.apache.directory.server.core.schema.bootstrap.JavaSchema;
import org.apache.directory.server.core.schema.bootstrap.SystemSchema;
import org.apache.directory.server.core.subtree.SubentryService;
import org.apache.directory.shared.ldap.ldif.Entry;

public class StartupConfiguration
extends Configuration {
    private static final long serialVersionUID = 4826762196566871677L;
    public static final int MAX_THREADS_DEFAULT = 4;
    public static final int MAX_SIZE_LIMIT_DEFAULT = 100;
    public static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private File workingDirectory = new File("server-work");
    private boolean exitVmOnShutdown = true;
    private boolean shutdownHookEnabled = true;
    private boolean allowAnonymousAccess = true;
    private boolean accessControlEnabled = false;
    private boolean denormalizeOpAttrsEnabled = false;
    private int maxThreads = 4;
    private int maxSizeLimit = 100;
    private int maxTimeLimit = 10000;
    private Set authenticatorConfigurations;
    private List interceptorConfigurations;
    private PartitionConfiguration systemPartitionConfiguration;
    private Set bootstrapSchemas;
    private Set contextPartitionConfigurations = new HashSet();
    private List testEntries = new ArrayList();

    public StartupConfiguration() {
        this.setDefaultAuthenticatorConfigurations();
        this.setDefaultBootstrapSchemas();
        this.setDefaultInterceptorConfigurations();
    }

    public StartupConfiguration(String instanceId) {
        this.setDefaultAuthenticatorConfigurations();
        this.setDefaultBootstrapSchemas();
        this.setDefaultInterceptorConfigurations();
        this.setInstanceId(instanceId);
    }

    private void setDefaultAuthenticatorConfigurations() {
        HashSet<MutableAuthenticatorConfiguration> set = new HashSet<MutableAuthenticatorConfiguration>();
        MutableAuthenticatorConfiguration authCfg = new MutableAuthenticatorConfiguration();
        authCfg.setName("Anonymous");
        authCfg.setAuthenticator(new AnonymousAuthenticator());
        set.add(authCfg);
        authCfg = new MutableAuthenticatorConfiguration();
        authCfg.setName("Simple");
        authCfg.setAuthenticator(new SimpleAuthenticator());
        set.add(authCfg);
        this.setAuthenticatorConfigurations(set);
    }

    private void setDefaultBootstrapSchemas() {
        HashSet<AbstractBootstrapSchema> set = new HashSet<AbstractBootstrapSchema>();
        set.add(new CoreSchema());
        set.add(new CosineSchema());
        set.add(new ApacheSchema());
        set.add(new InetorgpersonSchema());
        set.add(new JavaSchema());
        set.add(new SystemSchema());
        set.add(new CollectiveSchema());
        this.setBootstrapSchemas(set);
    }

    private void setDefaultInterceptorConfigurations() {
        ArrayList<MutableInterceptorConfiguration> list = new ArrayList<MutableInterceptorConfiguration>();
        MutableInterceptorConfiguration interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("normalizationService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new NormalizationService());
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("authenticationService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new AuthenticationService());
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("referralService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new ReferralService());
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("authorizationService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new AuthorizationService());
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("defaultAuthorizationService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new DefaultAuthorizationService());
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("exceptionService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new ExceptionService());
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("schemaService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new SchemaService());
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("subentryService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new SubentryService());
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("operationalAttributeService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new OperationalAttributeService());
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("collectiveAttributeService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new CollectiveAttributeService());
        list.add(interceptorCfg);
        interceptorCfg = new MutableInterceptorConfiguration();
        ((InterceptorConfiguration)interceptorCfg).setName("eventService");
        ((InterceptorConfiguration)interceptorCfg).setInterceptor(new EventService());
        list.add(interceptorCfg);
        this.setInterceptorConfigurations(list);
    }

    public Set getAuthenticatorConfigurations() {
        return ConfigurationUtil.getClonedSet(this.authenticatorConfigurations);
    }

    protected void setAuthenticatorConfigurations(Set authenticatorConfigurations) {
        Set newSet = ConfigurationUtil.getTypeSafeSet(authenticatorConfigurations, AuthenticatorConfiguration.class);
        HashSet<String> names = new HashSet<String>();
        Iterator i = newSet.iterator();
        while (i.hasNext()) {
            AuthenticatorConfiguration cfg = (AuthenticatorConfiguration)i.next();
            cfg.validate();
            String name = cfg.getName();
            if (names.contains(name)) {
                throw new ConfigurationException("Duplicate authenticator name: " + name);
            }
            names.add(name);
        }
        this.authenticatorConfigurations = newSet;
    }

    public Set getBootstrapSchemas() {
        return ConfigurationUtil.getClonedSet(this.bootstrapSchemas);
    }

    protected void setBootstrapSchemas(Set bootstrapSchemas) {
        this.bootstrapSchemas = ConfigurationUtil.getTypeSafeSet(bootstrapSchemas, BootstrapSchema.class);
    }

    public Set getContextPartitionConfigurations() {
        return ConfigurationUtil.getClonedSet(this.contextPartitionConfigurations);
    }

    protected void setContextPartitionConfigurations(Set contextParitionConfigurations) {
        Set newSet = ConfigurationUtil.getTypeSafeSet(contextParitionConfigurations, PartitionConfiguration.class);
        HashSet<String> names = new HashSet<String>();
        Iterator i = newSet.iterator();
        while (i.hasNext()) {
            PartitionConfiguration cfg = (PartitionConfiguration)i.next();
            cfg.validate();
            String name = cfg.getName();
            if (names.contains(name)) {
                throw new ConfigurationException("Duplicate partition name: " + name);
            }
            names.add(name);
        }
        this.contextPartitionConfigurations = newSet;
    }

    public boolean isAccessControlEnabled() {
        return this.accessControlEnabled;
    }

    protected void setAccessControlEnabled(boolean accessControlEnabled) {
        this.accessControlEnabled = accessControlEnabled;
    }

    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    protected void setAllowAnonymousAccess(boolean enableAnonymousAccess) {
        this.allowAnonymousAccess = enableAnonymousAccess;
    }

    public List getInterceptorConfigurations() {
        return ConfigurationUtil.getClonedList(this.interceptorConfigurations);
    }

    protected void setInterceptorConfigurations(List interceptorConfigurations) {
        List newList = ConfigurationUtil.getTypeSafeList(interceptorConfigurations, InterceptorConfiguration.class);
        HashSet<String> names = new HashSet<String>();
        Iterator i = newList.iterator();
        while (i.hasNext()) {
            InterceptorConfiguration cfg = (InterceptorConfiguration)i.next();
            cfg.validate();
            String name = cfg.getName();
            if (names.contains(name)) {
                throw new ConfigurationException("Duplicate interceptor name: " + name);
            }
            names.add(name);
        }
        this.interceptorConfigurations = interceptorConfigurations;
    }

    public List getTestEntries() {
        try {
            return ConfigurationUtil.getClonedAttributesList(this.testEntries);
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    protected void setTestEntries(List testEntries) {
        try {
            this.testEntries = testEntries = ConfigurationUtil.getClonedAttributesList(ConfigurationUtil.getTypeSafeList(testEntries, Entry.class));
        }
        catch (CloneNotSupportedException cnse) {
            this.testEntries = null;
        }
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void validate() {
        this.setWorkingDirectory(this.workingDirectory);
    }

    protected void setShutdownHookEnabled(boolean shutdownHookEnabled) {
        this.shutdownHookEnabled = shutdownHookEnabled;
    }

    public boolean isShutdownHookEnabled() {
        return this.shutdownHookEnabled;
    }

    protected void setExitVmOnShutdown(boolean exitVmOnShutdown) {
        this.exitVmOnShutdown = exitVmOnShutdown;
    }

    public boolean isExitVmOnShutdown() {
        return this.exitVmOnShutdown;
    }

    protected void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        if (maxThreads < 1) {
            throw new IllegalArgumentException("Number of max threads should be greater than 0");
        }
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    protected void setMaxSizeLimit(int maxSizeLimit) {
        this.maxSizeLimit = maxSizeLimit;
    }

    public int getMaxSizeLimit() {
        return this.maxSizeLimit;
    }

    protected void setMaxTimeLimit(int maxTimeLimit) {
        this.maxTimeLimit = maxTimeLimit;
    }

    public int getMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    protected void setSystemPartitionConfiguration(PartitionConfiguration systemPartitionConfiguration) {
        this.systemPartitionConfiguration = systemPartitionConfiguration;
    }

    public PartitionConfiguration getSystemPartitionConfiguration() {
        return this.systemPartitionConfiguration;
    }

    public boolean isDenormalizeOpAttrsEnabled() {
        return this.denormalizeOpAttrsEnabled;
    }

    protected void setDenormalizeOpAttrsEnabled(boolean denormalizeOpAttrsEnabled) {
        this.denormalizeOpAttrsEnabled = denormalizeOpAttrsEnabled;
    }
}

