/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import java.util.Comparator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.ServerUtils;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.ScopeEvaluator;
import org.apache.directory.server.core.event.SubstringEvaluator;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class LeafEvaluator
implements Evaluator {
    private static final int EQUALITY_MATCH = 0;
    private static final int ORDERING_MATCH = 1;
    private static final int SUBSTRING_MATCH = 3;
    private OidRegistry oidRegistry;
    private AttributeTypeRegistry attributeTypeRegistry;
    private SubstringEvaluator substringEvaluator;
    private ScopeEvaluator scopeEvaluator;

    public LeafEvaluator(OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry, SubstringEvaluator substringEvaluator) throws NamingException {
        this.oidRegistry = oidRegistry;
        this.attributeTypeRegistry = attributeTypeRegistry;
        this.scopeEvaluator = new ScopeEvaluator();
        this.substringEvaluator = substringEvaluator;
    }

    public ScopeEvaluator getScopeEvaluator() {
        return this.scopeEvaluator;
    }

    public SubstringEvaluator getSubstringEvaluator() {
        return this.substringEvaluator;
    }

    public boolean evaluate(ExprNode node, String dn, Attributes entry) throws NamingException {
        if (node instanceof ScopeNode) {
            return this.scopeEvaluator.evaluate(node, dn, entry);
        }
        switch (((LeafNode)node).getAssertionType()) {
            case 5: {
                return this.evalEquality((SimpleNode)node, entry);
            }
            case 0: {
                return this.evalEquality((SimpleNode)node, entry);
            }
            case 6: {
                throw new NotImplementedException();
            }
            case 3: {
                return this.evalGreater((SimpleNode)node, entry, true);
            }
            case 4: {
                return this.evalGreater((SimpleNode)node, entry, false);
            }
            case 1: {
                String attrId = ((PresenceNode)node).getAttribute();
                return this.evalPresence(attrId, entry);
            }
            case 2: {
                return this.substringEvaluator.evaluate(node, dn, entry);
            }
        }
        throw new NamingException("Unrecognized leaf node type: " + ((LeafNode)node).getAssertionType());
    }

    private boolean evalGreater(SimpleNode node, Attributes entry, boolean isGreater) throws NamingException {
        String attrId = node.getAttribute();
        AttributeType type = this.attributeTypeRegistry.lookup(this.oidRegistry.getOid(attrId));
        Attribute attr = ServerUtils.getAttribute(type, entry);
        if (null == attr) {
            return false;
        }
        Normalizer normalizer = this.getNormalizer(attrId);
        Comparator comparator = this.getComparator(attrId);
        Object filterValue = normalizer.normalize(node.getValue());
        NamingEnumeration<?> list = attr.getAll();
        if (isGreater) {
            while (list.hasMore()) {
                Object value = normalizer.normalize(list.next());
                if (0 < comparator.compare(value, filterValue)) continue;
                return true;
            }
        } else {
            while (list.hasMore()) {
                Object value = normalizer.normalize(list.next());
                if (0 > comparator.compare(value, filterValue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evalPresence(String attrId, Attributes entry) throws NamingException {
        if (entry == null) {
            return false;
        }
        AttributeType type = this.attributeTypeRegistry.lookup(this.oidRegistry.getOid(attrId));
        return null != ServerUtils.getAttribute(type, entry);
    }

    private boolean evalEquality(SimpleNode node, Attributes entry) throws NamingException {
        Normalizer normalizer = this.getNormalizer(node.getAttribute());
        Comparator comparator = this.getComparator(node.getAttribute());
        AttributeType type = this.attributeTypeRegistry.lookup(this.oidRegistry.getOid(node.getAttribute()));
        Attribute attr = ServerUtils.getAttribute(type, entry);
        if (null == attr) {
            return false;
        }
        if (attr.contains(node.getValue())) {
            return true;
        }
        Object filterValue = normalizer.normalize(node.getValue());
        if (attr.contains(filterValue)) {
            return true;
        }
        NamingEnumeration<?> list = attr.getAll();
        while (list.hasMore()) {
            Object value = normalizer.normalize(list.next());
            if (0 != comparator.compare(value, filterValue)) continue;
            return true;
        }
        return false;
    }

    private Comparator getComparator(String attrId) throws NamingException {
        MatchingRule mrule = this.getMatchingRule(attrId, 0);
        return mrule.getComparator();
    }

    private Normalizer getNormalizer(String attrId) throws NamingException {
        MatchingRule mrule = this.getMatchingRule(attrId, 0);
        return mrule.getNormalizer();
    }

    private MatchingRule getMatchingRule(String attrId, int matchType) throws NamingException {
        MatchingRule mrule = null;
        String oid = this.oidRegistry.getOid(attrId);
        AttributeType type = this.attributeTypeRegistry.lookup(oid);
        switch (matchType) {
            case 0: {
                mrule = type.getEquality();
                break;
            }
            case 3: {
                mrule = type.getSubstr();
                break;
            }
            case 1: {
                mrule = type.getOrdering();
                break;
            }
            default: {
                throw new NamingException("Unknown match type: " + matchType);
            }
        }
        return mrule;
    }
}

