/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class LdapJndiProperties {
    private static final String SASL_AUTHID = "java.naming.security.sasl.authorizationId";
    private LdapDN providerDn;
    private LdapDN bindDn;
    private String saslAuthId;
    private AuthenticationLevel level;
    private List mechanisms = new ArrayList();
    private byte[] credentials;

    public static AuthenticationLevel getAuthenticationLevel(Hashtable env) throws NamingException {
        AuthenticationLevel level;
        Object credobj = env.get("java.naming.security.credentials");
        Object authentication = env.get("java.naming.security.authentication");
        if (authentication == null) {
            level = credobj == null ? AuthenticationLevel.NONE : AuthenticationLevel.SIMPLE;
        } else {
            if (!(authentication instanceof String)) {
                throw new LdapConfigurationException("Don't know how to interpret " + authentication.getClass() + " objects for environment property " + "java.naming.security.authentication");
            }
            level = "none".equals(authentication) ? AuthenticationLevel.NONE : ("simple".equals(authentication) ? AuthenticationLevel.SIMPLE : AuthenticationLevel.STRONG);
        }
        return level;
    }

    public static LdapJndiProperties getLdapJndiProperties(Hashtable env) throws NamingException {
        if (env == null) {
            throw new LdapConfigurationException("environment cannot be null");
        }
        LdapJndiProperties props = new LdapJndiProperties();
        Object principal = env.get("java.naming.security.principal");
        Object credobj = env.get("java.naming.security.credentials");
        Object authentication = env.get("java.naming.security.authentication");
        if (!env.containsKey("java.naming.provider.url")) {
            String msg = "Expected property java.naming.provider.url";
            msg = msg + " but could not find it in env!";
            throw new LdapConfigurationException(msg);
        }
        String url = (String)env.get("java.naming.provider.url");
        if (url == null) {
            String msg = "Expected value for property java.naming.provider.url";
            msg = msg + " but it was set to null in env!";
            throw new LdapConfigurationException(msg);
        }
        props.providerDn = url.trim().equals("") ? LdapDN.EMPTY_LDAPDN : new LdapDN(url);
        if (authentication == null) {
            if (credobj == null) {
                props.level = AuthenticationLevel.NONE;
                props.mechanisms.add("none");
            } else {
                props.level = AuthenticationLevel.SIMPLE;
                props.mechanisms.add("simple");
            }
        } else {
            if (!(authentication instanceof String)) {
                throw new LdapConfigurationException("Don't know how to interpret " + authentication.getClass() + " objects for environment property " + "java.naming.security.authentication");
            }
            if ("none".equals(authentication)) {
                props.level = AuthenticationLevel.NONE;
                props.mechanisms.add("none");
            } else if ("simple".equals(authentication)) {
                props.level = AuthenticationLevel.SIMPLE;
                props.mechanisms.add("simple");
            } else {
                props.level = AuthenticationLevel.STRONG;
                String[] mechList = ((String)authentication).trim().split(" ");
                for (int ii = 0; ii < mechList.length; ++ii) {
                    if (mechList[ii].trim().equals("")) continue;
                    props.mechanisms.add(mechList[ii]);
                }
            }
        }
        if (env.containsKey("parsed.bind.dn")) {
            props.bindDn = (LdapDN)env.get("parsed.bind.dn");
        } else {
            if (principal == null) {
                throw new LdapConfigurationException("java.naming.security.principal cannot be null.");
            }
            if (!(principal instanceof String)) {
                throw new LdapConfigurationException("Don't know how to interpret " + principal.getClass() + " objects for environment property " + "java.naming.security.principal");
            }
            props.bindDn = ((String)principal).trim().equals("") ? LdapDN.EMPTY_LDAPDN : new LdapDN((String)principal);
        }
        if (env.get(SASL_AUTHID) != null && props.level == AuthenticationLevel.STRONG) {
            Object obj = env.get(SASL_AUTHID);
            if (!(obj instanceof String)) {
                throw new LdapConfigurationException("Don't know how to interpret " + obj.getClass() + " objects for environment property " + SASL_AUTHID);
            }
            props.saslAuthId = (String)obj;
            props.saslAuthId = (String)principal;
        }
        if (props.level == AuthenticationLevel.SIMPLE && credobj == null) {
            throw new LdapConfigurationException("cannot specify simple authentication with supplying credentials");
        }
        if (credobj != null) {
            if (credobj instanceof String) {
                props.credentials = StringTools.getBytesUtf8((String)((String)credobj));
            } else if (credobj instanceof byte[]) {
                props.credentials = (byte[])credobj;
            } else {
                throw new LdapConfigurationException("Don't know how to interpret " + credobj.getClass() + " objects for environment property " + "java.naming.security.credentials");
            }
        }
        return props;
    }

    public LdapDN getBindDn() {
        return this.bindDn;
    }

    public LdapDN getProviderDn() {
        return this.providerDn;
    }

    public String getSaslAuthId() {
        return this.saslAuthId;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.level;
    }

    public List getAuthenticationMechanisms() {
        return Collections.unmodifiableList(this.mechanisms);
    }

    public byte[] getCredentials() {
        return this.credentials;
    }
}

