/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;

public class ExpandingVisitor
implements FilterVisitor {
    private final AttributeTypeRegistry attrRegistry;

    public ExpandingVisitor(AttributeTypeRegistry attrRegistry) {
        this.attrRegistry = attrRegistry;
    }

    public boolean canVisit(ExprNode node) {
        return node instanceof BranchNode;
    }

    public ArrayList getOrder(BranchNode node, ArrayList children) {
        return children;
    }

    public boolean isPrefix() {
        return false;
    }

    public void visit(ExprNode node) {
        BranchNode bnode = (BranchNode)node;
        ArrayList children = bnode.getChildren();
        int limit = children.size();
        for (int ii = 0; ii < limit; ++ii) {
            ExprNode child = (ExprNode)children.get(ii);
            if (child instanceof LeafNode) {
                LeafNode leaf = (LeafNode)child;
                try {
                    if (!this.attrRegistry.hasDescendants(leaf.getAttribute())) continue;
                    BranchNode orNode = new BranchNode(9);
                    orNode.getChildren().add(leaf);
                    children.set(ii, orNode);
                    Iterator descendants = this.attrRegistry.descendants(leaf.getAttribute());
                    while (descendants.hasNext()) {
                        PresenceNode newLeaf = null;
                        AttributeType descendant = (AttributeType)descendants.next();
                        switch (leaf.getAssertionType()) {
                            case 6: {
                                ExtensibleNode extensibleNode = (ExtensibleNode)leaf;
                                newLeaf = new ExtensibleNode(descendant.getOid(), extensibleNode.getValue(), extensibleNode.getMatchingRuleId(), extensibleNode.dnAttributes());
                                break;
                            }
                            case 1: {
                                newLeaf = new PresenceNode(descendant.getOid());
                                break;
                            }
                            case 2: {
                                SubstringNode substringNode = (SubstringNode)leaf;
                                newLeaf = new SubstringNode(descendant.getOid(), substringNode.getInitial(), substringNode.getFinal());
                                break;
                            }
                            case 0: 
                            case 3: 
                            case 4: 
                            case 5: {
                                SimpleNode simpleNode = (SimpleNode)leaf;
                                if (simpleNode.getValue() instanceof String) {
                                    newLeaf = new SimpleNode(descendant.getOid(), (String)simpleNode.getValue(), simpleNode.getAssertionType());
                                    break;
                                }
                                if (simpleNode.getValue() instanceof byte[]) {
                                    newLeaf = new SimpleNode(descendant.getOid(), (byte[])simpleNode.getValue(), simpleNode.getAssertionType());
                                    break;
                                }
                                newLeaf = new SimpleNode(descendant.getOid(), simpleNode.getValue().toString(), simpleNode.getAssertionType());
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown assertion type: " + leaf.getAssertionType());
                            }
                        }
                        orNode.addNode((ExprNode)newLeaf);
                    }
                    continue;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Failed to expand node");
                }
            }
            this.visit(child);
        }
    }
}

