/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.math.BigInteger;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.Optimizer;
import org.apache.directory.shared.ldap.filter.AssertionNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;

public class DefaultOptimizer
implements Optimizer {
    private static final BigInteger MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private BTreePartition db;

    public DefaultOptimizer(BTreePartition db) {
        this.db = db;
    }

    public void annotate(ExprNode node) throws NamingException {
        BigInteger count = MAX;
        if (node instanceof ScopeNode) {
            count = this.getScopeScan((ScopeNode)node);
        } else if (!(node instanceof AssertionNode)) {
            if (node.isLeaf()) {
                LeafNode leaf = (LeafNode)node;
                switch (leaf.getAssertionType()) {
                    case 5: {
                        count = this.getEqualityScan((SimpleNode)leaf);
                        break;
                    }
                    case 0: {
                        count = this.getEqualityScan((SimpleNode)leaf);
                        break;
                    }
                    case 6: {
                        count = this.getFullScan(leaf);
                        break;
                    }
                    case 3: {
                        count = this.getGreaterLessScan((SimpleNode)leaf, true);
                        break;
                    }
                    case 4: {
                        count = this.getGreaterLessScan((SimpleNode)leaf, false);
                        break;
                    }
                    case 1: {
                        count = this.getPresenceScan((PresenceNode)leaf);
                        break;
                    }
                    case 2: {
                        count = this.getFullScan(leaf);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized leaf node");
                    }
                }
            } else {
                BranchNode bnode = (BranchNode)node;
                switch (bnode.getOperator()) {
                    case 10: {
                        count = this.getConjunctionScan(bnode);
                        break;
                    }
                    case 11: {
                        count = this.getNegationScan(bnode);
                        break;
                    }
                    case 9: {
                        count = this.getDisjunctionScan(bnode);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized branch node type");
                    }
                }
            }
        }
        if (count.compareTo(BigInteger.ZERO) < 0) {
            count = MAX;
        }
        node.set((Object)"count", (Object)count);
    }

    private BigInteger getConjunctionScan(BranchNode node) throws NamingException {
        BigInteger count = MAX;
        ArrayList children = node.getChildren();
        for (int ii = 0; ii < children.size(); ++ii) {
            ExprNode child = (ExprNode)children.get(ii);
            this.annotate(child);
            count = ((BigInteger)child.get((Object)"count")).min(count);
        }
        return count;
    }

    private BigInteger getNegationScan(BranchNode node) throws NamingException {
        ExprNode onlyChild = (ExprNode)node.getChildren().get(0);
        this.annotate(onlyChild);
        if (onlyChild.isLeaf() && !(onlyChild instanceof ScopeNode) && !(onlyChild instanceof AssertionNode) && !(onlyChild instanceof PresenceNode)) {
            LeafNode leaf = (LeafNode)onlyChild;
            if (this.db.hasUserIndexOn(leaf.getAttribute())) {
                Index idx = this.db.getUserIndex(leaf.getAttribute());
                return BigInteger.valueOf(idx.count());
            }
            return BigInteger.valueOf(this.db.count());
        }
        return BigInteger.valueOf(this.db.count());
    }

    private BigInteger getDisjunctionScan(BranchNode node) throws NamingException {
        ArrayList children = node.getChildren();
        BigInteger total = BigInteger.ZERO;
        for (int ii = 0; ii < children.size(); ++ii) {
            ExprNode child = (ExprNode)children.get(ii);
            this.annotate(child);
            total = total.add((BigInteger)child.get((Object)"count"));
        }
        if (total.compareTo(MAX) > 0) {
            total = MAX;
        }
        return total;
    }

    private BigInteger getEqualityScan(SimpleNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            return BigInteger.valueOf(idx.count(node.getValue()));
        }
        return MAX;
    }

    private BigInteger getGreaterLessScan(SimpleNode node, boolean isGreaterThan) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            int count = idx.count(node.getValue(), isGreaterThan);
            return BigInteger.valueOf(count);
        }
        return MAX;
    }

    private BigInteger getFullScan(LeafNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            int count = idx.count();
            return BigInteger.valueOf(count);
        }
        return MAX;
    }

    private BigInteger getPresenceScan(PresenceNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getExistanceIndex();
            int count = idx.count(node.getAttribute());
            return BigInteger.valueOf(count);
        }
        return MAX;
    }

    private BigInteger getScopeScan(ScopeNode node) throws NamingException {
        switch (node.getScope()) {
            case 0: {
                return BigInteger.ONE;
            }
            case 1: {
                BigInteger id = this.db.getEntryId(node.getBaseDn());
                return BigInteger.valueOf(this.db.getChildCount(id));
            }
            case 2: {
                return BigInteger.valueOf(this.db.count());
            }
        }
        throw new IllegalArgumentException("Unrecognized search scope value for filter scope node");
    }
}

