/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.math.BigInteger;
import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.DisjunctionEnumeration;
import org.apache.directory.server.core.partition.impl.btree.Enumerator;
import org.apache.directory.server.core.partition.impl.btree.ExpressionEvaluator;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertion;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertionEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.LeafEvaluator;
import org.apache.directory.server.core.partition.impl.btree.ScopeEnumerator;
import org.apache.directory.server.core.partition.impl.btree.SubstringEnumerator;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.filter.AssertionNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;

public class ExpressionEnumerator
implements Enumerator {
    private BTreePartition db = null;
    private ScopeEnumerator scopeEnumerator;
    private SubstringEnumerator substringEnumerator;
    private ExpressionEvaluator evaluator;

    public ExpressionEnumerator(BTreePartition db, AttributeTypeRegistry attributeTypeRegistry, ExpressionEvaluator evaluator) {
        this.db = db;
        this.evaluator = evaluator;
        LeafEvaluator leafEvaluator = evaluator.getLeafEvaluator();
        this.scopeEnumerator = new ScopeEnumerator(db, leafEvaluator.getScopeEvaluator());
        this.substringEnumerator = new SubstringEnumerator(db, attributeTypeRegistry, leafEvaluator.getSubstringEvaluator());
    }

    public NamingEnumeration enumerate(ExprNode node) throws NamingException {
        NamingEnumeration list = null;
        if (node instanceof ScopeNode) {
            list = this.scopeEnumerator.enumerate(node);
        } else {
            if (node instanceof AssertionNode) {
                throw new IllegalArgumentException("Cannot produce enumeration on an AssertionNode");
            }
            if (node.isLeaf()) {
                LeafNode leaf = (LeafNode)node;
                switch (leaf.getAssertionType()) {
                    case 5: {
                        list = this.enumEquality((SimpleNode)node);
                        break;
                    }
                    case 0: {
                        list = this.enumEquality((SimpleNode)node);
                        break;
                    }
                    case 6: {
                        throw new NotImplementedException();
                    }
                    case 3: {
                        list = this.enumGreater((SimpleNode)node, true);
                        break;
                    }
                    case 4: {
                        list = this.enumGreater((SimpleNode)node, false);
                        break;
                    }
                    case 1: {
                        list = this.enumPresence((PresenceNode)node);
                        break;
                    }
                    case 2: {
                        list = this.substringEnumerator.enumerate((ExprNode)leaf);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown leaf assertion");
                    }
                }
            } else {
                BranchNode branch = (BranchNode)node;
                switch (branch.getOperator()) {
                    case 10: {
                        list = this.enumConj(branch);
                        break;
                    }
                    case 11: {
                        list = this.enumNeg(branch);
                        break;
                    }
                    case 9: {
                        list = this.enumDisj(branch);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown branch logical operator");
                    }
                }
            }
        }
        return list;
    }

    private NamingEnumeration enumDisj(BranchNode node) throws NamingException {
        ArrayList children = node.getChildren();
        NamingEnumeration[] childEnumerations = new NamingEnumeration[children.size()];
        for (int ii = 0; ii < childEnumerations.length; ++ii) {
            childEnumerations[ii] = this.enumerate((ExprNode)children.get(ii));
        }
        return new DisjunctionEnumeration(childEnumerations);
    }

    private NamingEnumeration enumNeg(final BranchNode node) throws NamingException {
        Index idx = null;
        IndexEnumeration childEnumeration = null;
        IndexAssertionEnumeration enumeration = null;
        if (node.getChild().isLeaf()) {
            LeafNode child = (LeafNode)node.getChild();
            if (this.db.hasUserIndexOn(child.getAttribute())) {
                idx = this.db.getUserIndex(child.getAttribute());
                childEnumeration = idx.listIndices();
            } else {
                childEnumeration = this.db.getNdnIndex().listIndices();
            }
        } else {
            idx = this.db.getNdnIndex();
            childEnumeration = idx.listIndices();
        }
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                return !ExpressionEnumerator.this.evaluator.evaluate(node.getChild(), rec);
            }
        };
        enumeration = new IndexAssertionEnumeration(childEnumeration, assertion, true);
        return enumeration;
    }

    private NamingEnumeration enumConj(BranchNode node) throws NamingException {
        int minIndex = 0;
        int minValue = Integer.MAX_VALUE;
        int value = Integer.MAX_VALUE;
        final ArrayList children = node.getChildren();
        for (int ii = 0; ii < children.size(); ++ii) {
            ExprNode child = (ExprNode)children.get(ii);
            value = ((BigInteger)child.get((Object)"count")).intValue();
            if ((minValue = Math.min(minValue, value)) != value) continue;
            minIndex = ii;
        }
        final ExprNode minChild = (ExprNode)children.get(minIndex);
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                for (int ii = 0; ii < children.size(); ++ii) {
                    ExprNode child = (ExprNode)children.get(ii);
                    if (child == minChild || ExpressionEnumerator.this.evaluator.evaluate(child, rec)) continue;
                    return false;
                }
                return true;
            }
        };
        NamingEnumeration underlying = this.enumerate(minChild);
        IndexAssertionEnumeration iae = new IndexAssertionEnumeration(underlying, assertion);
        return iae;
    }

    private NamingEnumeration enumPresence(PresenceNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getExistanceIndex();
            return idx.listIndices(node.getAttribute());
        }
        return this.nonIndexedScan((LeafNode)node);
    }

    private NamingEnumeration enumGreater(SimpleNode node, boolean isGreater) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            if (isGreater) {
                return idx.listIndices(node.getValue(), true);
            }
            return idx.listIndices(node.getValue(), false);
        }
        return this.nonIndexedScan((LeafNode)node);
    }

    private NamingEnumeration enumEquality(SimpleNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            return idx.listIndices(node.getValue());
        }
        return this.nonIndexedScan((LeafNode)node);
    }

    private NamingEnumeration nonIndexedScan(final LeafNode node) throws NamingException {
        IndexEnumeration underlying = this.db.getNdnIndex().listIndices();
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord record) throws NamingException {
                return ExpressionEnumerator.this.evaluator.getLeafEvaluator().evaluate((ExprNode)node, record);
            }
        };
        return new IndexAssertionEnumeration(underlying, assertion);
    }
}

