/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import jdbm.btree.BTree;
import org.apache.directory.server.core.partition.impl.btree.NoDupsEnumeration;
import org.apache.directory.server.core.partition.impl.btree.Tuple;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeIterator;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirect;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;

public class DupsEnumeration
implements NamingEnumeration {
    private boolean hasMore = true;
    private final Tuple returned = new Tuple();
    private final Tuple prefetched = new Tuple();
    private final NoDupsEnumeration underlying;
    private Tuple duplicates;
    private Iterator dupIterator;
    private JdbmTable table;

    public DupsEnumeration(JdbmTable table, NoDupsEnumeration list) throws NamingException {
        this.table = table;
        this.underlying = list;
        if (!this.underlying.hasMore()) {
            this.close();
            return;
        }
        this.prefetch();
    }

    public Object next() throws NamingException {
        this.returned.setKey(this.prefetched.getKey());
        this.returned.setValue(this.prefetched.getValue());
        this.prefetch();
        return this.returned;
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException ne) {
            throw new NoSuchElementException();
        }
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    public void close() {
        this.hasMore = false;
        this.underlying.close();
    }

    private void prefetch() throws NamingException {
        while (null == this.dupIterator || !this.dupIterator.hasNext()) {
            if (this.underlying.hasMore()) {
                this.duplicates = (Tuple)this.underlying.next();
                Object values = this.duplicates.getValue();
                if (values instanceof TreeSet) {
                    TreeSet set = (TreeSet)this.duplicates.getValue();
                    if (this.underlying.doAscendingScan()) {
                        this.dupIterator = set.iterator();
                        continue;
                    }
                    ArrayList list = new ArrayList(set.size());
                    list.addAll(set);
                    Collections.reverse(list);
                    this.dupIterator = list.iterator();
                    continue;
                }
                if (!(values instanceof BTreeRedirect)) continue;
                BTree tree = this.table.getBTree((BTreeRedirect)values);
                this.dupIterator = new BTreeIterator(tree, this.underlying.doAscendingScan());
                continue;
            }
            this.close();
            return;
        }
        this.prefetched.setKey(this.duplicates.getKey());
        this.prefetched.setValue(this.dupIterator.next());
    }
}

