/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.math.BigInteger;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import jdbm.RecordManager;
import jdbm.helper.StringComparator;
import org.apache.directory.server.core.partition.impl.btree.MasterTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.core.schema.SerializableComparator;
import org.apache.directory.shared.ldap.util.BigIntegerComparator;

public class JdbmMasterTable
extends JdbmTable
implements MasterTable {
    private static final StringComparator STRCOMP = new StringComparator();
    private static final SerializableComparator BIG_INTEGER_COMPARATOR = new SerializableComparator("1.3.6.1.4.1.18060.0.4.1.1.2"){
        private static final long serialVersionUID = 4048791282048841016L;

        public int compare(Object o1, Object o2) {
            return BigIntegerComparator.INSTANCE.compare(o1, o2);
        }
    };
    private static final SerializableComparator STRING_COMPARATOR = new SerializableComparator("1.3.6.1.4.1.18060.0.4.1.1.3"){
        private static final long serialVersionUID = 3258689922792961845L;

        public int compare(Object o1, Object o2) {
            return STRCOMP.compare(o1, o2);
        }
    };
    private JdbmTable adminTbl = null;

    public JdbmMasterTable(RecordManager recMan) throws NamingException {
        super("master", recMan, BIG_INTEGER_COMPARATOR);
        this.adminTbl = new JdbmTable("admin", recMan, STRING_COMPARATOR);
        String seqValue = (String)this.adminTbl.get("__sequence__");
        if (null == seqValue) {
            this.adminTbl.put((Object)"__sequence__", BigInteger.ZERO.toString());
        }
    }

    public Attributes get(BigInteger id) throws NamingException {
        return (Attributes)super.get(id);
    }

    public Attributes put(Attributes entry, BigInteger id) throws NamingException {
        return (Attributes)super.put((Object)id, entry);
    }

    public Attributes delete(BigInteger id) throws NamingException {
        return (Attributes)super.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getCurrentId() throws NamingException {
        BigInteger id = null;
        JdbmTable jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            id = new BigInteger((String)this.adminTbl.get("__sequence__"));
            if (null == id) {
                this.adminTbl.put((Object)"__sequence__", BigInteger.ZERO.toString());
                id = BigInteger.ZERO;
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getNextId() throws NamingException {
        BigInteger lastVal = null;
        BigInteger nextVal = null;
        JdbmTable jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            lastVal = new BigInteger((String)this.adminTbl.get("__sequence__"));
            if (null == lastVal) {
                this.adminTbl.put((Object)"__sequence__", BigInteger.ONE.toString());
                return BigInteger.ONE;
            }
            nextVal = lastVal.add(BigInteger.ONE);
            this.adminTbl.put((Object)"__sequence__", nextVal.toString());
        }
        return nextVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String property) throws NamingException {
        JdbmTable jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            return (String)this.adminTbl.get(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String property, String value) throws NamingException {
        JdbmTable jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            this.adminTbl.put((Object)property, value);
        }
    }
}

