/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.referral;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.ServerUtils;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.enumeration.ReferralHandlingEnumeration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.core.referral.ReferralLut;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapReferralException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferralService
extends BaseInterceptor {
    private static Logger log = LoggerFactory.getLogger((Class)ReferralService.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    public static final String NAME = "referralService";
    private static final String IGNORE = "ignore";
    private static final String THROW_FINDING_BASE = "throw-finding-base";
    private static final String THROW = "throw";
    private static final String FOLLOW = "follow";
    private static final String REFERRAL_OC = "referral";
    private static final String OBJCLASS_ATTR = "objectClass";
    private static final Collection SEARCH_BYPASS;
    private static final String REF_ATTR = "ref";
    private ReferralLut lut = new ReferralLut();
    private PartitionNexus nexus;
    private Hashtable env;
    private AttributeTypeRegistry attrRegistry;
    private OidRegistry oidRegistry;
    private static AttributeType REFS_TYPE;

    static boolean hasValue(Attribute attr, String value) throws NamingException {
        if (attr == null) {
            return false;
        }
        for (int ii = 0; ii < attr.size(); ++ii) {
            if (!(attr.get(ii) instanceof String) || !value.equalsIgnoreCase((String)attr.get(ii))) continue;
            return true;
        }
        return false;
    }

    static boolean isReferral(Attributes entry) throws NamingException {
        Attribute oc = entry.get(OBJCLASS_ATTR);
        if (oc == null) {
            log.warn("could not find objectClass attribute in entry: " + entry);
            return false;
        }
        for (int ii = 0; ii < oc.size(); ++ii) {
            if (!REFERRAL_OC.equalsIgnoreCase((String)oc.get(ii))) continue;
            return true;
        }
        return false;
    }

    public void init(DirectoryServiceConfiguration dsConfig, InterceptorConfiguration cfg) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Initializing ReferralService...");
        }
        this.nexus = dsConfig.getPartitionNexus();
        this.attrRegistry = dsConfig.getGlobalRegistries().getAttributeTypeRegistry();
        this.oidRegistry = dsConfig.getGlobalRegistries().getOidRegistry();
        this.env = dsConfig.getEnvironment();
        REFS_TYPE = this.attrRegistry.lookup(this.oidRegistry.getOid(REF_ATTR));
        Iterator suffixes = this.nexus.listSuffixes();
        while (suffixes.hasNext()) {
            LdapDN suffix = new LdapDN((String)suffixes.next());
            this.addReferrals(this.nexus.search(suffix, this.env, ReferralService.getReferralFilter(), ReferralService.getControls()), suffix);
        }
        if (IS_DEBUG) {
            log.debug("ReferralService Initialized !");
        }
    }

    private void doReferralException(LdapDN farthest, LdapDN targetUpdn, Attribute refs) throws NamingException {
        ArrayList<String> list = new ArrayList<String>(refs.size());
        for (int ii = 0; ii < refs.size(); ++ii) {
            String url = (String)refs.get(ii);
            if (!url.startsWith("ldap")) {
                list.add(url);
                continue;
            }
            LdapURL ldapUrl = null;
            try {
                ldapUrl = new LdapURL(url);
            }
            catch (LdapURLEncodingException e) {
                log.error("Bad URL (" + url + ") for ref in " + farthest + ".  Reference will be ignored.");
                list.add(url);
                continue;
            }
            LdapDN urlDn = ldapUrl.getDn();
            urlDn.normalize(this.attrRegistry.getNormalizerMapping());
            if (urlDn.equals((Object)farthest)) {
                StringBuffer buf = new StringBuffer();
                buf.append(ldapUrl.getScheme());
                buf.append(ldapUrl.getHost());
                if (ldapUrl.getPort() > 0) {
                    buf.append(":");
                    buf.append(ldapUrl.getPort());
                }
                list.add(buf.toString());
                continue;
            }
            int diff = targetUpdn.size() - farthest.size();
            LdapDN extra = new LdapDN();
            for (int jj = 0; jj < diff; ++jj) {
                Rdn rdn = targetUpdn.getRdn(farthest.size() + jj);
                extra.add(rdn);
            }
            urlDn.addAll((Name)extra);
            StringBuffer buf = new StringBuffer();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(LdapURL.urlEncode((String)urlDn.getUpName(), (boolean)false));
            list.add(buf.toString());
        }
        LdapReferralException lre = new LdapReferralException(list);
        throw lre;
    }

    public void add(NextInterceptor next, LdapDN normName, Attributes entry) throws NamingException {
        LdapDN farthest;
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        if (refval == null || refval.equals(IGNORE)) {
            next.add(normName, entry);
            if (ReferralService.isReferral(entry)) {
                this.lut.referralAdded(normName);
            }
            return;
        }
        if (refval.equals(THROW)) {
            farthest = this.lut.getFarthestReferralAncestor(normName);
            if (farthest == null) {
                next.add(normName, entry);
                if (ReferralService.isReferral(entry)) {
                    this.lut.referralAdded(normName);
                }
                return;
            }
        } else {
            if (refval.equals(FOLLOW)) {
                throw new NotImplementedException("follow referral handling mode not implemented");
            }
            throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
        }
        Attributes referral = invocation.getProxy().lookup(farthest, PartitionNexusProxy.LOOKUP_BYPASS);
        Attribute refs = ServerUtils.getAttribute(REFS_TYPE, referral);
        this.doReferralException(farthest, (LdapDN)normName.clone(), refs);
    }

    public boolean compare(NextInterceptor next, LdapDN normName, String oid, Object value) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        if (refval == null || refval.equals(IGNORE)) {
            return next.compare(normName, oid, value);
        }
        if (refval.equals(THROW)) {
            LdapDN farthest = this.lut.getFarthestReferralAncestor(normName);
            if (farthest == null) {
                return next.compare(normName, oid, value);
            }
            Attributes referral = invocation.getProxy().lookup(farthest, PartitionNexusProxy.LOOKUP_BYPASS);
            Attribute refs = referral.get(REF_ATTR);
            this.doReferralException(farthest, new LdapDN(normName.getUpName()), refs);
            return false;
        }
        if (refval.equals(FOLLOW)) {
            throw new NotImplementedException("follow referral handling mode not implemented");
        }
        throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
    }

    public void delete(NextInterceptor next, LdapDN normName) throws NamingException {
        LdapDN farthest;
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        if (refval == null || refval.equals(IGNORE)) {
            next.delete(normName);
            if (this.lut.isReferral(normName)) {
                this.lut.referralDeleted(normName);
            }
            return;
        }
        if (refval.equals(THROW)) {
            farthest = this.lut.getFarthestReferralAncestor(normName);
            if (farthest == null) {
                next.delete(normName);
                if (this.lut.isReferral(normName)) {
                    this.lut.referralDeleted(normName);
                }
                return;
            }
        } else {
            if (refval.equals(FOLLOW)) {
                throw new NotImplementedException("follow referral handling mode not implemented");
            }
            throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
        }
        Attributes referral = invocation.getProxy().lookup(farthest, PartitionNexusProxy.LOOKUP_BYPASS);
        Attribute refs = referral.get(REF_ATTR);
        this.doReferralException(farthest, new LdapDN(normName.getUpName()), refs);
    }

    public void move(NextInterceptor next, LdapDN oldName, LdapDN newParent) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        LdapDN newName = (LdapDN)newParent.clone();
        newName.add(oldName.get(oldName.size() - 1));
        if (refval == null || refval.equals(IGNORE)) {
            next.move(oldName, newParent);
            if (this.lut.isReferral(oldName)) {
                this.lut.referralChanged(oldName, newName);
            }
            return;
        }
        if (refval.equals(THROW)) {
            LdapDN farthestSrc = this.lut.getFarthestReferralAncestor(oldName);
            LdapDN farthestDst = this.lut.getFarthestReferralAncestor(newName);
            if (farthestSrc == null && farthestDst == null && !this.lut.isReferral(newName)) {
                next.move(oldName, newParent);
                if (this.lut.isReferral(oldName)) {
                    this.lut.referralChanged(oldName, newName);
                }
                return;
            }
            if (farthestSrc != null) {
                Attributes referral = invocation.getProxy().lookup(farthestSrc, PartitionNexusProxy.LOOKUP_BYPASS);
                Attribute refs = referral.get(REF_ATTR);
                this.doReferralException(farthestSrc, new LdapDN(oldName.getUpName()), refs);
            } else {
                if (farthestDst != null) {
                    throw new LdapNamingException(farthestDst + " ancestor is a referral for modifyDn on " + newName + " so it affects multiple DSAs", ResultCodeEnum.AFFECTSMULTIPLEDSAS);
                }
                if (this.lut.isReferral(newName)) {
                    throw new LdapNamingException(newName + " exists and is a referral for modifyDn destination so it affects multiple DSAs", ResultCodeEnum.AFFECTSMULTIPLEDSAS);
                }
            }
            throw new IllegalStateException("If you get this exception the server's logic was flawed in handling a modifyDn operation while processing referrals.  Report this as a bug!");
        }
        if (refval.equals(FOLLOW)) {
            throw new NotImplementedException("follow referral handling mode not implemented");
        }
        throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
    }

    public void move(NextInterceptor next, LdapDN oldName, LdapDN newParent, String newRdn, boolean deleteOldRdn) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        LdapDN newName = (LdapDN)newParent.clone();
        newName.add(newRdn);
        if (refval == null || refval.equals(IGNORE)) {
            next.move(oldName, newParent, newRdn, deleteOldRdn);
            if (this.lut.isReferral(oldName)) {
                this.lut.referralChanged(oldName, newName);
            }
            return;
        }
        if (refval.equals(THROW)) {
            LdapDN farthestSrc = this.lut.getFarthestReferralAncestor(oldName);
            LdapDN farthestDst = this.lut.getFarthestReferralAncestor(newName);
            if (farthestSrc == null && farthestDst == null && !this.lut.isReferral(newName)) {
                next.move(oldName, newParent, newRdn, deleteOldRdn);
                if (this.lut.isReferral(oldName)) {
                    this.lut.referralChanged(oldName, newName);
                }
                return;
            }
            if (farthestSrc != null) {
                Attributes referral = invocation.getProxy().lookup(farthestSrc, PartitionNexusProxy.LOOKUP_BYPASS);
                Attribute refs = referral.get(REF_ATTR);
                this.doReferralException(farthestSrc, new LdapDN(oldName.getUpName()), refs);
            } else {
                if (farthestDst != null) {
                    throw new LdapNamingException(farthestDst + " ancestor is a referral for modifyDn on " + newName + " so it affects multiple DSAs", ResultCodeEnum.AFFECTSMULTIPLEDSAS);
                }
                if (this.lut.isReferral(newName)) {
                    throw new LdapNamingException(newName + " exists and is a referral for modifyDn destination so it affects multiple DSAs", ResultCodeEnum.AFFECTSMULTIPLEDSAS);
                }
            }
            throw new IllegalStateException("If you get this exception the server's logic was flawed in handling a modifyDn operation while processing referrals.  Report this as a bug!");
        }
        if (refval.equals(FOLLOW)) {
            throw new NotImplementedException("follow referral handling mode not implemented");
        }
        throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
    }

    public void modifyRn(NextInterceptor next, LdapDN oldName, String newRdn, boolean deleteOldRdn) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        LdapDN newName = (LdapDN)oldName.clone();
        newName.remove(oldName.size() - 1);
        LdapDN newRdnName = new LdapDN(newRdn);
        newRdnName.normalize(this.attrRegistry.getNormalizerMapping());
        newName.add(newRdnName.toNormName());
        if (refval == null || refval.equals(IGNORE)) {
            next.modifyRn(oldName, newRdn, deleteOldRdn);
            if (this.lut.isReferral(oldName)) {
                this.lut.referralChanged(oldName, newName);
            }
            return;
        }
        if (refval.equals(THROW)) {
            LdapDN farthestSrc = this.lut.getFarthestReferralAncestor(oldName);
            LdapDN farthestDst = this.lut.getFarthestReferralAncestor(newName);
            if (farthestSrc == null && farthestDst == null && !this.lut.isReferral(newName)) {
                next.modifyRn(oldName, newRdn, deleteOldRdn);
                if (this.lut.isReferral(oldName)) {
                    this.lut.referralChanged(oldName, newName);
                }
                return;
            }
            if (farthestSrc != null) {
                Attributes referral = invocation.getProxy().lookup(farthestSrc, PartitionNexusProxy.LOOKUP_BYPASS);
                Attribute refs = referral.get(REF_ATTR);
                this.doReferralException(farthestSrc, new LdapDN(oldName.getUpName()), refs);
            } else {
                if (farthestDst != null) {
                    throw new LdapNamingException(farthestDst + " ancestor is a referral for modifyDn on " + newName + " so it affects multiple DSAs", ResultCodeEnum.AFFECTSMULTIPLEDSAS);
                }
                if (this.lut.isReferral(newName)) {
                    throw new LdapNamingException(newName + " exists and is a referral for modifyDn destination so it affects multiple DSAs", ResultCodeEnum.AFFECTSMULTIPLEDSAS);
                }
            }
            throw new IllegalStateException("If you get this exception the server's logic was flawed in handling a modifyDn operation while processing referrals.  Report this as a bug!");
        }
        if (refval.equals(FOLLOW)) {
            throw new NotImplementedException("follow referral handling mode not implemented");
        }
        throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
    }

    private void checkModify(LdapDN name, int modOp, Attributes mods) throws NamingException {
        boolean isTargetReferral = this.lut.isReferral(name);
        boolean isOcChange = mods.get(OBJCLASS_ATTR) != null;
        boolean modsOcHasReferral = ReferralService.hasValue(mods.get(OBJCLASS_ATTR), REFERRAL_OC);
        if (isOcChange) {
            switch (modOp) {
                case 1: {
                    if (!modsOcHasReferral || isTargetReferral) break;
                    this.lut.referralAdded(name);
                    break;
                }
                case 3: {
                    if (!modsOcHasReferral || !isTargetReferral) break;
                    this.lut.referralDeleted(name);
                    break;
                }
                case 2: {
                    if (isTargetReferral && !modsOcHasReferral) {
                        this.lut.referralDeleted(name);
                        break;
                    }
                    if (isTargetReferral || !modsOcHasReferral) break;
                    this.lut.referralAdded(name);
                    break;
                }
                default: {
                    throw new IllegalStateException("undefined modification operation");
                }
            }
        }
    }

    public void modify(NextInterceptor next, LdapDN name, int modOp, Attributes mods) throws NamingException {
        LdapDN farthest;
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        if (refval == null || refval.equals(IGNORE)) {
            next.modify(name, modOp, mods);
            this.checkModify(name, modOp, mods);
            return;
        }
        if (refval.equals(THROW)) {
            farthest = this.lut.getFarthestReferralAncestor(name);
            if (farthest == null) {
                next.modify(name, modOp, mods);
                this.checkModify(name, modOp, mods);
                return;
            }
        } else {
            if (refval.equals(FOLLOW)) {
                throw new NotImplementedException("follow referral handling mode not implemented");
            }
            throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
        }
        Attributes referral = invocation.getProxy().lookup(farthest, PartitionNexusProxy.LOOKUP_BYPASS);
        Attribute refs = referral.get(REF_ATTR);
        this.doReferralException(farthest, new LdapDN(name.getUpName()), refs);
    }

    private void checkModify(LdapDN name, ModificationItemImpl[] mods) throws NamingException {
        boolean isTargetReferral = this.lut.isReferral(name);
        block5: for (int ii = 0; ii < mods.length; ++ii) {
            if (!mods[ii].getAttribute().getID().equalsIgnoreCase(OBJCLASS_ATTR)) continue;
            boolean modsOcHasReferral = ReferralService.hasValue(mods[ii].getAttribute(), REFERRAL_OC);
            switch (mods[ii].getModificationOp()) {
                case 1: {
                    if (!modsOcHasReferral || isTargetReferral) break block5;
                    this.lut.referralAdded(name);
                    break block5;
                }
                case 3: {
                    if (!modsOcHasReferral || !isTargetReferral) break block5;
                    this.lut.referralDeleted(name);
                    break block5;
                }
                case 2: {
                    if (isTargetReferral && !modsOcHasReferral) {
                        this.lut.referralDeleted(name);
                        break block5;
                    }
                    if (isTargetReferral || !modsOcHasReferral) break block5;
                    this.lut.referralAdded(name);
                    break block5;
                }
                default: {
                    throw new IllegalStateException("undefined modification operation");
                }
            }
        }
    }

    public void modify(NextInterceptor next, LdapDN name, ModificationItemImpl[] mods) throws NamingException {
        LdapDN farthest;
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        if (refval == null || refval.equals(IGNORE)) {
            next.modify(name, mods);
            this.checkModify(name, mods);
            return;
        }
        if (refval.equals(THROW)) {
            farthest = this.lut.getFarthestReferralAncestor(name);
            if (farthest == null) {
                next.modify(name, mods);
                this.checkModify(name, mods);
                return;
            }
        } else {
            if (refval.equals(FOLLOW)) {
                throw new NotImplementedException("follow referral handling mode not implemented");
            }
            throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
        }
        Attributes referral = invocation.getProxy().lookup(farthest, PartitionNexusProxy.LOOKUP_BYPASS);
        Attribute refs = referral.get(REF_ATTR);
        this.doReferralException(farthest, new LdapDN(name.getUpName()), refs);
    }

    static ExprNode getReferralFilter() {
        return new SimpleNode(OBJCLASS_ATTR, REFERRAL_OC, 0);
    }

    static SearchControls getControls() {
        SearchControls controls = new SearchControls();
        controls.setReturningObjFlag(false);
        controls.setSearchScope(2);
        return controls;
    }

    public void addContextPartition(NextInterceptor next, PartitionConfiguration cfg) throws NamingException {
        next.addContextPartition(cfg);
        Partition partition = cfg.getContextPartition();
        LdapDN suffix = partition.getSuffix();
        Invocation invocation = InvocationStack.getInstance().peek();
        NamingEnumeration list = invocation.getProxy().search(suffix, this.env, ReferralService.getReferralFilter(), ReferralService.getControls(), SEARCH_BYPASS);
        this.addReferrals(list, suffix);
    }

    public void removeContextPartition(NextInterceptor next, LdapDN suffix) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        NamingEnumeration list = invocation.getProxy().search(suffix, this.env, ReferralService.getReferralFilter(), ReferralService.getControls(), SEARCH_BYPASS);
        this.deleteReferrals(list, suffix);
        next.removeContextPartition(suffix);
    }

    private void addReferrals(NamingEnumeration referrals, LdapDN base) throws NamingException {
        while (referrals.hasMore()) {
            SearchResult r = (SearchResult)referrals.next();
            LdapDN referral = null;
            LdapDN result = new LdapDN(r.getName());
            result.normalize(this.attrRegistry.getNormalizerMapping());
            if (r.isRelative()) {
                referral = (LdapDN)base.clone();
                referral.addAll((Name)result);
            } else {
                referral = result;
            }
            this.lut.referralAdded(result);
        }
    }

    private void deleteReferrals(NamingEnumeration referrals, LdapDN base) throws NamingException {
        while (referrals.hasMore()) {
            SearchResult r = (SearchResult)referrals.next();
            LdapDN referral = null;
            LdapDN result = new LdapDN(r.getName());
            result.normalize(this.attrRegistry.getNormalizerMapping());
            if (r.isRelative()) {
                referral = (LdapDN)base.clone();
                referral.addAll((Name)result);
            } else {
                referral = result;
            }
            this.lut.referralDeleted(result);
        }
    }

    public NamingEnumeration search(NextInterceptor next, LdapDN base, Map env, ExprNode filter, SearchControls controls) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        ServerLdapContext caller = (ServerLdapContext)invocation.getCaller();
        String refval = (String)caller.getEnvironment().get("java.naming.referral");
        if (refval == null || refval.equals(IGNORE)) {
            return next.search(base, env, filter, controls);
        }
        if (refval.equals(THROW_FINDING_BASE)) {
            LdapDN farthest;
            if (this.lut.isReferral(base)) {
                Attributes referral = invocation.getProxy().lookup(base, PartitionNexusProxy.LOOKUP_BYPASS);
                Attribute refs = referral.get(REF_ATTR);
                this.doReferralExceptionOnSearchBase(base, refs, controls.getSearchScope());
            }
            if ((farthest = this.lut.getFarthestReferralAncestor(base)) == null) {
                return next.search(base, env, filter, controls);
            }
            Attributes referral = invocation.getProxy().lookup(farthest, PartitionNexusProxy.LOOKUP_BYPASS);
            Attribute refs = referral.get(REF_ATTR);
            this.doReferralExceptionOnSearchBase(farthest, new LdapDN(base.getUpName()), refs, controls.getSearchScope());
            throw new IllegalStateException("Should never get here: shutting up compiler");
        }
        if (refval.equals(THROW)) {
            LdapDN farthest;
            if (this.lut.isReferral(base)) {
                Attributes referral = invocation.getProxy().lookup(base, PartitionNexusProxy.LOOKUP_BYPASS);
                Attribute refs = referral.get(REF_ATTR);
                this.doReferralExceptionOnSearchBase(base, refs, controls.getSearchScope());
            }
            if ((farthest = this.lut.getFarthestReferralAncestor(base)) == null) {
                SearchResultFilteringEnumeration srfe = (SearchResultFilteringEnumeration)next.search(base, env, filter, controls);
                return new ReferralHandlingEnumeration(srfe, this.lut, this.attrRegistry, this.nexus, controls.getSearchScope(), true);
            }
            Attributes referral = invocation.getProxy().lookup(farthest, PartitionNexusProxy.LOOKUP_BYPASS);
            Attribute refs = referral.get(REF_ATTR);
            this.doReferralExceptionOnSearchBase(farthest, new LdapDN(base.getUpName()), refs, controls.getSearchScope());
            throw new IllegalStateException("Should never get here: shutting up compiler");
        }
        if (refval.equals(FOLLOW)) {
            throw new NotImplementedException("follow referral handling mode not implemented");
        }
        throw new LdapNamingException("Undefined value for java.naming.referral key: " + refval, ResultCodeEnum.OTHER);
    }

    public void doReferralExceptionOnSearchBase(LdapDN base, Attribute refs, int scope) throws NamingException {
        ArrayList<String> list = new ArrayList<String>(refs.size());
        for (int ii = 0; ii < refs.size(); ++ii) {
            String val = (String)refs.get(ii);
            if (!val.startsWith("ldap")) {
                list.add(val);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(val.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                log.error("Bad URL (" + val + ") for ref in " + base + ".  Reference will be ignored.");
            }
            StringBuffer buf = new StringBuffer();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(ldapUrl.getDn());
            buf.append("??");
            switch (scope) {
                case 2: {
                    buf.append("sub");
                    break;
                }
                case 1: {
                    buf.append("one");
                    break;
                }
                case 0: {
                    buf.append("base");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown recognized search scope: " + scope);
                }
            }
            list.add(buf.toString());
        }
        LdapReferralException lre = new LdapReferralException(list);
        throw lre;
    }

    public void doReferralExceptionOnSearchBase(LdapDN farthest, LdapDN targetUpdn, Attribute refs, int scope) throws NamingException {
        ArrayList<String> list = new ArrayList<String>(refs.size());
        for (int ii = 0; ii < refs.size(); ++ii) {
            String val = (String)refs.get(ii);
            if (!val.startsWith("ldap")) {
                list.add(val);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(val.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                log.error("Bad URL (" + val + ") for ref in " + farthest + ".  Reference will be ignored.");
            }
            LdapDN urlDn = new LdapDN(ldapUrl.getDn().toNormName());
            urlDn.normalize(this.attrRegistry.getNormalizerMapping());
            int diff = targetUpdn.size() - farthest.size();
            LdapDN extra = new LdapDN();
            for (int jj = 0; jj < diff; ++jj) {
                extra.add(targetUpdn.get(farthest.size() + jj));
            }
            urlDn.addAll((Name)extra);
            StringBuffer buf = new StringBuffer();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(urlDn.getUpName());
            buf.append("??");
            switch (scope) {
                case 2: {
                    buf.append("sub");
                    break;
                }
                case 1: {
                    buf.append("one");
                    break;
                }
                case 0: {
                    buf.append("base");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown recognized search scope: " + scope);
                }
            }
            list.add(buf.toString());
        }
        LdapReferralException lre = new LdapReferralException(list);
        throw lre;
    }

    public boolean isReferral(String name) throws NamingException {
        if (this.lut.isReferral(name)) {
            return true;
        }
        LdapDN dn = new LdapDN(name);
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return this.lut.isReferral(dn);
    }

    static {
        REFS_TYPE = null;
        HashSet<String> c = new HashSet<String>();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("operationalAttributeService");
        c.add(NAME);
        c.add("eventService");
        SEARCH_BYPASS = Collections.unmodifiableCollection(c);
    }

    class ReferralFilter
    implements SearchResultFilter {
        ReferralFilter() {
        }

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            return false;
        }
    }
}

