/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.ComparatorRegistry;
import org.apache.directory.server.core.schema.DITContentRuleRegistry;
import org.apache.directory.server.core.schema.DITStructureRuleRegistry;
import org.apache.directory.server.core.schema.GlobalAttributeTypeRegistry;
import org.apache.directory.server.core.schema.GlobalComparatorRegistry;
import org.apache.directory.server.core.schema.GlobalDitContentRuleRegistry;
import org.apache.directory.server.core.schema.GlobalDitStructureRuleRegistry;
import org.apache.directory.server.core.schema.GlobalMatchingRuleRegistry;
import org.apache.directory.server.core.schema.GlobalMatchingRuleUseRegistry;
import org.apache.directory.server.core.schema.GlobalNameFormRegistry;
import org.apache.directory.server.core.schema.GlobalNormalizerRegistry;
import org.apache.directory.server.core.schema.GlobalObjectClassRegistry;
import org.apache.directory.server.core.schema.GlobalOidRegistry;
import org.apache.directory.server.core.schema.GlobalSyntaxCheckerRegistry;
import org.apache.directory.server.core.schema.GlobalSyntaxRegistry;
import org.apache.directory.server.core.schema.MatchingRuleRegistry;
import org.apache.directory.server.core.schema.MatchingRuleUseRegistry;
import org.apache.directory.server.core.schema.NameFormRegistry;
import org.apache.directory.server.core.schema.NormalizerRegistry;
import org.apache.directory.server.core.schema.ObjectClassRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.schema.Registries;
import org.apache.directory.server.core.schema.SyntaxCheckerRegistry;
import org.apache.directory.server.core.schema.SyntaxRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapAttributeTypeRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapComparatorRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapDitContentRuleRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapDitStructureRuleRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapMatchingRuleRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapMatchingRuleUseRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapNameFormRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapNormalizerRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapObjectClassRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapOidRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapRegistries;
import org.apache.directory.server.core.schema.bootstrap.BootstrapSyntaxCheckerRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapSyntaxRegistry;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.Syntax;

public class GlobalRegistries
implements Registries {
    private GlobalAttributeTypeRegistry attributeTypeRegistry;
    private GlobalComparatorRegistry comparatorRegistry;
    private GlobalDitContentRuleRegistry ditContentRuleRegistry;
    private GlobalDitStructureRuleRegistry ditStructureRuleRegistry;
    private GlobalMatchingRuleRegistry matchingRuleRegistry;
    private GlobalMatchingRuleUseRegistry matchingRuleUseRegistry;
    private GlobalNameFormRegistry nameFormRegistry;
    private GlobalNormalizerRegistry normalizerRegistry;
    private GlobalObjectClassRegistry objectClassRegistry;
    private GlobalOidRegistry oidRegistry;
    private GlobalSyntaxCheckerRegistry syntaxCheckerRegistry;
    private GlobalSyntaxRegistry syntaxRegistry;

    public GlobalRegistries(BootstrapRegistries bootstrapRegistries) {
        this.oidRegistry = new GlobalOidRegistry((BootstrapOidRegistry)bootstrapRegistries.getOidRegistry());
        this.normalizerRegistry = new GlobalNormalizerRegistry((BootstrapNormalizerRegistry)bootstrapRegistries.getNormalizerRegistry());
        this.comparatorRegistry = new GlobalComparatorRegistry((BootstrapComparatorRegistry)bootstrapRegistries.getComparatorRegistry());
        this.syntaxCheckerRegistry = new GlobalSyntaxCheckerRegistry((BootstrapSyntaxCheckerRegistry)bootstrapRegistries.getSyntaxCheckerRegistry());
        this.syntaxRegistry = new GlobalSyntaxRegistry((BootstrapSyntaxRegistry)bootstrapRegistries.getSyntaxRegistry(), this.oidRegistry);
        this.matchingRuleRegistry = new GlobalMatchingRuleRegistry((BootstrapMatchingRuleRegistry)bootstrapRegistries.getMatchingRuleRegistry(), this.oidRegistry);
        this.attributeTypeRegistry = new GlobalAttributeTypeRegistry((BootstrapAttributeTypeRegistry)bootstrapRegistries.getAttributeTypeRegistry(), this.oidRegistry);
        this.objectClassRegistry = new GlobalObjectClassRegistry((BootstrapObjectClassRegistry)bootstrapRegistries.getObjectClassRegistry(), this.oidRegistry);
        this.ditContentRuleRegistry = new GlobalDitContentRuleRegistry((BootstrapDitContentRuleRegistry)bootstrapRegistries.getDitContentRuleRegistry(), this.oidRegistry);
        this.ditStructureRuleRegistry = new GlobalDitStructureRuleRegistry((BootstrapDitStructureRuleRegistry)bootstrapRegistries.getDitStructureRuleRegistry(), this.oidRegistry);
        this.matchingRuleUseRegistry = new GlobalMatchingRuleUseRegistry((BootstrapMatchingRuleUseRegistry)bootstrapRegistries.getMatchingRuleUseRegistry(), this.oidRegistry);
        this.nameFormRegistry = new GlobalNameFormRegistry((BootstrapNameFormRegistry)bootstrapRegistries.getNameFormRegistry(), this.oidRegistry);
    }

    public AttributeTypeRegistry getAttributeTypeRegistry() {
        return this.attributeTypeRegistry;
    }

    public ComparatorRegistry getComparatorRegistry() {
        return this.comparatorRegistry;
    }

    public DITContentRuleRegistry getDitContentRuleRegistry() {
        return this.ditContentRuleRegistry;
    }

    public DITStructureRuleRegistry getDitStructureRuleRegistry() {
        return this.ditStructureRuleRegistry;
    }

    public MatchingRuleRegistry getMatchingRuleRegistry() {
        return this.matchingRuleRegistry;
    }

    public MatchingRuleUseRegistry getMatchingRuleUseRegistry() {
        return this.matchingRuleUseRegistry;
    }

    public NameFormRegistry getNameFormRegistry() {
        return this.nameFormRegistry;
    }

    public NormalizerRegistry getNormalizerRegistry() {
        return this.normalizerRegistry;
    }

    public ObjectClassRegistry getObjectClassRegistry() {
        return this.objectClassRegistry;
    }

    public OidRegistry getOidRegistry() {
        return this.oidRegistry;
    }

    public SyntaxCheckerRegistry getSyntaxCheckerRegistry() {
        return this.syntaxCheckerRegistry;
    }

    public SyntaxRegistry getSyntaxRegistry() {
        return this.syntaxRegistry;
    }

    public List checkRefInteg() {
        ArrayList errors = new ArrayList();
        Iterator list = this.objectClassRegistry.list();
        while (list.hasNext()) {
            ObjectClass oc = (ObjectClass)list.next();
            this.resolve(oc, errors);
        }
        list = this.attributeTypeRegistry.list();
        while (list.hasNext()) {
            AttributeType at = (AttributeType)list.next();
            this.resolve(at, errors);
        }
        list = this.matchingRuleRegistry.list();
        while (list.hasNext()) {
            MatchingRule mr = (MatchingRule)list.next();
            this.resolve(mr, errors);
        }
        list = this.syntaxRegistry.list();
        while (list.hasNext()) {
            Syntax syntax = (Syntax)list.next();
            this.resolve(syntax, errors);
        }
        return errors;
    }

    private boolean resolve(Syntax syntax, List errors) {
        if (syntax == null) {
            return true;
        }
        try {
            syntax.getSyntaxChecker();
            return true;
        }
        catch (NamingException e) {
            errors.add(e);
            return false;
        }
    }

    private boolean resolve(MatchingRule mr, List errors) {
        String schema;
        boolean isSuccess = true;
        if (mr == null) {
            return true;
        }
        try {
            if (mr.getComparator() == null) {
                schema = this.matchingRuleRegistry.getSchemaName(mr.getOid());
                errors.add(new NullPointerException("matchingRule " + mr.getName() + " in schema " + schema + " with OID " + mr.getOid() + " has a null comparator"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            if (mr.getNormalizer() == null) {
                schema = this.matchingRuleRegistry.getSchemaName(mr.getOid());
                errors.add(new NullPointerException("matchingRule " + mr.getName() + " in schema " + schema + " with OID " + mr.getOid() + " has a null normalizer"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(mr.getSyntax(), errors);
            if (mr.getSyntax() == null) {
                schema = this.matchingRuleRegistry.getSchemaName(mr.getOid());
                errors.add(new NullPointerException("matchingRule " + mr.getName() + " in schema " + schema + " with OID " + mr.getOid() + " has a null Syntax"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        return isSuccess;
    }

    private boolean resolve(AttributeType at, List errors) {
        boolean isSuccess = true;
        boolean hasMatchingRule = false;
        if (at == null) {
            return true;
        }
        try {
            isSuccess &= this.resolve(at.getSuperior(), errors);
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getEquality(), errors);
            if (at.getEquality() != null) {
                hasMatchingRule |= true;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getOrdering(), errors);
            if (at.getOrdering() != null) {
                hasMatchingRule |= true;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getSubstr(), errors);
            if (at.getSubstr() != null) {
                hasMatchingRule |= true;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getSyntax(), errors);
            if (at.getSyntax() == null) {
                String schema = this.attributeTypeRegistry.getSchemaName(at.getOid());
                errors.add(new NullPointerException("attributeType " + at.getName() + " in schema " + schema + " with OID " + at.getOid() + " has a null Syntax"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        if (hasMatchingRule) {
            // empty if block
        }
        return isSuccess;
    }

    private boolean resolve(ObjectClass oc, List errors) {
        boolean isSuccess = true;
        if (oc == null) {
            return true;
        }
        ObjectClass[] superiors = new ObjectClass[]{};
        try {
            superiors = oc.getSuperClasses();
        }
        catch (NamingException e) {
            superiors = new ObjectClass[]{};
            isSuccess = false;
            errors.add(e);
        }
        for (int ii = 0; ii < superiors.length; ++ii) {
            isSuccess &= this.resolve(superiors[ii], errors);
        }
        AttributeType[] mayList = new AttributeType[]{};
        try {
            mayList = oc.getMayList();
        }
        catch (NamingException e) {
            mayList = new AttributeType[]{};
            isSuccess = false;
            errors.add(e);
        }
        for (int ii = 0; ii < mayList.length; ++ii) {
            isSuccess &= this.resolve(mayList[ii], errors);
        }
        AttributeType[] mustList = new AttributeType[]{};
        try {
            mustList = oc.getMustList();
        }
        catch (NamingException e) {
            mustList = new AttributeType[]{};
            isSuccess = false;
            errors.add(e);
        }
        for (int ii = 0; ii < mustList.length; ++ii) {
            isSuccess &= this.resolve(mustList[ii], errors);
        }
        return isSuccess;
    }
}

