/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.NormalizerRegistry;
import org.apache.directory.server.core.schema.NormalizerRegistryMonitor;
import org.apache.directory.server.core.schema.NormalizerRegistryMonitorAdapter;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class BootstrapNormalizerRegistry
implements NormalizerRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private NormalizerRegistryMonitor monitor = new NormalizerRegistryMonitorAdapter();

    public void setMonitor(NormalizerRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, String oid, Normalizer normalizer) throws NamingException {
        if (this.byOid.containsKey(oid)) {
            NamingException e = new NamingException("Normalizer already registered for OID " + oid);
            this.monitor.registerFailed(oid, normalizer, e);
            throw e;
        }
        this.oidToSchema.put(oid, schema);
        this.byOid.put(oid, normalizer);
        this.monitor.registered(oid, normalizer);
    }

    public Normalizer lookup(String oid) throws NamingException {
        if (!this.byOid.containsKey(oid)) {
            NamingException e = new NamingException("Normalizer for OID " + oid + " does not exist!");
            this.monitor.lookupFailed(oid, e);
            throw e;
        }
        Normalizer normalizer = (Normalizer)this.byOid.get(oid);
        this.monitor.lookedUp(oid, normalizer);
        return normalizer;
    }

    public boolean hasNormalizer(String oid) {
        return this.byOid.containsKey(oid);
    }

    public String getSchemaName(String oid) throws NamingException {
        if (Character.isDigit(oid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        if (this.oidToSchema.containsKey(oid)) {
            return (String)this.oidToSchema.get(oid);
        }
        throw new NamingException("OID " + oid + " not found in oid to " + "schema name map!");
    }
}

