/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.HashMap;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.jndi.ServerDirObjectFactory;
import org.apache.directory.server.core.schema.ObjectFactoryRegistry;
import org.apache.directory.server.core.schema.OidRegistry;

public class BootstrapObjectFactoryRegistry
implements ObjectFactoryRegistry {
    private final HashMap byOid = new HashMap();
    private final OidRegistry oidRegistry;

    public BootstrapObjectFactoryRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
    }

    public ServerDirObjectFactory getObjectFactories(LdapContext ctx) throws NamingException {
        String oid;
        String noid;
        Attribute objectClass = ctx.getAttributes("").get("objectClass");
        if (objectClass == null) {
            return null;
        }
        if (ctx.getEnvironment().containsKey("factory.hint") && this.byOid.containsKey(noid = this.oidRegistry.getOid(oid = (String)ctx.getEnvironment().get("factory.hint")))) {
            return (ServerDirObjectFactory)this.byOid.get(noid);
        }
        for (int ii = 0; ii < objectClass.size(); ++ii) {
            noid = this.oidRegistry.getOid((String)objectClass.get(ii));
            if (!this.byOid.containsKey(noid)) continue;
            return (ServerDirObjectFactory)this.byOid.get(noid);
        }
        return null;
    }

    public void register(ServerDirObjectFactory factory) throws NamingException {
        this.byOid.put(this.oidRegistry.getOid(factory.getObjectClassId()), factory);
    }
}

