/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.naming.NamingException;
import org.apache.directory.server.core.jndi.ServerDirObjectFactory;
import org.apache.directory.server.core.jndi.ServerDirStateFactory;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.ComparatorRegistry;
import org.apache.directory.server.core.schema.DITContentRuleRegistry;
import org.apache.directory.server.core.schema.DITStructureRuleRegistry;
import org.apache.directory.server.core.schema.MatchingRuleRegistry;
import org.apache.directory.server.core.schema.MatchingRuleUseRegistry;
import org.apache.directory.server.core.schema.NameFormRegistry;
import org.apache.directory.server.core.schema.NormalizerRegistry;
import org.apache.directory.server.core.schema.ObjectClassRegistry;
import org.apache.directory.server.core.schema.ObjectFactoryRegistry;
import org.apache.directory.server.core.schema.StateFactoryRegistry;
import org.apache.directory.server.core.schema.SyntaxCheckerRegistry;
import org.apache.directory.server.core.schema.SyntaxRegistry;
import org.apache.directory.server.core.schema.bootstrap.BootstrapProducer;
import org.apache.directory.server.core.schema.bootstrap.BootstrapRegistries;
import org.apache.directory.server.core.schema.bootstrap.BootstrapSchema;
import org.apache.directory.server.core.schema.bootstrap.ProducerCallback;
import org.apache.directory.server.core.schema.bootstrap.ProducerTypeEnum;
import org.apache.directory.server.core.schema.bootstrap.SystemSchema;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapSchemaLoader {
    private static final Logger log = LoggerFactory.getLogger((Class)BootstrapSchemaLoader.class);
    private ThreadLocal schemas;
    private ThreadLocal registries;
    private final ProducerCallback cb = new ProducerCallback(){

        public void schemaObjectProduced(BootstrapProducer producer, String registryKey, Object schemaObject) throws NamingException {
            BootstrapSchemaLoader.this.register(producer.getType(), registryKey, schemaObject);
        }
    };

    public BootstrapSchemaLoader() {
        this.schemas = new ThreadLocal();
        this.registries = new ThreadLocal();
    }

    public final void load(Collection bootstrapSchemas, BootstrapRegistries registries) throws NamingException {
        BootstrapSchema[] schemas = new BootstrapSchema[bootstrapSchemas.size()];
        schemas = bootstrapSchemas.toArray(schemas);
        HashMap<String, SystemSchema> loaded = new HashMap<String, SystemSchema>();
        HashMap<String, BootstrapSchema> notLoaded = new HashMap<String, BootstrapSchema>();
        for (int ii = 0; ii < schemas.length; ++ii) {
            notLoaded.put(schemas[ii].getSchemaName(), schemas[ii]);
        }
        SystemSchema schema = new SystemSchema();
        this.load((BootstrapSchema)schema, registries);
        notLoaded.remove(schema.getSchemaName());
        loaded.put(schema.getSchemaName(), schema);
        Iterator list = notLoaded.values().iterator();
        while (list.hasNext()) {
            schema = (BootstrapSchema)list.next();
            this.loadDepsFirst(new Stack(), notLoaded, (BootstrapSchema)schema, registries);
            list = notLoaded.values().iterator();
        }
    }

    public final void loadDepsFirst(Stack beenthere, HashMap notLoaded, BootstrapSchema schema, BootstrapRegistries registries) throws NamingException {
        beenthere.push(schema.getSchemaName());
        String[] deps = schema.getDependencies();
        if (deps == null || deps.length == 0) {
            this.load(schema, registries);
            notLoaded.remove(schema.getSchemaName());
            beenthere.pop();
            return;
        }
        for (int ii = 0; ii < deps.length; ++ii) {
            if (!notLoaded.containsKey(deps[ii])) continue;
            BootstrapSchema dep = (BootstrapSchema)notLoaded.get(deps[ii]);
            if (beenthere.contains(dep.getSchemaName())) {
                beenthere.push(dep.getSchemaName());
                throw new NamingException("schema dependency cycle detected: " + beenthere);
            }
            this.loadDepsFirst(beenthere, notLoaded, dep, registries);
        }
        this.load(schema, registries);
        notLoaded.remove(schema.getSchemaName());
        beenthere.pop();
    }

    public final void load(BootstrapSchema schema, BootstrapRegistries registries) throws NamingException {
        this.registries.set(registries);
        this.schemas.set(schema);
        List producers = ProducerTypeEnum.list();
        for (int ii = 0; ii < producers.size(); ++ii) {
            ProducerTypeEnum producerType = (ProducerTypeEnum)producers.get(ii);
            BootstrapProducer producer = this.getProducer(schema, producerType.getName());
            producer.produce(registries, this.cb);
        }
    }

    private void register(ProducerTypeEnum type, String id, Object schemaObject) throws NamingException {
        BootstrapSchema schema = (BootstrapSchema)this.schemas.get();
        BootstrapRegistries registries = (BootstrapRegistries)this.registries.get();
        switch (type.getValue()) {
            case 0: {
                Normalizer normalizer = (Normalizer)schemaObject;
                NormalizerRegistry normalizerRegistry = registries.getNormalizerRegistry();
                normalizerRegistry.register(schema.getSchemaName(), id, normalizer);
                break;
            }
            case 1: {
                Comparator comparator = (Comparator)schemaObject;
                ComparatorRegistry comparatorRegistry = registries.getComparatorRegistry();
                comparatorRegistry.register(schema.getSchemaName(), id, comparator);
                break;
            }
            case 2: {
                SyntaxChecker syntaxChecker = (SyntaxChecker)schemaObject;
                SyntaxCheckerRegistry syntaxCheckerRegistry = registries.getSyntaxCheckerRegistry();
                syntaxCheckerRegistry.register(schema.getSchemaName(), id, syntaxChecker);
                break;
            }
            case 3: {
                Syntax syntax = (Syntax)schemaObject;
                SyntaxRegistry syntaxRegistry = registries.getSyntaxRegistry();
                syntaxRegistry.register(schema.getSchemaName(), syntax);
                break;
            }
            case 4: {
                MatchingRule matchingRule = (MatchingRule)schemaObject;
                MatchingRuleRegistry matchingRuleRegistry = registries.getMatchingRuleRegistry();
                matchingRuleRegistry.register(schema.getSchemaName(), matchingRule);
                break;
            }
            case 5: {
                AttributeType attributeType = (AttributeType)schemaObject;
                AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
                attributeTypeRegistry.register(schema.getSchemaName(), attributeType);
                break;
            }
            case 6: {
                ObjectClass objectClass = (ObjectClass)schemaObject;
                ObjectClassRegistry objectClassRegistry = registries.getObjectClassRegistry();
                objectClassRegistry.register(schema.getSchemaName(), objectClass);
                break;
            }
            case 7: {
                MatchingRuleUse matchingRuleUse = (MatchingRuleUse)schemaObject;
                MatchingRuleUseRegistry matchingRuleUseRegistry = registries.getMatchingRuleUseRegistry();
                matchingRuleUseRegistry.register(schema.getSchemaName(), matchingRuleUse);
                break;
            }
            case 8: {
                DITContentRule ditContentRule = (DITContentRule)schemaObject;
                DITContentRuleRegistry ditContentRuleRegistry = registries.getDitContentRuleRegistry();
                ditContentRuleRegistry.register(schema.getSchemaName(), ditContentRule);
                break;
            }
            case 9: {
                NameForm nameForm = (NameForm)schemaObject;
                NameFormRegistry nameFormRegistry = registries.getNameFormRegistry();
                nameFormRegistry.register(schema.getSchemaName(), nameForm);
                break;
            }
            case 10: {
                DITStructureRule ditStructureRule = (DITStructureRule)schemaObject;
                DITStructureRuleRegistry ditStructureRuleRegistry = registries.getDitStructureRuleRegistry();
                ditStructureRuleRegistry.register(schema.getSchemaName(), ditStructureRule);
                break;
            }
            case 11: {
                ServerDirStateFactory stateFactory = (ServerDirStateFactory)schemaObject;
                StateFactoryRegistry stateFactoryRegistry = registries.getStateFactoryRegistry();
                stateFactoryRegistry.register(stateFactory);
                break;
            }
            case 12: {
                ServerDirObjectFactory objectFactory = (ServerDirObjectFactory)schemaObject;
                ObjectFactoryRegistry objectFactoryRegistry = registries.getObjectFactoryRegistry();
                objectFactoryRegistry.register(objectFactory);
                break;
            }
            default: {
                throw new IllegalStateException("ProducerTypeEnum is broke!");
            }
        }
    }

    private BootstrapProducer getProducer(BootstrapSchema schema, String producerBase) throws NamingException {
        Class<?> clazz = null;
        boolean failedTargetLoad = false;
        String targetClassName = schema.getBaseClassName() + producerBase;
        try {
            clazz = Class.forName(targetClassName);
        }
        catch (ClassNotFoundException e) {
            failedTargetLoad = true;
            log.debug("Failed to load '" + targetClassName + "'.  Trying the alternative.", (Throwable)e);
        }
        if (failedTargetLoad) {
            String defaultClassName = schema.getDefaultBaseClassName() + producerBase;
            try {
                clazz = Class.forName(defaultClassName);
            }
            catch (ClassNotFoundException e) {
                NamingException ne = new NamingException("Failed to load " + producerBase + " for " + schema.getSchemaName() + " schema using following classes: " + targetClassName + ", " + defaultClassName);
                ne.setRootCause(e);
                throw ne;
            }
        }
        try {
            return (BootstrapProducer)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException("Failed to create " + clazz);
            ne.setRootCause(e);
            throw ne;
        }
        catch (InstantiationException e) {
            NamingException ne = new NamingException("Failed to create " + clazz);
            ne.setRootCause(e);
            throw ne;
        }
    }
}

