/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.bootstrap;

import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.server.core.schema.bootstrap.AbstractBootstrapProducer;
import org.apache.directory.server.core.schema.bootstrap.BootstrapRegistries;
import org.apache.directory.server.core.schema.bootstrap.ProducerCallback;
import org.apache.directory.server.core.schema.bootstrap.ProducerTypeEnum;
import org.apache.directory.shared.ldap.schema.UsageEnum;

public class NisAttributeTypeProducer
extends AbstractBootstrapProducer {
    public NisAttributeTypeProducer() {
        super(ProducerTypeEnum.ATTRIBUTE_TYPE_PRODUCER);
    }

    public void produce(BootstrapRegistries registries, ProducerCallback cb) throws NamingException {
        ArrayList<String> names = new ArrayList<String>();
        AbstractBootstrapProducer.BootstrapAttributeType attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.0", registries);
        attributeType.setDescription("An integer uniquely identifying a user in an administrative domain");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("uidNumber");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.0", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.1", registries);
        attributeType.setDescription("An integer uniquely identifying a group in an administrative domain");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("gidNumber");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.1", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.2", registries);
        attributeType.setDescription("The GECOS field; the common name");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSubstrId("caseIgnoreIA5SubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("gecos");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.2", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.3", registries);
        attributeType.setDescription("The absolute path to the home directory");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseExactIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("homeDirectory");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.3", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.4", registries);
        attributeType.setDescription("The path to the login shell");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseExactIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("loginShell");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.4", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.5", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("shadowLastChange");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.5", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.6", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("shadowMin");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.6", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.7", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("shadowMax");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.7", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.8", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("shadowWarning");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.8", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.9", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("shadowInactive");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.9", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.10", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("shadowExpire");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.10", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.11", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("shadowFlag");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.11", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.12", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseExactIA5Match");
        attributeType.setSubstrId("caseExactIA5SubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("memberUid");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.12", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.13", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseExactIA5Match");
        attributeType.setSubstrId("caseExactIA5SubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("memberNisNetgroup");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.13", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.14", registries);
        attributeType.setDescription("Netgroup triple");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.1.1.0.0");
        names.clear();
        names.add("nisNetgroupTriple");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.14", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.15", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("ipServicePort");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.15", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.16", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("ipServiceProtocol");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.16", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.17", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("ipProtocolNumber");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.17", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.18", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("integerMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.27");
        names.clear();
        names.add("oncRpcNumber");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.18", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.19", registries);
        attributeType.setDescription("IP address");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(128);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("ipHostNumber");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.19", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.20", registries);
        attributeType.setDescription("IP network");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(128);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("ipNetworkNumber");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.20", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.21", registries);
        attributeType.setDescription("IP netmask");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(128);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("ipNetmaskNumber");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.21", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.22", registries);
        attributeType.setDescription("MAC address");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(128);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseIgnoreIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("macAddress");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.22", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.23", registries);
        attributeType.setDescription("rpc.bootparamd parameter");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSyntaxId("1.3.6.1.1.1.0.1");
        names.clear();
        names.add("bootParameter");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.23", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.24", registries);
        attributeType.setDescription("Boot image name");
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseExactIA5Match");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("bootFile");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.24", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.26", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(false);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(-1);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setSuperiorId("name");
        names.clear();
        names.add("nisMapName");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.26", (Object)attributeType);
        attributeType = NisAttributeTypeProducer.newAttributeType("1.3.6.1.1.1.1.27", registries);
        attributeType.setCanUserModify(true);
        attributeType.setSingleValue(true);
        attributeType.setCollective(false);
        attributeType.setObsolete(false);
        attributeType.setLength(1024);
        attributeType.setUsage(UsageEnum.getUsage((String)"userApplications"));
        attributeType.setEqualityId("caseExactIA5Match");
        attributeType.setSubstrId("caseExactIA5SubstringsMatch");
        attributeType.setSyntaxId("1.3.6.1.4.1.1466.115.121.1.26");
        names.clear();
        names.add("nisMapEntry");
        attributeType.setNames(names.toArray(EMPTY));
        cb.schemaObjectProduced(this, "1.3.6.1.1.1.1.27", (Object)attributeType);
    }
}

