/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.distributions;

import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.openthinclient.api.distributions.InstallableDistribution;
import org.openthinclient.pkgmgr.SourcesList;
import org.openthinclient.pkgmgr.db.Source;

@XmlRootElement(name="distributions")
@XmlType
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InstallableDistributions {
    public static final URI OFFICIAL_DISTRIBUTIONS_XML = URI.create("http://archive.openthinclient.org/openthinclient/distributions.xml");
    public static final String LOCAL_DISTRIBUTIONS_XML = "/org/openthinclient/distributions.xml";
    public static JAXBContext CONTEXT;
    @XmlElement(name="distribution")
    private final List<InstallableDistribution> installableDistributions = new ArrayList<InstallableDistribution>();
    @XmlTransient
    private URI baseURI;

    public static InstallableDistributions getDefaultDistributions() {
        try {
            return InstallableDistributions.load(InstallableDistributions.getDefaultDistributionsURL());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load the default distributions", e);
        }
    }

    public static URL getDefaultDistributionsURL() {
        return InstallableDistributions.class.getResource(LOCAL_DISTRIBUTIONS_XML);
    }

    public static InstallableDistributions load(URL distributionsURL, Proxy proxy) throws Exception {
        URI distributionsURI = distributionsURL.toURI();
        try (InputStream is = distributionsURL.openConnection(proxy).getInputStream();){
            InstallableDistributions installableDistributions = InstallableDistributions.load(distributionsURI, is);
            return installableDistributions;
        }
    }

    public static InstallableDistributions load(URL distributionsURL) throws Exception {
        URI distributionsURI = distributionsURL.toURI();
        try (InputStream is = distributionsURL.openStream();){
            InstallableDistributions installableDistributions = InstallableDistributions.load(distributionsURI, is);
            return installableDistributions;
        }
    }

    public static InstallableDistributions load(URI distributionsURI, InputStream is) throws Exception {
        Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
        InstallableDistributions installableDistributions = (InstallableDistributions)unmarshaller.unmarshal(is);
        URI baseURI = distributionsURI.resolve(".");
        installableDistributions.setBaseURI(baseURI);
        return installableDistributions;
    }

    public static InstallableDistribution getPreferredDistribution() {
        return InstallableDistributions.getDefaultDistributions().getPreferred();
    }

    public List<InstallableDistribution> getInstallableDistributions() {
        return this.installableDistributions;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    public InstallableDistribution getPreferred() {
        Optional<InstallableDistribution> first = this.installableDistributions.stream().filter(InstallableDistribution::isPreferred).findFirst();
        return first.orElseGet(() -> this.installableDistributions.stream().findFirst().orElse(null));
    }

    static {
        try {
            CONTEXT = JAXBContext.newInstance((Class[])new Class[]{InstallableDistributions.class, InstallableDistribution.class, SourcesList.class, Source.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to initialize required JAXB configuration", e);
        }
    }
}

