/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.rest.appliance;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.openthinclient.service.common.home.impl.ApplianceConfiguration;

public class TokenManager {
    private final Algorithm algorithm;
    private final Duration expiry;

    public TokenManager(ApplianceConfiguration applianceConfiguration) {
        byte[] secret = new byte[20];
        new SecureRandom().nextBytes(secret);
        this.algorithm = Algorithm.HMAC512((byte[])secret);
        this.expiry = Duration.ofSeconds(applianceConfiguration.getNoVNCTicketExpirySeconds());
    }

    public String createToken(String clientIp) {
        return JWT.create().withClaim("clientIp", clientIp).withExpiresAt(Date.from(Instant.now().plus(this.expiry))).sign(this.algorithm);
    }

    public boolean validateToken(String token, String clientIp) {
        try {
            this.validateAndDecode(token);
            return true;
        }
        catch (JWTVerificationException e) {
            return false;
        }
    }

    public DecodedJWT validateAndDecode(String token) throws JWTVerificationException {
        JWTVerifier verifier = JWT.require((Algorithm)this.algorithm).acceptLeeway(1L).build();
        return verifier.verify(token);
    }
}

