/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.boot;

import com.vaadin.spring.annotation.EnableVaadin;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.spring.annotation.UIScope;
import com.vaadin.spring.boot.VaadinWebsocketEndpointExporter;
import com.vaadin.spring.boot.annotation.EnableVaadinServlet;
import com.vaadin.spring.internal.SpringViewDisplayPostProcessor;
import com.vaadin.spring.navigator.SpringNavigator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
@ConditionalOnClass(value={SpringUI.class})
public class VaadinAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(VaadinAutoConfiguration.class);

    @Bean
    public ServerEndpointExporter websocketEndpointDeployer() {
        return new VaadinWebsocketEndpointExporter();
    }

    @Configuration
    @EnableVaadinServlet
    static class EnableVaadinServletConfiguration
    implements InitializingBean {
        EnableVaadinServletConfiguration() {
        }

        public void afterPropertiesSet() throws Exception {
            logger.debug("{} initialized", (Object)this.getClass().getName());
        }
    }

    @Configuration
    @ConditionalOnClass(name={"com.vaadin.spring.navigator.SpringNavigator"})
    static class EnableSpringVaadinNavigatorConfiguration
    implements InitializingBean {
        EnableSpringVaadinNavigatorConfiguration() {
        }

        @ConditionalOnMissingBean(type={"com.vaadin.spring.navigator.SpringNavigator"})
        @Bean
        @UIScope
        public SpringNavigator vaadinNavigator() {
            return new SpringNavigator();
        }

        public void afterPropertiesSet() throws Exception {
            logger.debug("{} initialized", (Object)this.getClass().getName());
        }
    }

    @Configuration
    static class EnableVaadinNavigatorConfiguration
    implements InitializingBean {
        EnableVaadinNavigatorConfiguration() {
        }

        @Bean
        public static SpringViewDisplayPostProcessor springViewDisplayPostProcessor() {
            return new SpringViewDisplayPostProcessor();
        }

        public void afterPropertiesSet() throws Exception {
            logger.debug("{} initialized", (Object)this.getClass().getName());
        }
    }

    @Configuration
    @EnableVaadin
    static class EnableVaadinConfiguration
    implements InitializingBean {
        EnableVaadinConfiguration() {
        }

        public void afterPropertiesSet() throws Exception {
            logger.debug("{} initialized", (Object)this.getClass().getName());
        }
    }
}

