/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.common;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.openthinclient.service.common.ManagedService;
import org.openthinclient.service.common.Service;
import org.openthinclient.service.common.ServiceConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

public class ServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceManager.class);
    private List<ManagedService> services;
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @Autowired
    void setServices(List<Service> services) {
        this.services = services.stream().map(service -> new ManagedService(this.eventPublisher, this.managerHome, (Service)service)).collect(Collectors.toList());
    }

    public <S extends Service<C>, C extends ServiceConfiguration> ManagedService<S, C> getManagedService(Class<S> serviceType) {
        return this.services.stream().filter(service -> serviceType.isAssignableFrom(service.getService().getClass())).findFirst().orElse(null);
    }

    public List<ManagedService> getManagedServices() {
        return this.services;
    }

    @PostConstruct
    public void startServices() {
        this.services.forEach(managedService -> {
            if (managedService.isAutostartEnabled()) {
                Service<?> service = managedService.getService();
                LOGGER.info("Starting service {}", (Object)service.getClass().getName());
                managedService.start();
            } else {
                LOGGER.info("Service Autostart for {} has been disabled. Not starting the service.", (Object)this.services.getClass().getName());
            }
        });
    }

    @PreDestroy
    public void stopServices() {
        this.services.forEach(managedService -> {
            if (managedService.isRunning()) {
                LOGGER.info("Stopping service {}", (Object)managedService.getService().getClass().getName());
                managedService.stop();
            } else {
                LOGGER.info("Skipping already stopped service {}", (Object)managedService.getService().getClass().getName());
            }
        });
    }
}

