/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.common.license;

import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.PostConstruct;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.license.EncryptedLicense;
import org.openthinclient.service.common.license.License;
import org.openthinclient.service.common.license.LicenseChangeEvent;
import org.openthinclient.service.common.license.LicenseDecrypter;
import org.openthinclient.service.common.license.LicenseError;
import org.openthinclient.service.common.license.LicenseErrorRepository;
import org.openthinclient.service.common.license.LicenseRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Import;

@Import(value={LicenseRepository.class})
public class LicenseManager {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseManager.class);
    private License license;
    private String serverID;
    private LicenseDecrypter licenseDecrypter;
    @Autowired
    LicenseRepository licenseRepository;
    @Autowired
    LicenseErrorRepository licenseErrorRepository;
    @Autowired
    ManagerHome managerHome;
    @Autowired
    ApplicationContext applicationContext;

    @PostConstruct
    public void init() {
        this.licenseErrorRepository.deleteByDatetimeBefore(LocalDateTime.now().minusMonths(1L));
        this.serverID = this.managerHome.getMetadata().getServerID();
        try {
            this.licenseDecrypter = new LicenseDecrypter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadLicense();
    }

    private void loadLicense() {
        List encryptedLicenses = this.licenseRepository.findAll();
        if (encryptedLicenses.size() > 0) {
            this.decryptAndSetLicense((EncryptedLicense)encryptedLicenses.get(0), true);
        }
    }

    private boolean decryptAndSetLicense(EncryptedLicense encryptedLicense, boolean ignoreServerID) {
        License license;
        try {
            license = this.licenseDecrypter.decrypt(encryptedLicense);
        }
        catch (Exception ex) {
            LOG.error("Could not decrypt license", (Throwable)ex);
            this.logError(LicenseError.ErrorType.DECRYPTION_ERROR);
            return false;
        }
        if (!ignoreServerID && !this.serverID.equals(license.server)) {
            LOG.error("License not valid for this server");
            this.logError(LicenseError.ErrorType.SERVER_ID_ERROR);
            return false;
        }
        this.logError(LicenseError.ErrorType.UPDATED);
        this.license = license;
        this.applicationContext.publishEvent((ApplicationEvent)new LicenseChangeEvent(this));
        return true;
    }

    private boolean decryptAndSetLicense(EncryptedLicense encryptedLicense) {
        return this.decryptAndSetLicense(encryptedLicense, false);
    }

    private void saveEncryptedLicense(EncryptedLicense encryptedLicense) {
        this.licenseRepository.deleteAll();
        this.licenseRepository.save(encryptedLicense);
    }

    void logError(LicenseError.ErrorType errorType, String details) {
        this.licenseErrorRepository.save(new LicenseError(errorType, details));
    }

    void logError(LicenseError.ErrorType errorType) {
        this.logError(errorType, null);
    }

    public void deleteLicense() {
        this.licenseRepository.deleteAll();
        this.license = null;
        this.applicationContext.publishEvent((ApplicationEvent)new LicenseChangeEvent(this));
    }

    public boolean setLicense(EncryptedLicense encryptedLicense) {
        boolean success = this.decryptAndSetLicense(encryptedLicense);
        if (success) {
            this.saveEncryptedLicense(encryptedLicense);
        }
        return success;
    }

    public License getLicense() {
        return this.license;
    }

    public List<LicenseError> getErrors() {
        return this.licenseErrorRepository.findTop25ByOrderByDatetimeDesc();
    }

    public License.State getLicenseState(int clientCount) {
        return License.getState(this.license, this.serverID, clientCount);
    }
}

