/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.nfsd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.openthinclient.nfsd.CacheCleaner;
import org.openthinclient.nfsd.PathManager;
import org.openthinclient.nfsd.tea.fattr;
import org.openthinclient.nfsd.tea.nfs_fh;
import org.openthinclient.nfsd.tea.nfspath;
import org.openthinclient.nfsd.tea.nfstime;
import org.openthinclient.service.nfs.NFSExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NFSFile {
    private static final Logger LOG = LoggerFactory.getLogger(NFSFile.class);
    private final nfs_fh handle;
    private final File file;
    private NFSFile parentDirectory;
    private final NFSExport export;
    private FileChannel channel;
    private boolean channelIsRW;
    private fattr attributes;
    private nfspath linkDestination;
    public long lastAccess;

    NFSFile(nfs_fh handle, File file, NFSFile parentDirectory, NFSExport export) {
        this.file = file;
        this.handle = handle;
        this.parentDirectory = parentDirectory;
        this.export = export;
        this.updateTimestamp();
    }

    void updateTimestamp() {
        this.lastAccess = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized FileChannel getChannel(boolean rw) throws IOException {
        this.updateTimestamp();
        if (null != this.channel) {
            if (rw && !this.channelIsRW) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Promoting channel for " + this.file + " to rw.");
                }
                FileChannel fileChannel = this.channel;
                synchronized (fileChannel) {
                    this.channel.close();
                }
                RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
                this.channel = raf.getChannel();
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Opening channel for " + this.file + ". rw=" + rw);
            }
            RandomAccessFile raf = new RandomAccessFile(this.file, rw ? "rw" : "r");
            this.channel = raf.getChannel();
            this.channelIsRW = rw;
            CacheCleaner.registerDirtyFile(this);
        }
        return this.channel;
    }

    synchronized fattr getAttributes() throws FileNotFoundException {
        if (!this.file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("File doesn't exist (anymore?) " + this.file);
            }
            throw new FileNotFoundException(this.file.getPath());
        }
        this.updateTimestamp();
        if (null == this.attributes) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Caching attributes " + this.file);
            }
            this.attributes = new fattr();
            this.attributes.mode = 0;
            this.attributes.uid = 1000;
            this.attributes.gid = 100;
            this.attributes.size = (int)this.file.length();
            this.attributes.type = 0;
            if (this.file.isDirectory()) {
                this.attributes.type = 2;
                this.attributes.mode |= 0x4000;
                if (this.attributes.size == 0) {
                    this.attributes.size = 1;
                }
            } else if (this.file.getName().endsWith(".#%softlink%#")) {
                this.attributes.type = 5;
                this.attributes.mode |= 0xA000;
            } else {
                this.attributes.type = 1;
                this.attributes.mode |= 0x8000;
            }
            if (this.file.canRead()) {
                this.attributes.mode |= 0x16D;
            }
            if (this.file.canWrite()) {
                this.attributes.mode |= 0xC0;
            }
            this.attributes.nlink = 1;
            this.attributes.blocksize = 1024;
            this.attributes.rdev = 19;
            if (this.file.length() != 0L) {
                this.attributes.blocks = (int)(1024L / this.file.length());
            }
            this.attributes.fsid = 10;
            this.attributes.fileid = PathManager.handleToInt(this.handle);
            this.attributes.mtime = this.attributes.atime = new nfstime(this.file.lastModified());
            this.attributes.ctime = this.attributes.atime;
            CacheCleaner.registerDirtyFile(this);
        }
        return this.attributes;
    }

    synchronized nfspath getLinkDestination() throws IOException {
        this.updateTimestamp();
        if (null == this.linkDestination) {
            BufferedReader r = new BufferedReader(new FileReader(this.file));
            String linkres = r.readLine();
            r.close();
            this.linkDestination = new nfspath(linkres);
            CacheCleaner.registerDirtyFile(this);
        }
        return this.linkDestination;
    }

    File getFile() {
        return this.file;
    }

    void flushCache() throws IOException {
        this.attributes = null;
        this.linkDestination = null;
        try {
            if (null != this.channel) {
                this.channel.close();
            }
        }
        finally {
            this.channel = null;
        }
    }

    NFSExport getExport() {
        return this.export;
    }

    NFSFile getParentDirectory() {
        return this.parentDirectory;
    }

    public long getLastAccessTimestamp() {
        return this.lastAccess;
    }

    public boolean isChannelOpen() {
        return this.channel != null;
    }

    public void flushCachedAttributes() {
        this.attributes = null;
    }

    boolean validateHandle(nfs_fh handle) {
        for (int i = 0; i < 8; ++i) {
            if (this.handle.data[i] == handle.data[i]) continue;
            return false;
        }
        return true;
    }

    public void setParentDirectory(NFSFile parentFile) {
        this.parentDirectory = parentFile;
    }

    public nfs_fh getHandle() {
        return this.handle;
    }
}

